unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, TypInfo, checklst;

type
  TIntegerSet = set of 0..SizeOf(Integer) * 8 - 1;
  TForm3 = class(TForm)
    CheckListBox1: TCheckListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
  private
    FControl:TComponent;
    FPropName:String;
  public
    procedure SetList(Control:TComponent; PropName:String);
  end;

var
  Form3: TForm3;

implementation

uses Unit1;

{$R *.DFM}

procedure TForm3.SetList(Control:TComponent; PropName:String);
var
  i: integer;
  PropInfo: PPropInfo;
  TypeInfo: PTypeInfo;
  T: PTypeData;
  S: String;
  Value: Longint;
begin
  PropInfo:= GetPropInfo(Control.ClassInfo,PropName);
  if not Assigned(PropInfo) then Exit;
  TypeInfo:=PropInfo^.PropType^;

  FControl:= Control;
  FPropName:= PropName;

  if TypeInfo.Kind = tkSet then
  begin
    T:= GetTypeData((GetTypeData(TypeInfo))^.CompType^);
    Value := GetOrdProp(Control, PropInfo);
    CheckListBox1.Items.Clear;
    for i := T^.MinValue to T^.MaxValue do
    begin
      S:= GetEnumName((GetTypeData(TypeInfo))^.CompType^, i);
      if S <> '' then
      begin
        CheckListBox1.Items.Add(S);
        if i in TIntegerSet(Value) then
          CheckListBox1.Checked[CheckListBox1.Items.IndexOf(S)]:= True;
      end;
    end;
  end;
end;

procedure TForm3.BitBtn1Click(Sender: TObject);
var
  i: integer;
  PropInfo:PPropInfo;
  TypeInfo: PTypeInfo;
  EnumName: string;
  Value: Longint;
  EnumType: PTypeInfo;
begin
  PropInfo:= GetPropInfo(FControl.ClassInfo,FPropName);
  TypeInfo:=PropInfo^.PropType^;

  if TypeInfo.Kind = tkSet then
  begin
    EnumType:= GetTypeData(TypeInfo)^.CompType^;
    Value:= 0;
    for i:= 0 to CheckListBox1.Items.Count -1 do
    begin
      if CheckListBox1.Checked[i] then
      begin
        EnumName:= CheckListBox1.Items[i];
        Include(TIntegerSet(Value), GetEnumValue(EnumType, EnumName));
      end;
    end;
    SetOrdProp(FControl, PropInfo, Value);
  end;
end;

end.
