unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, DsnUnit, DsnSubGr, DsnSubDp, DsnSubCl, DsnSubMl, DsnSubRS,
  DsnProp, DsnSpctr, ExtCtrls, Db, DBTables, DsnPanel, DBCtrls, StdCtrls,
  Spin, Menus, TypInfo, ShellAPI;

type
  TForm1 = class(TForm)
    DsnInspector1: TDsnInspector;
    Panel1: TPanel;
    DsnRegister1: TDsnRegister;
    DsnRSRegister1: TDsnRSRegister;
    DsnClRegister1: TDsnClRegister;
    DsnDpRegister1: TDsnDpRegister;
    DsnPanel1: TDsnPanel;
    Table1: TTable;
    Table1Category: TStringField;
    Table1SpeciesName: TStringField;
    Table1Lengthcm: TFloatField;
    Table1Length_In: TFloatField;
    Table1Common_Name: TStringField;
    Table1Notes: TMemoField;
    Table1Graphic: TBlobField;
    DataSource1: TDataSource;
    Label1: TLabel;
    Dpst_TDBText: TDBText;
    DsnDpstPanel: TPanel;
    ArrowButton1: TArrowButton;
    DsnButton1: TDsnButton;
    Dpst_TPanel: TPanel;
    DsnButton2: TDsnButton;
    Dpst_TPanelX: TPanel;
    DsnButton3: TDsnButton;
    DBImage2: TDBImage;
    DBText1: TDBText;
    PopupMenu1: TPopupMenu;
    Up: TMenuItem;
    SetLeft: TMenuItem;
    Delete: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    ColorDialog1: TColorDialog;
    FontDialog1: TFontDialog;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Button1: TButton;
    Button2: TButton;
    Label3: TLabel;
    Panel2: TPanel;
    DsnStage1: TDsnStage;
    Label2: TLabel;
    DBNavigator1: TDBNavigator;
    DBMemo1: TDBMemo;
    DBImage1: TDBImage;
    BitBtn1: TBitBtn;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    OpenHelpFile1: TMenuItem;
    HomePage1: TMenuItem;
    USA1: TMenuItem;
    JapanSite1: TMenuItem;
    DsnSwitch1: TDsnSwitch;
    DsnSwitch2: TDsnSwitch;
    DsnSwitch3: TDsnSwitch;
    DsnSwitch4: TDsnSwitch;
    Panel3: TPanel;
    Label4: TLabel;
    Design1: TMenuItem;
    Start1: TMenuItem;
    Stop1: TMenuItem;
    procedure DsnSwich1Click(Sender: TObject);
    procedure DsnStage1DeleteQuery(Sender: TObject; Component: TComponent;
      var CanDelete: Boolean);
    procedure UpClick(Sender: TObject);
    procedure SetLeftClick(Sender: TObject);
    procedure DeleteClick(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure DsnInspector1BtnClick(Sender: TObject;
      Targets: TSelectedComponents; PropName: String; var Value: String);
    procedure DsnStage1ControlCreate(Sender: TObject;
      Component: TComponent);
    procedure DsnStage1Popup(Sender: TObject);
    procedure OpenHelpFile1Click(Sender: TObject);
    procedure USA1Click(Sender: TObject);
    procedure JapanSite1Click(Sender: TObject);
    procedure DsnStage1CoverQuery(Sender: TObject; Component: TComponent;
      var CanCover: TCoverAccept);
    procedure DsnStage1SelectQuery(Sender: TObject; Component: TComponent;
      var CanSelect: TSelectAccept);
    procedure Start1Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure Design1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  Unit2, Unit3;

procedure TForm1.DsnSwich1Click(Sender: TObject);
var
  i: integer;
  DsnSwitch: TDsnSwitch;
begin
  for i:= 0 to Panel1.ControlCount -1 do
    if Panel1.Controls[i] is TDsnSwitch then
    begin
      DsnSwitch:= TDsnSwitch(Panel1.Controls[i]);
      if DsnSwitch <> Sender then
        DsnSwitch.Enabled := not TDsnSwitch(Sender).Down;
    end;
end;

procedure TForm1.DsnStage1DeleteQuery(Sender: TObject;
  Component: TComponent; var CanDelete: Boolean);
begin
  if (Component = DBNavigator1) or (Component = BitBtn1) then
    CanDelete:= False;
  if not CanDelete then
    ShowMessage(Component.Name + ' This Can Not Be Deleted');
end;

procedure TForm1.UpClick(Sender: TObject);
var
  i,n:Integer;
begin
  for i:= 0 to DsnStage1.TargetsCount -1 do
  begin
    n:= DsnStage1.Targets[i].Top;
    DsnStage1.Targets[i].Top:= n-2;
  end;
  DsnStage1.UpdateControl;
end;

procedure TForm1.SetLeftClick(Sender: TObject);
var
  i,n:Integer;
begin
  n:= DsnStage1.Targets[0].Left;
  for i:= 1 to DsnStage1.TargetsCount -1 do
    if n > DsnStage1.Targets[i].Left then
      n:= DsnStage1.Targets[i].Left;
  for i:= 0 to DsnStage1.TargetsCount -1 do
    DsnStage1.Targets[i].Left:= n;
end;

procedure TForm1.DeleteClick(Sender: TObject);
begin
  DsnStage1.Delete;
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  DsnStage1.Copy;
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
  DsnStage1.Paste;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i,j,n,m:integer;
  List: TList;
begin
  //Sort by TabOrder

  List:= TList.Create;
  n:= 0;
  for i:= 0 to DsnStage1.ControlCount -1 do
    if DsnStage1.Controls[i] is TWinControl then
      Inc(n);

  m:= DsnStage1.ControlCount - n;

  for i:= n -1 downto 0 do
    for j:= i downto 0 do
      if TWinControl(DsnStage1.Controls[j+m]).TabOrder = i then
      begin
        List.Add(DsnStage1.Controls[j+m]);
        DsnStage1.RemoveControl(DsnStage1.Controls[j+m]);
      end;

  for i:= List.Count -1 downto 0 do
    DsnStage1.InsertControl(TControl(List[i]));

  List.Free;

  //Save Controls
  
  SaveDialog1.InitialDir:=ExtractFilePath(Application.ExeName);
  if SaveDialog1.Execute then
    DsnStage1.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  OpenDialog1.InitialDir:=ExtractFilePath(Application.ExeName);
  if OpenDialog1.Execute then
    DsnStage1.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.DsnInspector1BtnClick(Sender: TObject;
  Targets: TSelectedComponents; PropName: String; var Value: String);
var
  PropInfo:PPropInfo;
  aFont:TFont;
  i:integer;
  Component: TComponent;
begin
  if PropName = 'DataField' then
  begin
    if Form2 = nil then
      Form2:=TForm2.Create(Self);

    Form2.ShowModal;

    Value:=Form2.SelectedField;
  end;

  if PropName = 'VisibleButtons' then
  begin
    if Form3 = nil then
      Form3:=TForm3.Create(Self);

    Component:= Targets[0];

    Form3.SetList(Component, PropName);
    Form3.ShowModal;

    Form3.Free;
    Form3:= nil;
  end;


  if PropName = 'Caption' then
    Value:= InputBox('CaptionDialog', 'Caption', Value);

  if PropName = 'Color' then
    if ColorDialog1.Execute then
      Value:=IntToStr(ColorDialog1.Color);


  if PropName = 'Font' then
  begin
    Component:= Targets[0];
    PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
    aFont:=TFont(GetOrdProp(Component,PropInfo));
    FontDialog1.Font.Assign(aFont);
    if FontDialog1.Execute then
      for i:= 0 to Targets.Count -1 do
      begin
        Component:= Targets[i];
        PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
        aFont:=TFont(GetOrdProp(Component,PropInfo));
        aFont.Assign(FontDialog1.Font);
      end;
  end;
end;

procedure TForm1.DsnStage1ControlCreate(Sender: TObject;
  Component: TComponent);
begin
  if Component is TDBText then
    TDBText(Component).DataSource:= DataSource1;
end;

procedure TForm1.DsnStage1Popup(Sender: TObject);
begin
  if DsnStage1.TargetsCount <= 1 then
    SetLeft.Enabled:= False
  else
    SetLeft.Enabled:= True;

  if not DsnStage1.CanCopy then
    Copy1.Enabled:= False
  else
    Copy1.Enabled:= True;

  if not DsnStage1.CanPaste then
    Paste1.Enabled:= False
  else
    Paste1.Enabled:= True;
end;

Procedure ShellExec(Hwnd:longint;fileNam,shellMode:string);
begin
  ShellExecute(Hwnd, PChar(shellMode), PChar(fileNam), '', '', 1);
end;

procedure TForm1.OpenHelpFile1Click(Sender: TObject);
var
  FileName:string;
  n: integer;
begin
  try
    FileName:=ExtractFilePath(Application.ExeName) + 'dsnsys.hlp';
    n:= ShellExecute(Handle,'Open',PChar(FileName),'','',SW_SHOW);
    if n = ERROR_FILE_NOT_FOUND then
    begin
      FileName:=ExtractFilePath(Application.ExeName) + 'dsnsyse.hlp';
      ShellExecute(Handle,'Open',PChar(FileName),'','',SW_SHOW);
    end;
  except
  end;
end;

procedure TForm1.USA1Click(Sender: TObject);
var
  URL:string;
begin
  try
    URL:='http://www.geocities.com/ResearchTriangle/Thinktank/5653/';
    ShellExecute(Handle, 'Open',PChar(URL), '','', SW_SHOW);
  except
  end;
end;

procedure TForm1.JapanSite1Click(Sender: TObject);
var
  URL:string;
begin
  try
    URL:='http://www.vector.co.jp/authors/VA005818/';
    ShellExecute(Handle, 'Open',PChar(URL), '','', SW_SHOW);
  except
  end;
end;

procedure TForm1.DsnStage1CoverQuery(Sender: TObject;
  Component: TComponent; var CanCover: TCoverAccept);
begin
  if Component = Panel3 then
    CanCover:= caNoAccept;
end;

procedure TForm1.DsnStage1SelectQuery(Sender: TObject;
  Component: TComponent; var CanSelect: TSelectAccept);
begin
  if Component = Label4 then
    CanSelect:= [];
end;

procedure TForm1.Start1Click(Sender: TObject);
begin
  DsnSwitch2.DesignOn;
end;

procedure TForm1.Stop1Click(Sender: TObject);
begin
  DsnSwitch2.DesignOff;
end;

procedure TForm1.Design1Click(Sender: TObject);
begin
  Start1.Enabled:= not DsnStage1.Designing;
  Stop1.Enabled:= DsnStage1.Designing;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
