unit Unit5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, DsnProp, DsnSpctr, DsnUnit, DsnSubMl, DsnSubGr, DsnSubDp, ExtCtrls,
  StdCtrls, Mask, DBCtrls, ComCtrls, Db, DBTables, Unit1, DsnSelect,
  Buttons, TypInfo;

type
  TDsnForm = class(TForm)
    DsnStage1: TDsnStage;
    DsnRegister1: TDsnDpRegister;
    DsnInspector1: TDsnInspector;
    MainMenu1: TMainMenu;
    Layout1: TMenuItem;
    Start1: TMenuItem;
    DataSource1: TDataSource;
    Table1: TTable;
    Cancel1: TMenuItem;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    DBImage1: TDBImage;
    DBNavigator1: TDBNavigator;
    Label1: TLabel;
    DBEdit1: TDBEdit;
    DsnSelect1: TDsnSelect;
    Button2: TButton;
    Label3: TLabel;
    Label2: TLabel;
    ColorDialog1: TColorDialog;
    FontDialog1: TFontDialog;
    BitBtn1: TBitBtn;
    procedure Start1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure DsnSelect1ChangeSelected(Sender: TObject;
      Targets: TSelectedComponents; Operation: TSelectOperation);
    procedure DsnStage1ControlCreate(Sender: TObject;
      Component: TComponent);
    procedure DsnStage1DeleteQuery(Sender: TObject; Component: TComponent;
      var CanDelete: Boolean);
    procedure DsnInspector1BtnClick(Sender: TObject;
      Targets: TSelectedComponents; PropName: String; var Value: String);
    procedure FormDestroy(Sender: TObject);
    procedure Cancel1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    Stream: TStream;
  public

  end;

var
  DsnForm: TDsnForm;

implementation

uses Unit2, Unit3;

{$R *.DFM}

procedure TDsnForm.FormCreate(Sender: TObject);
begin
  //DsnRegister and DsnPanel are on different form,
  //1) You have to link them by coding.

  DsnRegister1.DsnPanel:= Form1.DsnPanel1;
  DsnRegister1.ArrowButton:= Form1.ArrowButton1;

  //2) You have to Register Classes before Creating.
  RegisterClass(TDBMemo);
end;

procedure TDsnForm.Start1Click(Sender: TObject);
begin
  if not DsnRegister1.Designing then
  begin
    //Save Layout
    if Stream = nil then
      Stream:= TMemoryStream.Create;
    DsnStage1.SaveToStream(Stream);
    //ObjectInspector.Position Setting
    //You have to do before starting Design.
    DsnInspector1.Position.Top:= 120;
    DsnInspector1.Position.Left:= 10;
    //Starting Design
    DsnRegister1.Designing:= True;
    //Select Control by the Method
    DsnSelect1.Select(DBImage1);
    //Menu
    Start1.Caption:= 'End';
    Cancel1.Enabled:= True;
  end
  else
  begin
    //Ending Design
    DsnRegister1.Designing:= False;
    //Menu
    Start1.Caption:= 'Start';
    Cancel1.Enabled:= False;
  end;
end;

procedure TDsnForm.Button2Click(Sender: TObject);
var
  List: TList;
begin
  //Select Controls by the Method
  List:= TList.Create;
  List.Add(Label1);
  List.Add(Label2);
  DsnSelect1.MultipleSelect(List);
  List.Free;
end;

procedure TDsnForm.DsnSelect1ChangeSelected(Sender: TObject;
  Targets: TSelectedComponents; Operation: TSelectOperation);
begin
  //Change Selected Control by the Control that user selected.
  if Operation = opAdd then
  begin
    if Targets.List.IndexOf(Label3) > -1 then
      DsnSelect1.Select(DBImage1);

    if Targets.List.IndexOf(PageControl1) > -1 then
      DsnSelect1.Select(PageControl1.ActivePage); 
  end;
end;

procedure TDsnForm.DsnStage1ControlCreate(Sender: TObject;
  Component: TComponent);
var
  PropInfo:PPropInfo; // TypInfo.pas
  Value: String;
begin
  //If the New Component is DBControl....
  //DataSource
  PropInfo:= GetPropInfo(Component.ClassInfo,'DataSource');

  if PropInfo <> nil then
    SetOrdProp(Component,PropInfo,Integer(DataSource1));

  //DataField
  PropInfo:= GetPropInfo(Component.ClassInfo,'DataField');

  if PropInfo <> nil then
  begin
    if Form2 = nil then
      Form2:=TForm2.Create(Self);

    Form2.ShowModal;

    Value:=Form2.SelectedField;

    SetStrProp(Component,PropInfo,Value);
  end;

  //Compare with the Sample 1's Coding of Same Event-Handler.
end;

procedure TDsnForm.DsnStage1DeleteQuery(Sender: TObject;
  Component: TComponent; var CanDelete: Boolean);
begin
  if (Component = DBNavigator1) or (Component is TDBImage)
    or (Component is TLabel) then
    CanDelete:= False;
  if not CanDelete then
    ShowMessage(Component.Name + ', This Can Not Be Deleted');
end;

procedure TDsnForm.DsnInspector1BtnClick(Sender: TObject;
  Targets: TSelectedComponents; PropName: String; var Value: String);
// Targets:  List of Selected Controls
// PropName: Property Name of User Selecting
var
  PropInfo:PPropInfo; // TypInfo.pas
  aFont:TFont;
  i:integer;
  Component: TComponent;
begin
// Object Inspector Buntton Click
// Popupmenu Click

  if PropName = 'DataField' then
  begin
    if Form2 = nil then
      Form2:=TForm2.Create(Self);

    Form2.ShowModal;

    Value:=Form2.SelectedField;
  end;


  if PropName = 'Color' then
    if ColorDialog1.Execute then
      Value:=IntToStr(ColorDialog1.Color);


  if PropName = 'Font' then
  begin
    Component:= Targets[0];
    PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
    aFont:=TFont(GetOrdProp(Component,PropInfo));
    FontDialog1.Font.Assign(aFont);
    if FontDialog1.Execute then
      for i:= 0 to Targets.Count -1 do
      begin
        Component:= Targets[i];
        PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
        aFont:=TFont(GetOrdProp(Component,PropInfo));
        aFont.Assign(FontDialog1.Font);
      end;
  end;
end;

procedure TDsnForm.FormDestroy(Sender: TObject);
begin
    if Stream <> nil then
      Stream.Free;
end;

procedure TDsnForm.Cancel1Click(Sender: TObject);
begin
  //Ending Design
  DsnRegister1.Designing:= False;
  //Menu
  Start1.Caption:= 'Start';
  Cancel1.Enabled:= False;
  //Load Layout
  DsnStage1.LoadFromStream(Stream);
end;

procedure TDsnForm.BitBtn1Click(Sender: TObject);
begin
  Form3.Showmodal;
end;

end.
