unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, DsnUnit, DsnAgent, DsnSubGr, DsnSubDp, StdCtrls, Buttons,
  ExtCtrls, Spin;

const
  DsnSysConst = 570;
//  MY_CONTROLLIST  =   WM_USER + DsnSysConst;
//  MY_DELCOMPONENT =   WM_USER + DsnSysConst + 1;
//  MY_RECTFOCUS =      WM_USER + DsnSysConst + 2;
  RM_START =          WM_USER + DsnSysConst + 3;
  RM_FINISH =         WM_USER + DsnSysConst + 4;
  MH_SELECT =         WM_USER + DsnSysConst + 5;
  AG_DESTROY =        WM_USER + DsnSysConst + 6;
  CI_SELECT =         WM_USER + DsnSysConst + 7;
//  CI_SETPROPERTY =    WM_USER + DsnSysConst + 8;
//  FA_KILLCOMPONENT =  WM_USER + DsnSysConst + 9;
//  Mini_Rubberband = 8;

type
  TSampleAgent= class(TDsnGrCtrl)
  protected
    procedure ClientWndProc(var Message: TMessage);override;
    procedure EndSubClassing;override;
    procedure ChangeHandele(Handle: THandle);override;
  public
    ClientName: String;
    Cnt: Integer;
    constructor CreateInstance(AClient: TWinControl);override;
  end;

  TSampleRegister = class(TDsnDpRegister)
  protected
    function CreateSubCtrl(AParent:TWinControl):TDsnCtrl;override;
  end;

  TForm1 = class(TForm)
    DsnStage1: TDsnStage;
    DsnSwitch1: TDsnSwitch;
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    ComboBox1: TComboBox;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Label1: TLabel;
    Panel1: TPanel;
    Edit1: TEdit;
    Button6: TButton;
    BitBtn1: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure DsnStage1DeleteQuery(Sender: TObject; Component: TComponent;
      var CanDelete: Boolean);
    procedure Button6Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    SampleRegister: TSampleRegister;
    Ctrl: TComponent;
    procedure ComponentsProc(Component: TComponent);
    procedure CheckName(Reader: TReader; Component: TComponent;
      var Name: String);
  public
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

{ TSampleAgent }

procedure TSampleAgent.ClientWndProc(var Message: TMessage);
begin
  if Message.Msg <> WM_NCHITTEST then
    Form1.Memo1.Lines.Add
       (ClientName + ', ' + Format('%4D, ',[Cnt]) + IntToHex(Message.Msg, 5));
  Inc(Cnt);
  inherited;
end;

procedure TSampleAgent.EndSubClassing;
begin
  Form1.Memo1.Lines.Add('End-Sub-classing, ' + ClientName);
  inherited;
end;

constructor TSampleAgent.CreateInstance(AClient: TWinControl);
begin
  inherited;
  ClientName:= AClient.Name;
  Cnt:= 0;
  Form1.Memo1.Lines.Add('Sub-classing, ' + ClientName);
end;

procedure TSampleAgent.ChangeHandele;
begin
  inherited;
  Form1.Memo1.Lines.Add('Re-Sub-classing, ' + ClientName);
end;

{ TSampleRegister }

function TSampleRegister.CreateSubCtrl(AParent: TWinControl): TDsnCtrl;
begin
  Result:= TSampleAgent.CreateInstance(AParent);
end;

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  SampleRegister:= TSampleRegister.Create(Self);
  SampleRegister.DsnStage:=DsnStage1;
  DsnSwitch1.DsnRegister:= SampleRegister;
  Memo1.Text:= '';
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  SampleRegister.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Memo1.Text:= '';
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  ComboBox1.Style:= csDropDownList;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  ComboBox1.Style:= csDropDown;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  if SampleRegister.Designing then
    DsnStage1.Delete;
end;

procedure TForm1.DsnStage1DeleteQuery(Sender: TObject;
  Component: TComponent; var CanDelete: Boolean);
begin
  if Component = ComboBox1 then
  begin
    Button3.Enabled:= False;
    Button4.Enabled:= False;
  end;
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  MemoryStream:TMemoryStream;
  Writer:TWriter;
  Reader:TReader;
begin
  //Copy
  MemoryStream:=TMemoryStream.Create;
  try
    Writer:=TWriter.Create(MemoryStream,4096);
    try
      Writer.RootAncestor := nil;
      Writer.Ancestor := nil;
      Writer.Root := Self;
      Writer.WriteSignature;
      Writer.WriteComponent(Panel1);
      Writer.WriteListEnd;
    finally
      Writer.Free;
    end;
  //Paste
    MemoryStream.Position:=0;
    Reader:=TReader.Create(MemoryStream,4096);
    try
      Reader.OnSetName:=CheckName;
      Reader.ReadComponents(Self,DsnStage1,ComponentsProc);
    finally
      Reader.Free;
    end;
  finally
    MemoryStream.Free;
    TControl(Ctrl).Top:= 150;
    TControl(Ctrl).Left:= 150;
  end;
end;

procedure TForm1.CheckName(Reader:TReader; Component:TComponent; var Name:String);
var
 i:integer;
 S:String;
begin
  i := 0;
  S:=Component.ClassName;
  Delete(S,1,1);
  while FindComponent(Name) <> nil do
  begin
    Inc(I);
    Name := Format('%s%d', [S, I]);
  end;
end;

procedure TForm1.ComponentsProc(Component:TComponent);
begin
  Ctrl:= Component;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  Form2.ShowModal;
end;

end.

