unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, DsnPanel, DsnUnit, DsnSubMl, DsnSubGr, DsnSubDp, StdCtrls,
  DBCtrls, Db, DBTables, Buttons, ExtCtrls, DsnProp, DsnSpctr;

type
  TForm1 = class(TForm)
    DsnPanel1: TDsnPanel;
    DsnStage1: TDsnStage;
    DsnSwitch1: TDsnSwitch;
    DataSource1: TDataSource;
    Table1: TTable;
    DBImage1: TDBImage;
    DBNavigator1: TDBNavigator;
    DBText1: TDBText;
    DBText2: TDBText;
    DBMemo1: TDBMemo;
    PopupMenu1: TPopupMenu;
    DsnDpRegister1: TDsnDpRegister;
    Dpst_TDBText: TDBText;
    DsnDpstPanel: TPanel;
    ArrowButton1: TArrowButton;
    DsnButton1: TDsnButton;
    up1: TMenuItem;
    down1: TMenuItem;
    left1: TMenuItem;
    right1: TMenuItem;
    N1: TMenuItem;
    delete1: TMenuItem;
    DsnInspector1: TDsnInspector;
    Dpst_TPanel: TPanel;
    DsnButton2: TDsnButton;
    Dpst_TLabel: TLabel;
    DsnButton3: TDsnButton;
    BitBtn1: TBitBtn;
    FontDialog1: TFontDialog;
    ColorDialog1: TColorDialog;
    Button1: TButton;
    Button3: TButton;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    Button2: TButton;
    procedure up1Click(Sender: TObject);
    procedure down1Click(Sender: TObject);
    procedure left1Click(Sender: TObject);
    procedure right1Click(Sender: TObject);
    procedure DsnStage1DeleteQuery(Sender: TObject; Component: TComponent;
      var CanDelete: Boolean);
    procedure DsnInspector1BtnClick(Sender: TObject;
      Targets: TSelectedComponents; PropName: String; var Value: String);
    procedure delete1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DsnStage1ControlCreate(Sender: TObject;
      Component: TComponent);
    procedure Button3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses
  TypInfo, Unit2, Unit3, Unit4, ShellAPI;

// PopupMenu1 is CoverMenu Property of DsnStage1
procedure TForm1.up1Click(Sender: TObject);
var
  i,n:Integer;
begin
  //Changing Top property of Targets
  for i:= 0 to DsnStage1.TargetsCount -1 do
  begin
    n:= DsnStage1.Targets[i].Top;
    DsnStage1.Targets[i].Top:= n-2; // up
  end;
  DsnStage1.UpdateControl;
end;

// PopupMenu1 is CoverMenu Property of DsnStage1
procedure TForm1.down1Click(Sender: TObject);
var
  i,n:Integer;
begin
  //Changing Top property of Targets
  for i:= 0 to DsnStage1.TargetsCount -1 do
  begin
    n:= DsnStage1.Targets[i].Top;
    DsnStage1.Targets[i].Top:= n+2; // down
  end;
  DsnStage1.UpdateControl;
end;

// PopupMenu1 is CoverMenu Property of DsnStage1
procedure TForm1.left1Click(Sender: TObject);
var
  i,n:Integer;
begin
  //Changing Left property of Targets
  for i:= 0 to DsnStage1.TargetsCount -1 do
  begin
    n:= DsnStage1.Targets[i].Left;
    DsnStage1.Targets[i].Left:= n-2; // left
  end;
  DsnStage1.UpdateControl;
end;

// PopupMenu1 is CoverMenu Property of DsnStage1
procedure TForm1.right1Click(Sender: TObject);
var
  i,n:Integer;
begin
  //Changing Left property of Targets
  for i:= 0 to DsnStage1.TargetsCount -1 do
  begin
    n:= DsnStage1.Targets[i].Left;
    DsnStage1.Targets[i].Left:= n+2; // right
  end;
  DsnStage1.UpdateControl;
end;

procedure TForm1.DsnStage1DeleteQuery(Sender: TObject;
  Component: TComponent; var CanDelete: Boolean);
begin
  if (Component = DBNavigator1) or (Component = BitBtn1) then
    CanDelete:= False;
  if not CanDelete then
    ShowMessage(Component.Name + ', This Can Not Be Deleted');
end;

procedure TForm1.DsnInspector1BtnClick(Sender: TObject;
  Targets: TSelectedComponents; PropName: String; var Value: String);
// Targets:  List of Selected Controls
// PropName: Property Name of User Selecting
var
  PropInfo:PPropInfo; // TypInfo.pas
  aFont:TFont;
  i:integer;
  Component: TComponent;
begin
// Object Inspector Buntton Click
// Popupmenu Click

  if PropName = 'DataField' then
  begin
    if Form2 = nil then
      Form2:=TForm2.Create(Self);

    Form2.ShowModal;

    Value:=Form2.SelectedField;
  end;


  if PropName = 'Color' then
    if ColorDialog1.Execute then
      Value:=IntToStr(ColorDialog1.Color);


  if PropName = 'Font' then
  begin
    Component:= Targets[0];
    PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
    aFont:=TFont(GetOrdProp(Component,PropInfo));
    FontDialog1.Font.Assign(aFont);
    if FontDialog1.Execute then
      for i:= 0 to Targets.Count -1 do
      begin
        Component:= Targets[i];
        PropInfo:= GetPropInfo(Component.ClassInfo,PropName);
        aFont:=TFont(GetOrdProp(Component,PropInfo));
        aFont.Assign(FontDialog1.Font);
      end;
  end;
end;

// PopupMenu1 is CoverMenu Property of DsnStage1
procedure TForm1.delete1Click(Sender: TObject);
begin
  DsnStage1.Delete;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i: integer;
  S: String;
begin
  if not DsnStage1.Designing then Exit;

  S:= '';
  
  for i := 0 to DsnStage1.TargetsCount -1 do
    S:= S + DsnStage1.Targets[i].Name + #13;

  ShowMessage(S);
end;

procedure TForm1.DsnStage1ControlCreate(Sender: TObject;
  Component: TComponent);
begin
  if Component is TDBText then
    TDBText(Component).DataSource:= DataSource1;

  //Compare with the Sample 5's Coding of Same Event-Handler.
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  S: String;
begin
  S:= ExtractFilePath(Application.ExeName) + 'SampleDesign';
  DsnStage1.LoadFromFile(S);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  Form3.Showmodal;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  Form4.Showmodal;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  URL:string;
begin
  try
    URL:='http://www.geocities.co.jp/Technopolis/5927/';
    ShellExecute(Handle, 'Open',PChar(URL), '','', SW_SHOW);
  except
  end;
end;

end.
