{
*******************************************************************

TFormOpenDialog and TFormSaveDialog demo
Copyright 1997 Dmitry Streblechenko
dmitrys@asu.edu
*******************************************************************
}

unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls,Buttons, Grids, Mask, BorBtns, ComCtrls,
  dsdialog, Menus, checklst, ShellAPI;

type

  TSlaveForm = class(TForm)
    OpenDialog: TFormOpenDialog;
    Label1: TLabel;
    Label2: TLabel;
    Memo: TMemo;
    Bevel2: TBevel;
    Bevel1: TBevel;
    Label9: TLabel;
    Label11: TLabel;
    MorePanel: TPanel;
    Label3: TLabel;
    SelectedFileListBox: TListBox;
    Label4: TLabel;
    OkButtonCaption: TEdit;
    CancelButtonCaption: TEdit;
    Label5: TLabel;
    HelpButtonCaption: TEdit;
    Label6: TLabel;
    VisibleControls: TCheckListBox;
    Label7: TLabel;
    MoreButton: TButton;
    Bevel3: TBevel;
    Label12: TLabel;
    ShowAs: TRadioGroup;
    Label8: TLabel;
    DroppedFiles: TListBox;
    ClearBtn: TButton;
    Label13: TLabel;
    procedure OpenDialogSelectionChange(Sender: TObject);
    procedure OkButtonCaptionChange(Sender: TObject);
    procedure OpenDialogShow(Sender: TObject);
    procedure VisibleControlsClickCheck(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MoreButtonClick(Sender: TObject);
    procedure ShowAsClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
  private
    { Private declarations }
    DeltaH:integer;
    OldListBoxProc:TWndMethod;
    procedure NewListBoxProc(var Message:TMessage);
  public
    { Public declarations }
  end;


var
  SlaveForm: TSlaveForm;

implementation


{$R *.DFM}


{*************  TSlaveForm  *****************}

procedure TSlaveForm.OpenDialogSelectionChange(Sender: TObject);
var MS:TMemoryStream;
    FS:TFileStream;
    Bytes16:array[0..15] of byte;
    Lines:string;
    st:string[255];
    i,count,br,p:integer;
begin
 SelectedFileListBox.Items.Assign(OpenDialog.Files);
 if FileExists(OpenDialog.FileName) then begin
  Memo.Clear;
  try
   MS:=TMemoryStream.Create;
   try
    FS:=nil;
    FS:=TFileStream.Create(OpenDialog.FileName,fmOpenRead or fmShareDenyNone);
   except
    Memo.Lines.Add(' << Error reading file "'+OpenDialog.FileName+'" >> ');
    Exit;
   end;
   if FS.Size < $4000 then MS.Size:=FS.Size else MS.Size:=$4000;
   FS.Read(MS.Memory^,MS.Size);
   if ShowAs.ItemIndex=0 then begin //Text
    Lines:='';
    SetLength(Lines,MS.Size);
    Move(MS.Memory^,Lines[1],MS.Size);
    p:=length(PChar(Lines));
    if p < MS.Size then begin
     SetLength(Lines,p);
     Lines:=Lines+#13#10' <<  Truncated at first binary zero >>';
    end
    else if FS.Size > MS.Size then begin
     Lines:=Lines+#13#10' <<  Truncated at '+IntToStr(MS.Size div 1024)+' kb >> ';
    end;
   end else begin                   //Hex
    Lines:='';
    SetLength(Lines,(MS.Size div SizeOf(Bytes16)+1)*(6+SizeOf(Bytes16)*3+3+SizeOf(Bytes16)+2));
    count:=0;
    while MS.Position < MS.Size do begin
     st:='';
     st:=st+IntToHex(MS.Position,4)+': ';
     br:=MS.Read(Bytes16,SizeOf(Bytes16));
     for i:=0 to br-1 do st:=st+IntToHex(Bytes16[i],2)+' ';
     for i:=br to 15 do st:=st+'   ';
     st:=st+' | ';
     for i:=0 to br-1 do if (Bytes16[i] >=32) and (Bytes16[i]<=126) then st:=st+char(Bytes16[i])
                                                                    else st:=st+'.';
     st:=st+#13#10;
     Move(st[1],Lines[count+1],length(st));
     count:=count+length(st);
    end;
    SetLength(Lines,count);
    if FS.Size > MS.Size then begin
    Lines:=Lines+#13#10' <<  Truncated at '+IntToStr(MS.Size div 1024)+' kb >> ';
   end;
   end;
   Memo.Lines.Text:=Lines;
  finally
   MS.Destroy;
   if FS <> nil then FS.Destroy;
  end;
 end;
end;

procedure TSlaveForm.OkButtonCaptionChange(Sender: TObject);
begin
 OpenDialog.OkButtonCaption:=OkButtonCaption.Text;
 OpenDialog.CancelButtonCaption:=CancelButtonCaption.Text;
 OpenDialog.HelpButtonCaption:=HelpButtonCaption.Text;
end;

procedure TSlaveForm.FormCreate(Sender: TObject);
begin
 DeltaH:=MorePanel.Height;
 OldListBoxProc:=DroppedFiles.WindowProc;
 DroppedFiles.WindowProc:=NewListBoxProc;
end;

procedure TSlaveForm.NewListBoxProc(var Message:TMessage);
var NameLen,NumFiles,i:integer;
    FileName:string;
begin
 if (Message.Msg=WM_DROPFILES) then begin
  NumFiles := DragQueryFile(Message.wParam, $FFFFFFFF, Nil, 0);
  for i := 0 to NumFiles-1 do begin
      NameLen := DragQueryFile(Message.wParam, i, Nil , 0);
      SetLength(FileName,NameLen);
      DragQueryFile(Message.wParam, i, PChar(FileName), NameLen+1);
      DroppedFiles.Items.Add(FileName);
  end;
 end else
  OldListBoxProc(Message);
end;

procedure TSlaveForm.OpenDialogShow(Sender: TObject);
var OldOnClick,OldOnChange:TNotifyEvent;
    i:TVisibleControls;
begin
 OldOnClick:=VisibleControls.OnClick;
 VisibleControls.OnClick:=nil;
 for i:=Low(i) to High(i) do begin
   VisibleControls.Checked[integer(i)]:=(i in OpenDialog.VisibleControls);
 end;
 VisibleControls.OnClick:=OldOnClick;

 OldOnChange:=OkButtonCaption.OnChange;
 OkButtonCaption.OnChange:=nil;
 HelpButtonCaption.OnChange:=nil;
 CancelButtonCaption.OnChange:=nil;
 OkButtonCaption.Text:=OpenDialog.OkButtonCaption;
 HelpButtonCaption.Text:=OpenDialog.HelpButtonCaption;
 CancelButtonCaption.Text:=OpenDialog.CancelButtonCaption;
 OkButtonCaption.OnChange:=OldOnChange;
 HelpButtonCaption.OnChange:=OldOnChange;
 CancelButtonCaption.OnChange:=OldOnChange;

 //Let Window know we can accept dropped files
 //Don't do that in the OnCreate event!, Handle might
 //be recreated along the way.
 DragAcceptFiles(DroppedFiles.Handle,TRUE);
end;

procedure TSlaveForm.VisibleControlsClickCheck(Sender: TObject);
var i:TVisibleControls;
    s:TVisibleControlsSet;
begin
 for i:=Low(i) to High(i) do begin
   if  VisibleControls.Checked[integer(i)] then s:=s+[i] else s:=s-[i]
 end;
 OpenDialog.VisibleControls:=s;
end;


procedure TSlaveForm.MoreButtonClick(Sender: TObject);
begin
 if MorePanel.Height=0 then begin
   Height:=Height+DeltaH;
   MorePanel.Height:=DeltaH;
   MoreButton.Caption:='More <<';
 end else begin
   MorePanel.Height:=0;
   Height:=Height-DeltaH;
   MoreButton.Caption:='More >>';
 end;
end;


procedure TSlaveForm.ShowAsClick(Sender: TObject);
begin
 OpenDialogSelectionChange(Self);
end;

procedure TSlaveForm.ClearBtnClick(Sender: TObject);
begin
 DroppedFiles.Items.Clear;
end;

end.













