unit DsPanel;

// DsPanel Release 1.1 for Delphi 3 and up
// Copyright (c) 1997~1999 by Djoko Susilo
// ------------- Q14 Project -------------
// Files needed to install:
//  1. DsPanel.pas  (this file)
//  2. DsPanel.dcr  (resource for icon)
//----------------------------------------

// update 14-Oct-99:
//   add properties Color_High, Color_Low, FaceColor
// update 30-Apr-00: use better routines in Paint
//--------------------------------------------------

interface

uses
  SysUtils, Windows, Classes, Graphics, Controls, ExtCtrls;

type
  TBorderLine = (blNone, blRaised, blLowered);
  TTextStyle = (txNone, txLowered, txRaised);
  TDsPanel = class(TCustomPanel)
  private
    { Private declarations }
    FBorderLine: TBorderLine;
    FColor_High: TColor;
    FColor_Low: TColor;
    FFaceColor: TColor;
    FShadowColor: TColor;
    FShadowWidth: Integer;
    FTextStyle: TTextStyle;
    procedure SetBorderLine(Value: TBorderLine);
    procedure SetShadowColor(Value: TColor);
  protected
    { Protected declarations }
    procedure AlignControls(AControl: TControl; var Rect: TRect); override;
    procedure Paint; override;
    procedure SetColor_High(Value: TColor);
    procedure SetColor_Low(Value: TColor);
    procedure SetFaceColor(Value: TColor);
    procedure SetTextStyle(Value: TTextStyle);
    procedure SetShadowWidth(Value: Integer);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property Align;
    property Alignment;
    property BorderLine: TBorderLine
             read FBorderLine write SetBorderLine default blRaised;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Caption;
    property Color;
    property Color_High: TColor
             read FColor_High write SetColor_High default $00E0E8E8;
    property Color_Low: TColor
             read FColor_Low write SetColor_Low default $00688DA2;
    property Ctl3D;
    property FaceColor: TColor
             read FFaceColor write SetFaceColor default clBtnFace;
    property Font;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShadowColor: TColor
             read FShadowColor write SetShadowColor default clGray;
    property ShadowWidth: Integer
             read FShadowWidth write SetShadowWidth default 2;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property TextStyle: TTextStyle
             read FTextStyle write SetTextStyle default txRaised;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
  end;

procedure Register;

implementation

constructor TDsPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Alignment:=taCenter;
  Color:=clBtnFace;
  ControlStyle:=[csAcceptsControls, csCaptureMouse, csClickEvents,
                 csSetCaption, csOpaque, csDoubleClicks];
  FBorderLine:=blRaised;
  FColor_High:=$00E0E8E8;  //clBtnHighlight
  FColor_Low:=$00688DA2;   //clBtnShadow
  FFaceColor:=clBtnFace;
  FShadowColor:=clGray;
  FShadowWidth:=2;
  Height:=41;
  TextStyle:=txRaised;
  Width:=185;
end;

procedure TDsPanel.AlignControls(AControl: TControl; var Rect: TRect);
begin
  InflateRect(Rect, ShadowWidth div 2, ShadowWidth div 2);
  OffSetRect(Rect, -ShadowWidth div 2, -ShadowWidth div 2);
  inherited AlignControls(AControl, Rect);
end;

procedure TDsPanel.Paint;
var
  R, Rect: TRect;
  FontHeight: Integer;
  Flags: Word;
const
  Alignments: array[TAlignment] of Word=(DT_LEFT, DT_RIGHT, DT_CENTER);
begin
  Rect:=GetClientRect;
  // menggambar latar belakang
  Canvas.Brush.Style:=bsClear;
  Canvas.Brush.Color:=Color;
  Canvas.FillRect(Rect);
  // menggambar bayangan
  InflateRect(Rect, -ShadowWidth div 2, -ShadowWidth div 2);
  OffSetRect(Rect, ShadowWidth div 2, ShadowWidth div 2);
  Canvas.Brush.Style:=bsSolid;
  Canvas.Brush.Color:=ShadowColor;
  Canvas.FillRect(Rect);
  OffSetRect(Rect, -ShadowWidth, -ShadowWidth);

  // menggambar panel
  with Canvas do
  begin
    Brush.Color:=FFaceColor;
    FillRect(Rect);
    // membuat garis batas panel
    if BorderLine<>blNone then
    begin
      Brush.Style:=bsClear;
      if BorderLine=blRaised then Pen.Color:=FColor_High //clBtnHighlight
      else Pen.Color:=FColor_Low; //clBtnShadow;
      MoveTo(0, Height-1-ShadowWidth);
      LineTo(0, 0); LineTo(Width-1-ShadowWidth, 0);
      if BorderLine=blRaised then Pen.Color:=FColor_Low //clBtnShadow
      else Pen.Color:=FColor_High; //clBtnHighlight;
      LineTo(Width-1-ShadowWidth, Height-1-ShadowWidth);
      LineTo(0, Height-1-ShadowWidth);
    end;

    Flags:=DT_EXPANDTABS or DT_VCENTER or Alignments[Alignment];
    Brush.Style:=bsClear;
    Font:=Self.Font;
    FontHeight:=TextHeight('W');
    with Rect do
    begin
      Top:=((Bottom+Top)-FontHeight) shr 1;
      Bottom:=Top+FontHeight;
    end;
    R:=Rect;
    if TextStyle=txRaised then
    begin
      Font.Color:=FColor_High; //clBtnHighlight;
      OffsetRect(Rect, -1, -1);
      DrawText(Handle, PChar(Caption), Length(Caption), Rect, Flags);
    end
    else if TextStyle=txLowered then
    begin
      Font.Color:=FColor_High; //clBtnHighlight;
      OffsetRect(Rect, 1, 1);
      DrawText(Handle, PChar(Caption), Length(Caption), Rect, Flags);
    end;
    Font.Color:=Self.Font.Color;
    DrawText(Handle, PChar(Caption), Length(Caption), R, Flags);
  end;
end;

procedure TDsPanel.SetBorderLine(Value: TBorderLine);
begin
  if Value<>FBorderLine then
  begin
    FBorderLine:=Value;
    Invalidate;
  end;
end;

procedure TDsPanel.SetColor_High(Value: TColor);
begin
  if Value<>FColor_High then
  begin
    FColor_High:=Value;
    Invalidate;
  end;
end;

procedure TDsPanel.SetColor_Low(Value: TColor);
begin
  if Value<>FColor_Low then
  begin
    FColor_Low:=Value;
    Invalidate;
  end;
end;

procedure TDsPanel.SetFaceColor(Value: TColor);
begin
  if Value<>FFaceColor then
  begin
    FFaceColor:=Value;
    Invalidate;
  end;
end;

procedure TDsPanel.SetShadowColor(Value: TColor);
begin
  if Value<>FShadowColor then
  begin
    FShadowColor:=Value;
    Invalidate;
  end;
end;

procedure TDsPanel.SetShadowWidth(Value: Integer);
begin
  if Value<>FShadowWidth then
  begin
    FShadowWidth:=Value;
    if FShadowWidth<0 then FShadowWidth:=0;
    if FShadowWidth>10 then FShadowWidth:=10;
    Invalidate;
  end;
end;

procedure TDsPanel.SetTextStyle(Value: TTextStyle);
begin
  if Value<>FTextStyle then
  begin
    FTextStyle:=Value;
    Invalidate;
  end;
end;

procedure Register;
begin
  RegisterComponents('My Compo', [TDsPanel]);
end;

end.
