unit DsGroup;

// DsGroup Release 1.2 for Delphi 3 and up
// Copyright (c) 1997 - 1999 by Djoko Susilo
// djokos@cabi.net.id
// ------------- Q14 Project ---------------
// File yang dibutuhkan untuk instalasi:
//  1. DsGroup.pas  (file ini)
//  2. DsGroup.dcr  (resource untuk ikon)
// ---R1.2: 10-October-1999 ----------------
// tambahan properti Color_High, Color_Low,
//                   CornerRadius, FaceColor
// -----------------------------------------

interface

uses
  SysUtils, Windows, Classes, Graphics, Controls, StdCtrls;

type
  TCapAlignment = (caLeft, caCenter, caRight);
  TTextStyle = (txNone, txLowered, txRaised, txShadowed);
  TDsGroup = class(TCustomGroupBox)
  private  { Private declarations }
    FCapAlignment: TCapAlignment;
    FColor_High: TColor;
    FColor_Low: TColor;
    FCornerRadius: Integer;
    FFaceColor: TColor;
    FTextStyle : TTextStyle;
  protected { Protected declarations }
    procedure AlignControls(AControl: TControl; var Rect: TRect); override;
    procedure Paint; override;
    procedure SetFaceColor(Value: TColor);
    procedure SetCapAlignment(Value: TCapAlignment);
    procedure SetColor_High(Value: TColor);
    procedure SetColor_Low(Value: TColor);
    procedure SetCornerRadius(Value: Integer);
    procedure SetTextStyle(Value: TTextStyle);
  public { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CreateParams(var Params: TCreateParams); override;
  published  { Published declarations }
    property Align;
    property CapAlignment: TCapAlignment
             read FCapAlignment write SetCapAlignment default caLeft;
    property Caption;
    property Color;
    property Color_High: TColor
             read FColor_High write SetColor_High default $00E0E8E8;
    property Color_Low: TColor
             read FColor_Low write SetColor_Low default $00688DA2;
    property CornerRadius: Integer
             read FCornerRadius write SetCornerRadius default 3;
    property Ctl3D;
    Property Cursor;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FaceColor: TColor
             read FFaceColor write SetFaceColor default clNone;
    property Font;
    property Height default 105;
    Property HelpContext;
    property Hint;
    property Left;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property TextStyle: TTextStyle
             read FTextStyle write SetTextStyle default txRaised;
    property Visible;
    property Width default 145;

    property OnClick;
    property OnDblClick;
    property OnKeyDown;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('My Compo', [TDsGroup]);
end;

// membentuk objek dan inisialisasi
constructor TDsGroup.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCapAlignment:=caLeft;
  FColor_High:=$00E0E8E8;  // clBtnHighlight
  FColor_Low:=$00688DA2;   // clBtnShadow
  FCornerRadius:=3;
  FFaceColor:=clNone;
  FTextStyle:=txRaised;
  Height:=105;
  Width:=145;
end;

// menghapus setiap objek yang telah dibuat
destructor TDsGroup.Destroy;
begin
  inherited Destroy;
end;

procedure TDsGroup.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
end;

// 1. Menata ulang Caption dengan CapAlignment dan TextStyle.
// 2. Membentuk garis batas dengan sudut lengkung.
procedure TDsGroup.Paint;
var H: Integer;      // tinggi teks dalam satuan pixel
    LText: Integer;  // panjang teks dalam satuan pixel
    R, TR: TRect;
    posX: Integer;   // posisi penulisan Caption
    Flags: word;
begin
  LText:=0; posX:=0;
  // menggambar garis batas boks
  with Canvas do
  begin
    Font:=Self.Font;
    H:=TextHeight('H');
    R:=Rect(0, (H div 2), Width-1, Height-1);
    if Ctl3D then
    begin
      if FCornerRadius<>0 then   // 3D rounded corner
      begin
        Brush.Style:=bsClear;
        OffsetRect(R, 1, 1);
        Pen.Color:=FColor_High; //clBtnHighlight;
        RoundRect(R.Left, R.Top, R.Right, R.Bottom,
                  2*CornerRadius, 2*CornerRadius);
        OffsetRect(R, -1, -1);
        Pen.Color:=FColor_Low;
        RoundRect(R.Left, R.Top, R.Right, R.Bottom,
                  2*CornerRadius, 2*CornerRadius);
      end
      else // 3D rectangle corner
      begin
        OffsetRect(R, 1, 1);
        Brush.Color:=FColor_High; //clBtnHighlight;
        FrameRect(R);
        OffsetRect(R, -1, -1);
        Brush.Color:=FColor_Low;  //clBtnShadow;
        FrameRect(R);
      end;
    end
    else  // plain rectangle corner
    begin
      Brush.Color:=clWindowFrame;
      if FCornerRadius=0 then FrameRect(R)
      else
        begin
          Brush.Style:=bsClear;
          RoundRect(0, (H div 2), Width, Height,
                    2*CornerRadius, 2*CornerRadius);
      end;
    end;

    // penulisan teks Caption
    if Caption='' then LText:=0
    else LText:=TextWidth(Caption)+2;  // panjang teks dalam satuan pixel
    Flags:=DT_CENTER or DT_SINGLELINE;

    // menentukan posisi Caption dan latar belakangnya
    case FCapAlignment of
      caLeft  : if FCornerradius<4 then posX:=8
                else posX:=4+CornerRadius;
      caCenter: posX:=(Width-LText) div 2;
      caRight : if FCornerRadius<4 then posX:=Width-LText-8
                else posX:=Width-LText-4-FCornerRadius;
    end;

    R:=Rect(posX, 0, posX+LText, H);
    Brush.Color:=Color;
    TR:=R;
    FillRect(R);

    // mewarnai boks
    if Ctl3D and (FFaceColor<>clNone) then
    begin
      Pen.Color:=FFaceColor;
      Brush.Color:=FFaceColor;
      if FCornerRadius=0 then
        Rectangle(2, (H div 2)+2, Width-2, Height-2)
      else
        RoundRect(2, (H div 2)+2, Width-2, Height-2,
                  2*(FCornerRadius-2), 2*(FCornerRadius-2));
    end;

    // menuliskan teks Caption
    Brush.Style:=bsClear;
    if Ctl3D then  // jika Ctl3D True
    begin
      case FTextStyle of
        txLowered:      // Caption dengan efek Lowered
          begin
            Font.Color:=FColor_High; //clBtnHighlight;
            OffsetRect(R, 1, 1);
            DrawText(Handle, PChar(Caption), Length(Caption), R, Flags);
          end;
        txRaised:       // Caption dengan efek Raised
          begin
            Font.Color:=FColor_High; //clBtnHighlight;
            OffsetRect(R, -1, -1);
            DrawText(Handle, PChar(Caption), Length(Caption), R, Flags);
          end;
        txShadowed:     // Caption dengan efek Shadowed
          begin
            Font.Color:=FColor_Low; //clBtnShadow;
            OffsetRect(R, 2, 2);
            DrawText(Handle, PChar(Caption), Length(Caption), R, Flags);
          end;
      end;  // end case
    // txNone (Plain) Caption, juga menunjang pembentukan efek lainnya
    Font.Color:=Self.Font.Color;
    DrawText(Handle, PChar(Caption), Length(Caption), TR, Flags);
  end   // end Ctl3D
  else  // jika Ctl3D False
  begin
    Font.Color:=clWindowFrame;
    DrawText(Handle, PChar(Caption), Length(Caption), TR, Flags);
  end;
  end;  // end Canvas
end;

procedure TDsGroup.AlignControls(AControl: TControl; var Rect: TRect);
begin
  inherited AlignControls(Acontrol,Rect);
end;

procedure TDsGroup.SetFaceColor(Value: TColor);
begin
  if Value<>FFaceColor then
  begin
    FFaceColor:=Value;
    Invalidate;
  end;
end;

procedure TDsGroup.SetCapAlignment(Value: TCapAlignment);
begin
  if Value<>FCapAlignment then
  begin
    FCapAlignment:=Value;
    Invalidate;
  end;
end;

procedure TDsGroup.SetTextStyle(Value: TTextStyle);
begin
  if Value<>FTextStyle then
  begin
    FTextStyle:=Value;
    Invalidate;
  end;
end;

procedure TDsGroup.SetColor_High(Value: TColor);
begin
  if Value<>FColor_High then
  begin
    FColor_High:=Value;
    Invalidate;
  end;
end;

procedure TDsGroup.SetColor_Low(Value: TColor);
begin
  if Value<>FColor_Low then
  begin
    FColor_Low:=Value;
    Invalidate;
  end;
end;

procedure TDsGroup.SetCornerRadius(Value: Integer);
begin
  if Value<0 then Value:=0;     // nilai minimum
  if Value>12 then Value:=16;   // nilai maksimum
  if Value<>FCornerRadius then
    begin
      FCornerRadius:=Value;
      Invalidate;
    end;
end;

end.


