unit Sis;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls,
  Buttons, Menus, ShellAPI, ExtCtrls;

type
  TMenuNotifyEvent = procedure(Sender: TMenuItem) of object;
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    Style1: TMenuItem;
    Normal: TMenuItem;
    Alwaysontop: TMenuItem;
    // events 
    procedure NormalClick(Sender: TObject);
    procedure AlwaysontopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    // Private function & procedure declarations 
    procedure InitializeMenus;
    procedure ParseMenuInfo(S: string);
    procedure CreateNewMainMenu;
    function  ParseMenuCaption(S: string): string;
    function  ParseMenuExe(S: string): string;
    procedure ParseExecutableAndCommandLine(var Command, Params: string);
    procedure CreateNewMenuItem;
    // generic event handler for handling menu clicks
    procedure GenericSubMenuItemClick(Sender:TMenuItem);
    procedure ExecuteFile(Command,Params,WorkDir: String);
  private
    // Private variable declarations 
    SubMenuLevel                :  Integer;
    NewMenuItem                 :  TMenuItem;
    MenuNumber                  :  array[0..6] of Integer;
    MenuCaption, MenuExecutable :  String;
    AttachEventHandler          :  Boolean;
    EnableIncMenuItem           :  Boolean;
    NumMenusOnLevel2            :  Integer;
    NumMenusOnLevel3            :  Integer;
    NumMenusOnLevel4            :  Integer;
    NumMenusOnLevel5            :  Integer;
  public
    // Public declarations 
  end;

const
  PmmIniFileName = 'PMM.ini';

var
  MainForm: TMainForm;

implementation

uses IniFiles;
{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  Index : Integer;
begin
  SubMenuLevel         := 0;
  NumMenusOnLevel2     := 0;
  NumMenusOnLevel3     := 0;
  NumMenusOnLevel4     := 0;
  NumMenusOnLevel5     := 0;
  for Index := 0 To 5 do
    MenuNumber[Index]  := 0;
  InitializeMenus;
end;

procedure TMainForm.InitializeMenus;
var
  IniLineString:  string;
  PmmIniFile: TextFile;
begin
  try
    AssignFile(PmmIniFile, PmmIniFileName);
    Reset(PmmIniFile);
    while not Eof(PmmIniFile) do
    begin
      Readln(PmmIniFile, IniLineString);        // Read line out of the file 
      IniLineString := Trim(IniLineString);
      ParseMenuInfo(IniLineString);
    end;
  finally
    CloseFile(PmmIniFile);
  end;
end;

procedure TMainForm.ParseMenuInfo(S: string);
var
  FirstChar  : char;
  Index      :  Integer;
begin
  if Length(S) > 0 then
  begin //  if length
  FirstChar := UpCase(S[1]);
  case FirstChar of
    'I' :  begin
             // Do Nothing
           end;
    'M' :  begin
             // Make Main Menu
             AttachEventHandler := False;
             SubMenuLevel := 0;
             for Index := 1 To 5 do
               MenuNumber[Index] := 0;
             MenuCaption := ParseMenuCaption(S);
             CreateNewMainMenu;
           end;
    'P' :  begin
             EnableIncMenuItem    := True;
             AttachEventHandler := True;
             MenuCaption := ParseMenuCaption(S);
             MenuExecutable := ParseMenuExe(S);
             CreateNewMenuItem;
           end;
    'D' :  begin
             // make separator
             AttachEventHandler := False;
             MenuCaption       := '-';
             MenuExecutable    := '';
             CreateNewMenuItem;
           end;
    'S' :  begin
             // Make submenu
             EnableIncMenuItem    := False;
             AttachEventHandler := False;
             MenuCaption := ParseMenuCaption(S);
             MenuExecutable := '';
             CreateNewMenuItem;
             Inc(SubMenuLevel);
           end;
    'E' :  begin
             // End submenus
             AttachEventHandler := False;
             SubMenuLevel := SubMenuLevel - 1;
           end;
  else
     MessageDlg('Error In INI File Structure!  Check Letters!', mtConfirmation,
                       mbYesNoCancel , 0);
    // Do Nothing
  end;
  end; // if length
end;

Procedure TMainForm.CreateNewMainMenu;
begin
  NewMenuItem := TMenuItem.Create(Self);
  NewMenuItem.Caption := MenuCaption;
  MainMenu.Items.Add(NewMenuItem);
end;

function TMainForm.ParseMenuCaption(S: string): string;
var
  Size : Integer;
begin
  if Length(S) = 0 then begin
    ParseMenuCaption := '';
    Exit;
  end;
  Size := Pos('=', S) - 1;
  if Size <= 0 then begin
     S := Copy(S,2,Length(S) - 1);
     ParseMenuCaption := Trim(S);
    Exit;
  end;
  SetLength(S, Size);
  S := Copy(S,2,Length(S) - 1);
  ParseMenuCaption := Trim(S);
end;

function TMainForm.ParseMenuExe(S: string): string;
var
  StringBegin : Integer;
begin
  StringBegin := Pos('=', S) + 1;
  if StringBegin <= 0 then begin
    ParseMenuExe := '';
    Exit;
  end;
  S := Copy(S,StringBegin,Length(S) - 1);
  ParseMenuExe := Trim(S);
end;

Procedure TMainForm.ParseExecutableAndCommandLine(var Command, Params: string);
var
  Size : Integer;
begin
  Size := Pos(' ', Command);
  if Size <= 0 then begin
    Params := '';
    Exit;
  end;
  SetLength(Command, Size);
  Command := Trim(Command);
  Params  := Copy(Params,Size,Length(Params) - 1);
  Params  := Trim(Params);
end;

Procedure TMainForm.CreateNewMenuItem;
var
  EventName : TMenuNotifyEvent;
begin
  try
    NewMenuItem := TMenuItem.Create(NewMenuItem);
    NewMenuItem.Caption := MenuCaption;
    NewMenuItem.Hint := MenuExecutable;     // Use Hint To Store Program Path
    case SubMenuLevel of
       0 :  begin
              MainMenu.Items[MainMenu
                      .Items
                      .Count - 1]
                      .Add(NewMenuItem);
              { Assign new event, created at runtime, to
              the speed Button OnClick event, GenericSpeedButtonClick }
              if AttachEventHandler then
              begin
                EventName := GenericSubMenuItemClick;
                NewMenuItem.OnClick := TNotifyEvent(EventName);
              end;
            end;
       1 :  begin
              MainMenu.Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Add(NewMenuItem);
              { Assign new event, created at runtime, to
              the speed Button OnClick event, GenericSpeedButtonClick }
              if AttachEventHandler then
              begin
                EventName := GenericSubMenuItemClick;
                NewMenuItem.OnClick := TNotifyEvent(EventName);
              end;
            end;
       2 :  begin
              MainMenu.Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Count - 1]
                      .Add(NewMenuItem);
              if EnableIncMenuItem then Inc(NumMenusOnLevel2);
              { Assign new event, created at runtime, to
                the speed Button OnClick event, GenericSpeedButtonClick }
              if AttachEventHandler then
              begin
                EventName := GenericSubMenuItemClick;
                NewMenuItem.OnClick := TNotifyEvent(EventName);
              end;
            end;
       3 :  begin
              MainMenu.Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Count - 1]
                      .Items[NumMenusOnLevel2]
                      .Add(NewMenuItem);
              if EnableIncMenuItem then Inc(NumMenusOnLevel3);
               { Assign new event, created at runtime, to
                the speed Button OnClick event, GenericSpeedButtonClick }
              if AttachEventHandler then
              begin
                EventName := GenericSubMenuItemClick;
                NewMenuItem.OnClick := TNotifyEvent(EventName);
              end;
            end;
        4 :  begin
              MainMenu.Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Count - 1]
                      .Items[NumMenusOnLevel2]
                      .Items[NumMenusOnLevel3]
                      .Add(NewMenuItem);
              if EnableIncMenuItem then Inc(NumMenusOnLevel4);
                { Assign new event, created at runtime, to
                the speed Button OnClick event, GenericSpeedButtonClick }
              if AttachEventHandler then
              begin
                EventName := GenericSubMenuItemClick;
                NewMenuItem.OnClick := TNotifyEvent(EventName);
              end;
             end;
        5 :  begin
              MainMenu.Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Items[MainMenu
                      .Items[MainMenu
                      .Items
                      .Count - 1]
                      .Count - 1]
                      .Count - 1]
                      .Items[NumMenusOnLevel2]
                      .Items[NumMenusOnLevel3]
                      .Items[NumMenusOnLevel4]
                      .Add(NewMenuItem);
              if EnableIncMenuItem then Inc(NumMenusOnLevel5);
                 { Assign new event, created at runtime, to
                 the speed Button OnClick event, GenericSpeedButtonClick }
              if AttachEventHandler then
              begin
                EventName := GenericSubMenuItemClick;
                NewMenuItem.OnClick := TNotifyEvent(EventName);
              end;
             end
        else
             MessageDlg('Only 5 Submenus Allowed!  Too Many Submenus!',
                        mtConfirmation,mbYesNoCancel , 0);
                      // Do Nothing 
    end;  // Case
  except
    on E: EInOutError do
      begin
        MessageDlg('Unable to create menu item. ' +
        E.Message, mtInformation, [mbOK],0);
        NewMenuItem.Free;
      end;
  end;
end;

// Generic MenuItem click
// Can either set up a new MenuItem toolbar or execute a file
procedure TMainForm.GenericSubMenuItemClick(Sender:TMenuItem);
var
  Command, Params, WorkDir: String;
begin
  Command := Sender.Hint;  // Get the file name and path from hint 
  Params := '';
  WorkDir := '';
  ExecuteFile(Command, Params, WorkDir);
end;

procedure TMainForm.NormalClick(Sender: TObject);
begin
  AlwaysOnTop.Checked     := False;
  MainForm.FormStyle      := fsNormal;
  Normal.Checked          := True;
end;

procedure TMainForm.AlwaysontopClick(Sender: TObject);
begin
  Normal.Checked          := False;
  MainForm.FormStyle      := fsStayOnTop;
  AlwaysOnTop.Checked     := True;
end;

// generic execute file routine 
procedure TMainForm.ExecuteFile(Command, Params, WorkDir: string);
begin

  Params := Command;
  ParseExecutableAndCommandLine(Command, Params);

  // convert Pascal string to Null-termintated strings 
  Command := Command + #0;
  Params  := Params  + #0;
  WorkDir := WorkDir + #0;
  // run/open application/file 
  if ShellExecute(Application.MainForm.Handle,'Open',@Command[1],
                  @Params[1], @WorkDir[1], SW_SHOWNORMAL) < 32 then
    MessageDlg('Could not execute ' + Command,mtError,[mbOK],0);
end;

end. // of unit

