unit fTranslateDFM;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fMDIChild, cShape, Buttons, StdCtrls, ExtCtrls, cdcDelphiTools;

type
  TFormTranslate = class(TChild)
    Panel1: TPanel;
    Label1: TLabel;
    RootEdit: TEdit;
    SBRoot: TSpeedButton;
    Label2: TLabel;
    TargetEdit: TEdit;
    SBTarget: TSpeedButton;
    TargetCheckBox: TCheckBox;
    RecurseCheckBox: TCheckBox;
    Memo: TMemo;
    OpenDialog: TOpenDialog;
    CounterLabel: TLabel;
    CurrentLabel: TLabel;
    TestCheckBox: TCheckBox;
    SkipCheckBox: TCheckBox;
    SBTranslate: TSpeedButton;
    TranslateDFM: TTranslateDFM;
    DeleteBakChekBox: TCheckBox;
    DeleteDCUChekBox: TCheckBox;
    procedure SBRootClick(Sender: TObject);
    procedure SBTargetClick(Sender: TObject);
    procedure SBTranslateClick(Sender: TObject);
    procedure TranslateDFMMyEventPrepare(Sender: TObject; const Path,FileName: String; const Count: Integer);
    procedure TranslateDFMMyEventOK(Sender: TObject; const Path,FileName: String; const Count: Integer);
    procedure TranslateDFMMyEventError(Sender: TObject; const Path,FileName: String; const Count: Integer; var Cancel: Boolean);
    procedure TranslateDFMMyEventStart(Sender: TObject; const Path,FileName: String; const Count: Integer);
    procedure TranslateDFMMyEventDone(Sender: TObject; const Titre,Caption: String; const Count: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

Uses FileCtrl;

{$R *.DFM}

//-----------------------------------------------------------------------------}
procedure TFormTranslate.SBRootClick(Sender: TObject);
var s:String;
begin
s:=RootEdit.Text;
if FileCtrl.SelectDirectory(s ,[sdAllowCreate, sdPerformCreate, sdPrompt], 0) then
   RootEdit.Text:=s;
end;

//-----------------------------------------------------------------------------}
procedure TFormTranslate.SBTargetClick(Sender: TObject);
var s:String;
begin
s:=TargetEdit.Text;
if FileCtrl.SelectDirectory(s ,[sdAllowCreate, sdPerformCreate, sdPrompt], 0) then
   TargetEdit.Text:=s;
end;

//------------------------------------------------------------------------------
procedure TFormTranslate.TranslateDFMMyEventStart(Sender: TObject;const Path, FileName: String; const Count: Integer);
begin
  inherited;
  Assert(Self=(Sender as TTranslateDFM).Owner);
  Self.Memo.Clear;
  Self.Memo.Lines.Add(format('Start at %s',[DateTimeToStr(now)]));
end;

//------------------------------------------------------------------------------
procedure TFormTranslate.TranslateDFMMyEventPrepare(Sender: TObject;Const Path, FileName: String; const Count: Integer);
Begin
  inherited;
  Assert(Self=(Sender as TTranslateDFM).Owner);
  Self.CounterLabel.Caption:=IntToStr(Count);
  Self.CurrentLabel.Caption:=ExtractFileName(FileName);
end;

//------------------------------------------------------------------------------
procedure TFormTranslate.TranslateDFMMyEventOK(Sender: TObject; const Path,FileName: String; const Count: Integer);
begin
  inherited;
  Assert(Self=(Sender as TTranslateDFM).Owner);
  Self.Memo.Lines.Add(format('Processed:%s%s',[Path,FileName]));
end;

//------------------------------------------------------------------------------
procedure TFormTranslate.TranslateDFMMyEventError(Sender: TObject;const Path, FileName: String; const Count: Integer; var Cancel: Boolean);
begin
  inherited;
  Assert(Self=(Sender as TTranslateDFM).Owner);
  Self.Memo.Lines.Add(format('Error in :%s%s',[Path,FileName]));
end;

//------------------------------------------------------------------------------
procedure TFormTranslate.TranslateDFMMyEventDone(Sender: TObject;const Titre, Caption: String; const Count: Integer);
begin
  inherited;
  Assert(Self=(Sender as TTranslateDFM).Owner);
  Self.Memo.Lines.Add(format('Done  at %s : %d Found',[DateTimeToStr(now),Count]));
  Self.SBTranslate.Caption:='Translate';
  Self.SBTranslate.Tag:=0;
end;

//------------------------------------------------------------------------------
procedure TFormTranslate.SBTranslateClick(Sender: TObject);
begin
  inherited;
  Case Self.SBTranslate.Tag of
     0   :Begin //Starting;
          Self.SBTranslate.Tag:=1;
          Self.SBTranslate.Caption:='Stop';
          Self.TranslateDFM.Root:=RootEdit.Text;
          Self.TranslateDFM.Target:=TargetEdit.Text;
          Self.TranslateDFM.SkipError:=SkipCheckBox.Checked;
          Self.TranslateDFM.UseTargetFolder:=TargetCheckBox.Checked;
          Self.TranslateDFM.DeleteBakFiles:=DeleteBakChekBox.Checked;
          Self.TranslateDFM.DeleteDCUFiles:=DeleteDCUChekBox.Checked;
          Self.TranslateDFM.Recurse:=RecurseCheckBox.Checked;
          Self.TranslateDFM.OnlyTest:=TestCheckBox.Checked;
          Self.TranslateDFM.Execute
          End;
     999 :Begin //Stopping
          Beep;
          End;
     else Begin
          Self.SBTranslate.Tag:=999;
          Self.TranslateDFM.Stop
     end  end;
end;

end.
