unit fParent;
                                               
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs,
  DBCtrls,
  DBGrids, ExtCtrls, StdCtrls,
  cShape, cdcLibrary;
                                                               
type
  TParent = Class;
  TMyIdleEvent = procedure (Sender: TObject;Simulation:Boolean;var Done: Boolean) of object;
  TSaveDFM = procedure(Const Value:TParent);
  TReadDFM = function(Const value:TFormClass):TParent;

  TParent = class(TForm)
    FormSize: TFormSize;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
  private   { Private declarations }
    FMinWidth,
    FMinHeight: Integer;
    FOnIdle   : TMyIdleEvent;
    fOnExportData : TNotifyEvent;
    FInactivity : Integer;
    Function  GetUserEventTime:TDateTime;
    Procedure SetUserEventTime(value:TDateTime);
    procedure WMGetMinMaxInfo(var Message:TWMGetMinMaxInfo);message WM_GetMINMAXINFO;
    //procedure Loaded;override;
  protected
    fSaveDFM : Boolean;
    Function  CloseMsg:String;dynamic;
    procedure Idle(Sender: TObject; var Done: Boolean);
    procedure OnIdleProc(Sender: TObject;Simulatiion:Boolean;var Done:Boolean);dynamic;
    procedure SetOnIdle(Const Value:TMyIdleEvent);
    //procedure SetUserLevel;dynamic;abstract;
  public    { Public declarations  }
    property  OnIdle : TMyIdleEvent read FOnIdle write SetOnIdle;
    property  OnExportData :  TNotifyEvent read fOnExportData write fOnExportData;
    Function  Inactivity : Boolean;
    property  Attende : Integer read FInactivity write FInactivity default 30;
    property  UserEventTime: TDateTime read GetUserEventTime write SetUserEventTime;
    property  MinWidth : Integer read FMinWidth write FMinWidth  default 300;
    property  MinHeight: Integer read FMinHeight write FMinHeight  default 300;
  end;

Function CreateFromRes(Const CT:TFormClass):TForm;

Var
  SaveDFM : TSaveDFM = nil;
  ReadDFM : TReadDFM = nil;

ResourceString
  Standart_CLOSE_MSG = 'Quit Program ? ';
  DeleteRecordQuery  = 'Confirm deletion of active record ?'+#10#13+'%s';

implementation

{$R *.DFM}

var FLastUserEventTime : TDateTime;
    //FStructuredStorage : TStructuredStorage;

{------------------------------------------------------------------------------}
Function CreateFromRes(Const CT:TFormClass):TForm;
Begin
if Assigned(ReadDFM) Then Begin
   Result:=ReadDFM(CT);
   if Assigned(Result) Then Begin
      if (Result.FormStyle=fsMDIChild)and(Result is TParent) then Begin
         Result.SetBounds(TParent(Result).FormSize.Left,TParent(Result).FormSize.Top,TParent(Result).FormSize.Width,TParent(Result).FormSize.Height);
         end;
      if Assigned(Result.OnCreate) then Result.OnCreate(Result);
      if Assigned(Result.OnActivate) then Result.OnActivate(Result);
   end else
      Result:=CT.Create(Application);
end else
   Result:=CT.Create(Application);
end;

{------------------------------------------------------------------------------}
procedure TParent.FormCreate(Sender: TObject);
begin
  inherited;
  Screen.Cursor:=crHourGlass;
  fSaveDFM:=True;
  FMinWidth :=300;
  FMinHeight:=300;
  FInactivity:=30;
  FOnIdle:=OnIdleProc;
  fOnExportData:=Nil;
  FLastUserEventTime:=Now;
end;

//-----------------------------------------------------------------------------}
procedure TParent.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose:=(MessageDlg(CLOSEMSG, mtConfirmation, [mbYes,mbNo] , HelpContext)= mrYes);
end;

//-----------------------------------------------------------------------------}
procedure TParent.FormClose(Sender: TObject; var Action: TCloseAction);
begin
///First Write the DFM to a Memory Stream
self.FormSize.SaveBounds(Self.BoundsRect);
Screen.Cursor:=crHourGlass;
if (Assigned(fParent.SaveDFM))and(Self.fSaveDFM) then
   fParent.SaveDFM(Self);
End;

{------------------------------------------------------------------------------}
procedure TParent.FormDestroy(Sender: TObject);
begin
FOnIdle:=nil;
inherited;
end;

//-----------------------------------------------------------------------------}
procedure TParent.WMGetMinMaxInfo(var Message:TWMGetMinMaxInfo);
begin
  with Message .MinMaxInfo^ do
    begin
    ptMinTrackSize:=Point(FMinWidth,FMinHeight);
    end;
end;

{------------------------------------------------------------------------------}
Function  TParent.CloseMsg:String;
begin
Result:=Standart_CLOSE_MSG;
end;

{------------------------------------------------------------------------------}
function  TParent.Inactivity:Boolean;
begin
result:=((Now-FLastUserEventTime)*24*60)>(FInactivity);
if result then
   FLastUserEventTime:=Now
end;

{------------------------------------------------------------------------------}
function  TParent.GetUserEventTime:TDateTime;
begin
result:=FLastUserEventTime;
end;

{------------------------------------------------------------------------------}
procedure TParent.SetUserEventTime(value:TDateTime);
begin
FLastUserEventTime:=value;
end;

{------------------------------------------------------------------------------}
procedure TParent.FormKeyUp(Sender: TObject; var Key: Word;Shift: TShiftState);
begin
FLastUserEventTime:=Now;
case key of
   vk_F1    :begin Application.HelpContext(Screen.ActiveControl.HelpContext);key:=0 end;
   Ord('Y') :If (Shift=[ssCtrl,ssALT]) then print;
end end;

{------------------------------------------------------------------------------}
procedure TParent.FormKeyPress(Sender: TObject; var Key: Char);
begin
FLastUserEventTime:=Now;
case key of
  #13  :if (ActiveControl is TDBGrid) then
             with TDBGrid(ActiveControl) do begin{ if it is a TDBGrid }
             if selectedindex < (fieldcount -1) then
                selectedindex := selectedindex +1
             else selectedindex := 0;
        end Else Begin
             if (ActiveControl is TDBMemo)or(ActiveControl is TMemo)or(ActiveControl is TDBRichEdit) then            { if it is a TDBMemo1 }
                begin
                inherited
             end else begin                                 { if not on a TDBGrid not a TDBMemo }
                Key := #0;                                  { eat enter key }
                Perform(WM_NEXTDLGCTL, 0, 0);               { move to next control }
             end end;
  else   inherited
end end;

{------------------------------------------------------------------------------}
procedure TParent.FormShow(Sender: TObject);
begin
FLastUserEventTime:=Now;
end;

//-----------------------------------------------------------------------------}
procedure TParent.SetOnIdle(Const Value:TMyIdleEvent);
Begin
FOnIdle:=Value;
End;

//-----------------------------------------------------------------------------}
procedure TParent.OnIdleProc(Sender: TObject;Simulatiion:Boolean;var Done:Boolean);
begin
if Self.Inactivity  then
   Close
end;

{------------------------------------------------------------------------------}
//Dispatch on Idle to the Active Form.................
procedure TParent.Idle(Sender: TObject; var Done: Boolean);
var Act:TForm;
begin
//If inativity reached the done = false -> go back in program
//else stay in the Idle mode till user action
done:=not (((Now-FLastUserEventTime)*24*60)>(FInactivity));
//For normal and child windows
if (assigned(Screen.ActiveForm)and Screen.ActiveForm.Visible) then begin
   Act:=Screen.ActiveForm;
   If (Act is TParent)and(Assigned(TParent(Act).OnIdle)) then begin
      (Act as TParent).OnIdle(Sender,false,done);
       end;
   if (Act.ActiveControl<>nil) then
     Screen.Cursor:=Act.ActiveControl.Cursor
   else
     Screen.Cursor:=Act.Cursor;
   end
else
//Try to find MDI parent
if (assigned(Application.MainForm)and Application.MainForm.Visible) then begin
   Act:=Application.MainForm;
   If (Act is TParent)and(Assigned(TParent(Act).OnIdle)) then begin
      (Act as TParent).OnIdle(Sender,false,done);
       end;
   Screen.Cursor:=Act.Cursor;
   end
else
   begin
   end
end;

{
Initialization
  FStructuredStorage:=TStructuredStorage.Create(nil);

Finalization
  if Assigned(FStructuredStorage) then
  FStructuredStorage.Free;
}

end.
