unit fMDIParent;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ToolWin, ComCtrls, ExtCtrls, StdCtrls, ImgList,
  StdActns, ActnList, MenuBar, cShape,  
  fParent;

type
  TMainForm = class(TParent)
    ImageList: TImageList;
    HotImageList: TImageList;
    MMenu: TMainMenu;
    MIWindows: TMenuItem;
    MICascade: TMenuItem;
    MITile: TMenuItem;
    MIArrangeIcons: TMenuItem;
    MIMinimizeAll: TMenuItem;
    MIHelp: TMenuItem;
    MIHelptext: TMenuItem;
    N3: TMenuItem;
    MIAuSujet: TMenuItem;
    CoolBar: TCoolBar;
    StatusBar: TStatusBar;
    MenuBar1: TMenuBar;
    Files1: TMenuItem;
    Close1: TMenuItem;
    MICpy: TMenuItem;
    N1: TMenuItem;
    ToolBar: TToolBar;
    TBCpy: TToolButton;
    TB1: TToolButton;
    TBClose: TToolButton;
    TBIBUsers: TToolButton;
    DisabledImageList: TImageList;
    MIViewDFM: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MIViewDFMClick(Sender: TObject);
    procedure MICpyClick(Sender: TObject);
    procedure TBCloseClick(Sender: TObject);
  private    { Private declarations }
    FBitmap   : TBitmap;
    //procedure SetUserLevel;override;
    procedure OnIdleProc(Sender: TObject;Simulatiion:Boolean;var Done:Boolean);override;
    procedure ClientWndProc(var Message: TMessage);
  protected
    FClientInstance,
    FDefClientProc: TFarProc;
    procedure OnHint(Sender: TObject);
    function  OpenChild(CT:TClass):Boolean;
    function  FindFirstChild(CT:TFormClass):TForm;
  public     { Public declarations }
    procedure SetBitmap(value:String);
  end;

var
  MainForm: TMainForm;

implementation

uses fTranslateDFM, fViewDFM;

{$R *.DFM}

//-----------------------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
  inherited;
  fSaveDFM:=False;

  //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  //The Master form of the program must set the Application properties
  Application.OnIdle:=Idle;
  Application.OnHint:=OnHint;
  Application.ShowHint:=true;

  //Sent the CallWindowProc for the "Client" windows
  FBitmap:= TBitmap.Create;
  Assert(FDefClientProc=nil);
  FClientInstance := MakeObjectInstance(ClientWndProc);

  SetBitmap('f:\Restomax\bmp\rmax2.bmp');
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.FormShow(Sender: TObject);
begin
  inherited;
  //Must come after the TCustomForm.CreateWnd  in the Forms Units
  //Under NT can not be in the Create event !!!!!!!
  if Not Assigned(FDefClientProc) then
     FDefClientProc := Pointer(GetWindowLong(ClientHandle, GWL_WNDPROC));

  if (FClientInstance<>FDefClientProc)and(FClientInstance<>nil) then
      SetWindowLong(ClientHandle, GWL_WNDPROC, Longint(FClientInstance));
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.FormHide(Sender: TObject);
begin
  inherited;
  Assert(Assigned(FDefClientProc));
  //SetWindowLong(ClientHandle, GWL_WNDPROC, Longint(FDefClientProc));
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.FormDeactivate(Sender: TObject);
begin
  inherited;
  Assert(Assigned(FDefClientProc));
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.FormCloseQuery(Sender: TObject;var CanClose: Boolean);
var i:integer;
begin
  UserEventTime:=Now;
  for I := MDIChildCount - 1 downto 0 do MDIChildren[I].Close;
  CanClose:=(MessageDlg(CLOSEMSG, mtConfirmation, [mbYes,mbNo] , HelpContext)= mrYes);
  if not CanClose then begin
     end;
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.FormDestroy(Sender: TObject);
begin
  FBitmap.free;
  inherited;
end;

//-----------------------------------------------------------------------------
//Paint on the client BkGrnd
procedure TMainForm.ClientWndProc(var Message: TMessage);
var x,y:integer;
    ThisCanvas : TCanvas;
begin
  with Message do
    case Msg of
      WM_ERASEBKGND:
         begin
         ThisCanvas := TCanvas.Create;
         try ThisCanvas.Handle := TWMEraseBkGnd(Message).DC;
             ThisCanvas.FillRect(ThisCanvas.ClipRect);
             if not FBitmap.Empty then begin
                //Try to center the bitmap
                x:=(ClientWidth-fBitmap.Width) div 2;
                y:=(ClientHeight-CoolBar.Height-FBitmap.Height) div 2;
                ThisCanvas.Draw(x, y, FBitmap);
                end;
             Message.Result := 1;
         finally
             ThisCanvas.Free;
         end end;
    else
      Message.Result := CallWindowProc(FDefClientProc, ClientHandle, Msg, wParam, lParam);
    end;
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.SetBitmap(value:String);
begin
if value<>'' then
  try FBitmap.ReleaseHandle;
      FBitmap.LoadFromFile(value);
  except
      FBitmap.ReleaseHandle;
end else
  FBitmap.ReleaseHandle;
end;

//-----------------------------------------------------------------------------}
//If not redefined on Hint Display .............
procedure TMainForm.OnHint(Sender: TObject);
begin
StatusBar.Panels[0].text:=Application.Hint;
end;

//-----------------------------------------------------------------------------}
//Mise  jour de l'horloge, du total, ... dans la StatusBar
procedure TMainForm.OnIdleProc(Sender: TObject;Simulatiion:Boolean;var Done:Boolean);
begin
inherited OnIdleProc(Sender,Simulatiion,Done);
StatusBar.Panels[StatusBar.Panels.Count-1].text:=TimeToStr(Time);
end;

//-----------------------------------------------------------------------------}
function TMainForm.OpenChild(CT:TClass):Boolean;
var i:integer;
begin
  inherited;
  result:=false;
  UserEventTime:=Now;
  for I := MDIChildCount - 1 downto 0 do
    if MDIChildren[I] is CT then
       begin
       if MDIChildren[I].WindowState=wsMinimized then
          MDIChildren[I].WindowState:=wsNormal;
       MDIChildren[I].show;
       result:=True;
       exit
    end;
end;

//-----------------------------------------------------------------------------}
function TMainForm.FindFirstChild(CT:TFormClass):TForm;
var i:integer;
begin
  Screen.Cursor:=crHourGlass;
  inherited;
  UserEventTime:=Now;
  for I := MDIChildCount - 1 downto 0 do
    if (MDIChildren[I] is CT) then
       begin
       if MDIChildren[I].WindowState=wsMinimized then
          MDIChildren[I].WindowState:=wsNormal;
       MDIChildren[I].BringToFront;
       result:=MDIChildren[I];
       exit
    end;
  Result:=CreateFromRes(CT)
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.TBCloseClick(Sender: TObject);
begin
  inherited;
  Close;
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.MIViewDFMClick(Sender: TObject);
begin
  inherited;
  CreateFromRes(fViewDFM.TFormViewDFM)
end;

//-----------------------------------------------------------------------------}
procedure TMainForm.MICpyClick(Sender: TObject);
begin
  inherited;
  CreateFromRes(fTranslateDFM.TFormTranslate)
  //FindFirstChild(fTranslateDFM.TFormTranslate);
end;

end.
 