unit DXDIBEdit;

interface

uses
  Windows, SysUtils, Classes, Forms, Dialogs, Controls, StdCtrls, ExtCtrls,
  ExtDlgs, Menus, DIB;

type

  {  TDelphiXDIBEditForm  }

  TDelphiXDIBEditForm = class(TForm)
    LoadButton: TButton;
    SaveButton: TButton;
    ClearButton: TButton;
    OKButton: TButton;
    CancelButton: TButton;
    Panel1: TPanel;
    Bevel1: TBevel;
    NoneLabel: TLabel;
    Shape: TShape;
    SizeLabel: TLabel;
    BitCountLabel: TLabel;
    Bevel2: TBevel;
    OpenDialog: TOpenPictureDialog;
    SaveDialog: TSavePictureDialog;
    ViewBox: TDXPaintBox;
    PopupMenu1: TPopupMenu;
    geGreyscale: TMenuItem;
    geNegative: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    N13: TMenuItem;
    N14: TMenuItem;
    geConvertColor: TMenuItem;
    N15: TMenuItem;
    N41: TMenuItem;
    N21: TMenuItem;
    N22: TMenuItem;
    N1: TMenuItem;
    geCompress: TMenuItem;
    geDecompress: TMenuItem;
    BitSizeLabel: TLabel;
    procedure OKButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure geGreyscaleClick(Sender: TObject);
    procedure geNegativeClick(Sender: TObject);
    procedure geConvertColorClick(Sender: TObject);
    procedure geCompressClick(Sender: TObject);
    procedure geDecompressClick(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
  private
    FChanged: Boolean;
    procedure UpdateData;
  end;

var
  DelphiXDIBEditForm: TDelphiXDIBEditForm;

implementation

uses DXConsts;

{$R *.DFM}

{  TDelphiXDIBEditForm  }

procedure TDelphiXDIBEditForm.FormShow(Sender: TObject);
begin
  UpDateData;
  CancelButton.SetFocus;
end;

procedure TDelphiXDIBEditForm.OKButtonClick(Sender: TObject);
begin
  if FChanged then
    Tag := 1;
  Close;
end;

procedure TDelphiXDIBEditForm.CancelButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TDelphiXDIBEditForm.ClearButtonClick(Sender: TObject);
begin
  FChanged := True;

  ViewBox.DIB.Clear;
  UpDateData;
end;

procedure TDelphiXDIBEditForm.LoadButtonClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    FChanged := True;

    ViewBox.DIB.LoadFromFile(OpenDialog.FileName);
    UpDateData;
  end;
end;

procedure TDelphiXDIBEditForm.SaveButtonClick(Sender: TObject);
begin
  if SaveDialog.Execute then
    ViewBox.DIB.SaveToFile(SaveDialog.FileName);
end;

procedure TDelphiXDIBEditForm.UpdateData;
var
  i: Integer;
begin
  if ViewBox.DIB.Size>0 then
  begin
    SizeLabel.Caption := Format(SDIBSize, [ViewBox.DIB.Width, ViewBox.DIB.Height]);

    i := ViewBox.DIB.BitCount;
    if i=32 then i := 32;
    BitCountLabel.Caption := Format(SDIBColor, [1 shl i]);
    BitSizeLabel.Caption := Format(SDIBBitSize, [ViewBox.DIB.BitmapInfo.bmiHeader.biSizeImage]);

    PopupMenu := PopupMenu1;

    NoneLabel.Visible := True;
    ClearButton.Enabled := True;
    NoneLabel.Visible := False;
    SaveButton.Enabled := True;
  end else
  begin
    SizeLabel.Caption := '';
    BitCountLabel.Caption := '';
    BitSizeLabel.Caption := '';

    PopupMenu := nil;

    NoneLabel.Visible := False;
    ClearButton.Enabled := False;
    NoneLabel.Visible := True;
    SaveButton.Enabled := False;
  end;

  PaletteChanged(True);
  ViewBox.Invalidate;
end;

procedure TDelphiXDIBEditForm.PopupMenu1Popup(Sender: TObject);
begin                                                                                
  geCompress.Enabled := (ViewBox.DIB.Size>0) and (ViewBox.DIB.BitCount in [4, 8]) and
    (not (ViewBox.DIB.BitmapInfo.bmiHeader.biCompression in [BI_RLE4, BI_RLE8]));
                                                                                                                               
  geDecompress.Enabled := (ViewBox.DIB.Size>0) and (ViewBox.DIB.BitmapInfo.bmiHeader.biCompression in [BI_RLE4, BI_RLE8]);
end;

procedure TDelphiXDIBEditForm.geConvertColorClick(Sender: TObject);
begin
  FChanged := True;
  ViewBox.DIB.PixelFormat := MakeDIBPixelFormat(8, 8, 8);
  ViewBox.DIB.BitCount := TMenuItem(Sender).Tag;
  UpdateData;
end;

procedure TDelphiXDIBEditForm.geGreyscaleClick(Sender: TObject);
begin
  FChanged := True;
  ViewBox.DIB.PixelFormat := MakeDIBPixelFormat(8, 8, 8);
  ViewBox.DIB.Greyscale(TMenuItem(Sender).Tag);
  UpdateData;
end;

procedure TDelphiXDIBEditForm.geNegativeClick(Sender: TObject);
begin
  FChanged := True;

  ViewBox.DIB.Negative;

  UpdateData;
end;

procedure TDelphiXDIBEditForm.geCompressClick(Sender: TObject);
begin
  FChanged := True;

  ViewBox.DIB.Compress;

  UpdateData;
end;

procedure TDelphiXDIBEditForm.geDecompressClick(Sender: TObject);
begin
  FChanged := True;

  ViewBox.DIB.Decompress;

  UpdateData;
end;

end.
