unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Comms;

type
  TForm1 = class(TForm)
    Memo: TMemo;
    ComPort: TComPort;
    SendEdit: TEdit;
    SendButton: TButton;
    OCButton: TButton;
    SetButton: TButton;
    SendNLCheckBox: TCheckBox;
    SendBulkButton: TButton;
    WaitCheckBox: TCheckBox;
    WaitButton: TButton;
    AbortButton: TButton;
    procedure OCButtonClick(Sender: TObject);
    procedure ComPortOpen(Sender: TObject);
    procedure ComPortClose(Sender: TObject);
    procedure SetButtonClick(Sender: TObject);
    procedure SendButtonClick(Sender: TObject);
    procedure ComPortRxChar(Sender: TObject; InQue: Integer);
    procedure SendBulkButtonClick(Sender: TObject);
    procedure WaitButtonClick(Sender: TObject);
    procedure AbortButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.OCButtonClick(Sender: TObject);
begin
  if ComPort.Connected then
    ComPort.Close
  else
    ComPort.Open;
end;

procedure TForm1.ComPortOpen(Sender: TObject);
begin
  OCButton.Caption := 'Close';
end;

procedure TForm1.ComPortClose(Sender: TObject);
begin
  OCButton.Caption := 'Open';
end;

procedure TForm1.SetButtonClick(Sender: TObject);
begin
  ComPort.ShowPropForm;
end;

procedure TForm1.SendButtonClick(Sender: TObject);
var
  Str: String;
begin
  Str := SendEdit.Text;
  if SendNLCheckBox.Checked then
    Str := Str + #13#10;
  ComPort.WriteString(Str, True);
end;

procedure TForm1.ComPortRxChar(Sender: TObject; InQue: Integer);
var
  Str: String;
begin
  ComPort.ReadString(Str, InQue, True);
  Memo.Text := Memo.Text + Str;
end;

procedure TForm1.SendBulkButtonClick(Sender: TObject);
var
  Buffer: array[0..999] of Char;
begin
  FillChar(Buffer[0], 1000, Ord('A'));
  ComPort.Write(Buffer[0], 1000, WaitCheckBox.Checked);
end;

procedure TForm1.WaitButtonClick(Sender: TObject);
begin
  ComPort.WaitForLastIO;
end;

procedure TForm1.AbortButtonClick(Sender: TObject);
begin
  ComPort.AbortAllIO;
end;

end.
