unit d3d2;

interface
{$I dc.inc}
uses
  sysutils, classes, dcgen,windows;

procedure MainProc;

implementation

procedure ShowHelp;
begin
  writeln;
  writeln('Usage: d3tod2 <badfile> <formfile> [-S]');
  writeln;
  writeln(' <badfile>  File with the list of properties that should be removed');
  writeln('<formfile>  form file which will be processed or path where search');
  writeln('            for the forms. If not specified then all forms in the');
  writeln('            current dir will be processed');
  writeln('        -S  If this parameter specified ');
  writeln('            then program will recursively process subfolders also');

end;

{---------------------------------------------------------------}

{ Same as TStrings.IndexOfName but does Trim before string processing }
function IndexOfName(s : TStrings; const name : string) : integer;
var
  i : integer;
  p : integer;
  st: string;
begin
  for i := 0 to s.count - 1 do
    begin
      st := s[i];
      p := pos('=', st);
      if p > 0 then
        begin
          st := trim(copy(s[i], 1, p - 1));
          if AnsiCompareText(st, name) = 0 then
            begin
              result := i;
              exit;
            end;
        end;
    end;
  result := -1;
end;

{---------------------------------------------------------------}

procedure RemoveStrings(S, RemoveList : TStrings);
var
  index : integer;
  i     : integer;
begin
  for i := 0 to RemoveList.Count - 1 do
    begin
      repeat
        index := IndexOfName(S, RemoveList[i]);
        if index >= 0 then
          S.Delete(index);
      until index < 0;
    end;
end;

{---------------------------------------------------------------}

procedure D3FormToD2Form(const BadFileName,FileName:String);
var
  BadNames  : TStringList;
  InStream  : TFileStream;
  OutStream : TFileStream;
  MemStream : TMemoryStream;
  NewForm   : TStringList;
  FormFile  : string;
//  NewFileInfo,FileInfo  : TWin32FileAttributeData;

begin
  BadNames := TStringList.Create;
  BadNames.LoadFromFile(BadFileName);

  FormFile := FileName;
  InStream := TFileStream.Create(FormFile, fmOpenRead);
  MemStream := TMemoryStream.Create;

  InStream.ReadResHeader;

  ObjectBinaryToText(InStream, MemStream);
  MemStream.Seek(0, 0);
  NewForm := TStringList.Create;

  NewForm.LoadFromStream(MemStream);

  RemoveStrings(NewForm, BadNames);

  MemStream.Seek(0,soFromBeginning);
  MemStream.SetSize(0);
  NewForm.SaveToStream(MemStream);
  MemStream.Seek(0, 0);
  InStream.Free;



//  GetFileAttributesEx(PChar(FormFile),GetFileExInfoStandard,@FileInfo);


  RenameToBak(FormFile);
  OutStream := TFileStream.Create(FormFile, fmCreate);
  ObjectTextToResource(MemStream, OutStream);

  OutStream.Free;
  NewForm.Free;
  MemStream.Free;
  BadNames.Free;

//  GetFileAttributesEx(PChar(FormFile),GetFileExInfoStandard,@NewFileInfo);

end;

{---------------------------------------------------------------}

type
  TFakeClass=class
  public
    BadName:String;
    procedure ConvertAll(const Path:String;var SearchRec: TSearchRec);
  end;

procedure TFakeClass.ConvertAll(const Path:String;var SearchRec: TSearchRec);
Var
  FileName:String;
begin
  FileName:=Path+SearchRec.Name;
  Writeln(FileName);
  D3FormToD2Form(BadName,FileName);
end;

{---------------------------------------------------------------}

procedure MainProc;
Var
  Path:String;
begin
  writeln('D3 to D2 Form Convertor.');
  writeln('Copyright (c) 1998 S.Kurinny & S.Kostinsky');
  If ParamCount=0 then
    ShowHelp
  else
    begin
      If (ParamCount=2) and (AnsiUpperCase(ParamStr(2))<>'-S') then
        D3FormToD2Form(Paramstr(1),ParamStr(2))
      else
        begin
          With TFakeClass.Create do
          try
            BadName:=ParamStr(1);
            If ExtractFilePath(BadName)='' then
              BadName:=AddSlash(GetCurrentDir)+BadName;

            Path:=GetCurrentDir;
            If ParamCount=3 then
              Path:=ParamStr(2);
            ForEachFile(AddSlash(Path)+'*.dfm',faAnyFile,
              AnsiUpperCase(ParamStr(ParamCount))='-S', ConvertAll);
          finally
            Free;
          end;
        end;
    end;
end;

begin
end.