unit DBxRichGrid;
{------------------------------------------------------------
Version 1.0
(c) Jens Vehlhaber
DBxRichGrid is freeware for Delphi 3 and 4.
DBxRichGrid is a data-aware grid control for diplay, browse and edit
RTF-Memofields with editor. Editor not close before browse.
working with Borland BDE and  (Picture and RTF-MemoText)
             Luxent Apollo 4.0x (only RTF-MemoText)
}

interface

uses
  SysUtils, WinTypes, WinProcs, Graphics, Messages, Classes, Controls,
  Forms, Dialogs, Grids, DBGrids, DB, DBTables, DBCtrls;


type
  TDBxRichGrid = class(TDBGrid)
  private
    { Private-Deklarationen }
    fDataLink : TFieldDataLink;
    fMemoEditable: Boolean;
    lMemo: Bool;
    function  GetDataSource: TDataSource;
    procedure SetDataSource(Value: TDataSource);
    procedure CloseMemo(Sender: TObject);
  protected
    { Protected-Deklarationen }
    procedure DrawColumnCell(const Rect: TRect; DataCol: Integer;
      Column: TColumn; State: TGridDrawState); override;
  public
    { Public-Deklarationen }
    constructor create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CellClick(Column: TColumn); override;
  published
    { Published-Deklarationen }
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property MemoEditable: Boolean read fMemoEditable write fMemoEditable;
  end;


procedure Register;

implementation
uses
  DBXRichGrMemo;

procedure Register;
begin
  // RegisterComponents('Data Controls', [TDBxRichGrid]);
  RegisterComponents('Datensteuerung', [TDBxRichGrid]);
end;

{---------------------------------------------------------------------------}
constructor TDBxRichGrid.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fDataLink := TFieldDataLink.Create;
  fDataLink.Control := Self;
  fDataLink.OnActiveChange := CloseMemo;
  fMemoEditable := True;
end;


destructor TDBxRichGrid.Destroy;
begin
  fDataLink.OnActiveChange := nil;
  fDataLink.Free;
  inherited Destroy;
end;


function TDBxRichGrid.GetDataSource: TDataSource;
begin
  Result := inherited DataSource;
end;


procedure TDBxRichGrid.SetDataSource(Value: TDataSource);
begin
  fDataLink.DataSource := Value;
  inherited DataSource := Value;
end;


procedure TDBxRichGrid.DrawColumnCell(const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
  DrawPict : TPicture;
  nWidth   : Integer;
  sText    : String;
  nStart   : Longint;
  nEnd     : Longint;
begin
  if Assigned(Column.Field) then
    begin
      case Column.Field.DataType of
        ftMemo, ftFmtMemo:
          begin
            sText :=  Column.Field.AsString;
            nStart := Pos( #13#10+'\' , sText);
            if nStart > 0 then
              begin
                sText  := Copy( sText, nStart + 33, 50 ) ;
                nStart := 1;
                while nStart > 0 do
                  begin
                    nStart := Pos( '\' , sText );
                    nEnd   := Pos( ' ' , Copy( sText, nStart , Length(sText)));
                    if nEnd = 0 then
                      nEnd := Length(sText) - nStart;
                    Delete( sText, nStart ,  nEnd );
                  end;
              end;
            nWidth := Rect.Right - (Rect.Left+2) - Canvas.TextWidth('...');
            if nWidth < 2 then
              nWidth := 2;
            repeat
              sText := copy(sText, 0, (length(sText) - 1));
            until Canvas.TextWidth(sText) < nWidth;
            Canvas.FillRect(Rect);
            Canvas.TextRect(Rect, Rect.Left+2, Rect.Top, sText + '...' );
          end;
        ftGraphic :
          begin
            DrawPict := TPicture.Create;
            try
              if Assigned(Column.Field) and
                Column.Field.IsBlob then
                begin
                  DrawPict.Assign(Column.Field);
                end;
              Canvas.StretchDraw( Rect, DrawPict.Graphic {HiddenBitmap as TGraphic});
            finally
              DrawPict.Free;
            end;
          end;
      else
        inherited DrawColumnCell( Rect, DataCol, Column, State);
      end;
    end;
end;


{ Open a Memofield editor }
procedure TDBxRichGrid.CellClick(Column: TColumn);
begin
  If DataSource = nil then
    begin
      inherited CellClick(Column);
      exit;
    end;
  Case Column.Field.DataType of
    ftMemo, ftFmtMemo:
      begin
        if lMemo = False then
          Application.CreateForm( TFormRichMemo, FormRichMemo );
        lMemo := True;
        if not (FormRichMemo.DBMemo1.DataField = '') then
          if not (FormRichMemo.DBMemo1.DataField = Column.Field.FieldName) then
            begin
              DataSource.DataSet.Edit;
              DataSource.DataSet.UpdateRecord;
            end;
        FormRichMemo.DBImage1.Visible   := False;
        FormRichMemo.DBMemo1.Visible    := True;
        FormRichMemo.DBMemo1.DataSource := DataSource;
        FormRichMemo.DBMemo1.DataField  := Column.Field.FieldName ;
        FormRichMemo.DBMemo1.Font       := Font;
        FormRichMemo.DBMemo1.Visible    := True;
        FormRichMemo.DBMemo1.Enabled    := FMemoEditable;
        FormRichMemo.Show;
      end;
    ftGraphic, ftBlob:
      begin
        if lMemo = False then
          Application.CreateForm( TFormRichMemo, FormRichMemo );
        lMemo := True;
        FormRichMemo.DBMemo1.Visible     := False;
        FormRichMemo.DBImage1.Visible    := True;
        FormRichMemo.DBImage1.DataSource := DataSource;
        FormRichMemo.DBImage1.DataField  := Column.Field.FieldName ;
        FormRichMemo.Show;
      end;
    else
      inherited CellClick(Column);
  end;
end;

{ Closed a open Memofield editor }
procedure TDBxRichGrid.CloseMemo(Sender: TObject);
begin
  if (fDataLink.Active = False) then
    begin
      if (lMemo = True) then
        begin
          FormRichMemo.DBMemo1.DataField := '';
          FormRichMemo.DBImage1.DataField := '';
          FormRichMemo.Close;
        end;
    end;
end;


end.
