unit DBxMemo;
{------------------------------------------------------------
Version 1.0
(c) Jens Vehlhaber
DBxMemo is freeware for Delphi 3 and 4.
DBxMemo is a data-aware control for edit and display a database Memo field.
DBxMemo:
 - Simple 3D style
 - Color on Focus
 - Database navigation with PgUp or PgDwn
 - Enter and Up, Down Keys for change Field and Column
working with Borland BDE and
             Luxent Apollo 4.0x

DBxMemo:
 - Einfaches 3D Layout : Die Daten stehen in Vordergrund und nicht
                         die Controls!!!
 - Hintergrundfarbe bei Anwahl
 - Datenbanknavigation mit Bild-Auf und -Ab Tasten
 - Kursortasten Auf und Ab sowie Entertaste fr Wechsel des Eingabefeldes und
   Bewegen durch die Zeilen im Memofeld
getestet mit Borland BDE und
             Luxent Apollo 4.0x
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, db;

type
  TDBxMemo = class(TDBMemo)
  private
    { Private declarations }
    FCursorEndField      : Boolean;
    FOnEnter             : TNotifyEvent;
    FOnExit              : TNotifyEvent;
    fColorOnFocus        : TColor;
    fFontColorOnFocus    : TColor;
    fFontColorOnNotFocus : TColor;
    fOldColor            : TColor;
    fOnEOF               : TNotifyEvent;
    fOnPrev              : TNotifyEvent;
    procedure WMNCPaint (var Message: TMessage); message WM_NCPAINT;
    procedure RedrawBorder(const Clip: HRGN);
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure DOEnter; override;
    procedure DOExit; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    constructor Create(AOwner : TComponent); override;
  published
    { Published declarations }
    property  ColorOnFocus : TColor read fColorOnFocus write fColorOnFocus Default clTeal;
    property  CursorEndField : Boolean  read FCursorEndField write FCursorEndField Default True;
    property  FontColorOnFocus : TColor read fFontColorOnFocus write fFontColorOnFocus Default clWhite;
    { Published events }
    property  OnEnter: TNotifyEvent read FOnEnter write FOnEnter;
    property  OnExit : TNotifyEvent read FOnExit  write FOnExit;
    property  OnEndOfFile : TNotifyEvent read fOnEOF write fOnEOF;
    property  OnPrevNavigate : TNotifyEvent read fOnPrev write fOnPrev;
  end;

procedure Register;

implementation

procedure Register;
begin
  // RegisterComponents('Data Controls', [TDBxEdit]);
  RegisterComponents('Datensteuerung', [TDBxMemo]);
end;

{---------------------------------------------------------------------------}
constructor TDBxMemo.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  AutoSize            := False;
  Color               := clMenu;
  ColorOnFocus        := clTeal;
  CursorEndField      := True;
  FontColorOnFocus    := clWhite;
  Font.Name           := 'Fixedsys';
end;


procedure TDBxMemo.DoEnter;
begin
  fOldColor            := Color;
  Color                := fColorOnFocus;
  fFontColorOnNotFocus := Font.Color;
  Font.Color           := fFontColorOnFocus;
  if fCursorEndField then
    begin
      SelStart := Length(Trim(Text));
      SelLength := 0;
    end
  else
    SelStart := 0;
  if Assigned(FOnEnter) then
    FOnEnter(Self);
end;


procedure TDBxMemo.DoExit;
begin
  Color      := fOldColor;
  Font.Color := fFontColorOnNotFocus;
  if Assigned(FOnExit) then
    FOnExit(Self);
end;


procedure TDBxMemo.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case Key of
    33: begin                   // PgUp
          Datasource.Dataset.Prior;
          Key := 0;
          if Assigned(fOnPrev) then
            fOnPrev(Self);
        end;
    34: begin                   // PgDown
          Datasource.Dataset.Next;
          Key := 0;
          if (Datasource.Dataset.EOF = True) then
            if Assigned(fOnEOF) then
              fOnEOF(Self);
        end;
    38: begin                   // Up
          if SelStart <= Length(Lines[0]) then
            begin
              SendMessage( GetParentForm(Self).Handle, WM_NEXTDLGCTL, VK_SHIFT, 0);
              Key := 0;
            end;
          end;
    40: begin                   // Down
          if SelStart > Length( Text ) - Length(Lines[Lines.Count-1]) - 1 then
            begin
              SendMessage( GetParentForm(Self).Handle, WM_NEXTDLGCTL, 0, 0);
              Key := 0;
            end;
        end;
  end;

  if (Key > 0) then
    inherited KeyDown( Key, Shift);
end;


procedure TDBxMemo.WMNCPaint (var Message: TMessage);
begin
  inherited;
  if Ctl3D = True then
    RedrawBorder(Message.WParam);
end;


procedure TDBxMemo.RedrawBorder(const Clip: HRGN);
var
  DC           : HDC;
  R            : TRect;
  NewClipRgn   : HRGN;
  BtnFaceBrush : HBRUSH;
begin
  DC := GetWindowDC(Handle);
  try
    if Clip <> 0 then
      begin
        GetWindowRect (Handle, R);
        if SelectClipRgn(DC, Clip) = ERROR then
          begin
            NewClipRgn := CreateRectRgnIndirect(R);
            SelectClipRgn (DC, NewClipRgn);
            DeleteObject (NewClipRgn);
          end;
        OffsetClipRgn (DC, -R.Left, -R.Top);
      end;
    GetWindowRect (Handle, R);
    OffsetRect (R, -R.Left, -R.Top);
    BtnFaceBrush := CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
    DrawEdge (DC, R, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
    FrameRect (DC, R, BtnFaceBrush);
    DeleteObject (BtnFaceBrush);
  finally
    ReleaseDC (Handle, DC);
  end;
end;

end.
