unit DBxGrid;
{------------------------------------------------------------
Version 1.0
(c) Jens Vehlhaber
DBxGrid is freeware for Delphi 3 and 4.
DBxGrid is a data-aware grid control for diplay, browse and edit
Memofields with editor. Editor not close before browse.
working with Borland BDE and  (Picture and MemoText)
             Luxent Apollo 4.0x (only MemoText)
}

interface

uses
  SysUtils, WinTypes, WinProcs, Graphics, Messages, Classes, Controls,
  Forms, Dialogs, Grids, DBGrids, DB, DBTables, DBCtrls;


type
  TDBxGrid = class(TDBGrid)
  private
    { Private-Deklarationen }
    fDataLink : TFieldDataLink;
    fMemoEditable: Boolean;
    lMemo: Bool;
    function GetDataSource: TDataSource;
    procedure SetDataSource(Value: TDataSource);
    procedure CloseMemo(Sender: TObject);
  protected
    { Protected-Deklarationen }
    procedure DrawColumnCell(const Rect: TRect; DataCol: Integer;
      Column: TColumn; State: TGridDrawState); override;
  public
    { Public-Deklarationen }
    constructor create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure CellClick(Column: TColumn); override;
  published
    { Published-Deklarationen }
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property MemoEditable: Boolean read fMemoEditable write fMemoEditable;
  end;


procedure Register;

implementation
uses
  DBxGridMemo;

procedure Register;
begin
  // RegisterComponents('Data Controls', [TDBxComboBox]);
  RegisterComponents('Datensteuerung', [TDBxGrid]);
end;

{---------------------------------------------------------------------------}
constructor TDBxGrid.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fDataLink := TFieldDataLink.Create;
  fDataLink.Control := Self;
  fDataLink.OnActiveChange := CloseMemo;
  fMemoEditable := True;
end;


destructor TDBxGrid.Destroy;
begin
  fDataLink.OnActiveChange := nil;
  fDataLink.Free;
  inherited Destroy;
end;


function TDBxGrid.GetDataSource: TDataSource;
begin
  Result := inherited DataSource;
end;


procedure TDBxGrid.SetDataSource(Value: TDataSource);
begin
  fDataLink.DataSource := Value;
  inherited DataSource := Value;
end;


procedure TDBxGrid.DrawColumnCell(const Rect: TRect; DataCol: Integer; Column: TColumn; State: TGridDrawState);
var
  DrawPict : TPicture;
  nWidth   : Integer;
  sText    : String;
begin
  if Assigned(Column.Field) then
    begin
      case Column.Field.DataType of
        ftMemo, ftFmtMemo:
          begin
            sText :=  Column.Field.AsString;
            nWidth := Rect.Right - (Rect.Left+2) - Canvas.TextWidth('...');
            if nWidth < 2 then
              nWidth := 2;
            repeat
              sText := copy(sText, 0, (length(sText) - 1));
            until Canvas.TextWidth(sText) < nWidth;
            Canvas.FillRect(Rect);
            Canvas.TextRect(Rect, Rect.Left+2, Rect.Top, sText + '...' );
          end;
        ftGraphic :
          begin
            DrawPict := TPicture.Create;
            try
              if Assigned(Column.Field) and
                Column.Field.IsBlob then
                begin
                  DrawPict.Assign(Column.Field);
                end;
              Canvas.StretchDraw( Rect, DrawPict.Graphic {HiddenBitmap as TGraphic});
            finally
              DrawPict.Free;
            end;
          end;
      else
        inherited DrawColumnCell( Rect, DataCol, Column, State);
      end;
    end;
end;


{ Open a Memofield editor }
procedure TDBxGrid.CellClick(Column: TColumn);
begin
  If DataSource = nil then
    begin
      inherited CellClick(Column);
      exit;
    end;
  Case Column.Field.DataType of
    ftMemo, ftFmtMemo:
      begin
        if lMemo = False then
          Application.CreateForm( TFormMemo, FormMemo );
        lMemo := True;
        if not (FormMemo.DBMemo1.DataField = '') then
          if not (FormMemo.DBMemo1.DataField = Column.Field.FieldName) then
            begin
              DataSource.DataSet.Edit;
              DataSource.DataSet.UpdateRecord;
            end;
        FormMemo.DBImage1.Visible   := False;
        FormMemo.DBMemo1.Visible    := True;
        FormMemo.DBMemo1.DataSource := DataSource;
        FormMemo.DBMemo1.DataField  := Column.Field.FieldName ;
        FormMemo.DBMemo1.Font       := Font;
        FormMemo.DBMemo1.Visible    := True;
        FormMemo.DBMemo1.Enabled    := FMemoEditable;
        FormMemo.Show;
      end;
    ftGraphic, ftBlob:
      begin
        if lMemo = False then
          Application.CreateForm( TFormMemo, FormMemo );
        lMemo := True;
        FormMemo.DBMemo1.Visible     := False;
        FormMemo.DBImage1.Visible    := True;
        FormMemo.DBImage1.DataSource := DataSource;
        FormMemo.DBImage1.DataField  := Column.Field.FieldName ;
        FormMemo.Show;
      end;
    else
      inherited CellClick(Column);
  end;
end;

{ Closed a open Memofield editor }
procedure TDBxGrid.CloseMemo(Sender: TObject);
begin
  if (fDataLink.Active = False) then
    begin
      if (lMemo = True) then
        begin
          FormMemo.DBMemo1.DataField := '';
          FormMemo.DBImage1.DataField := '';
          FormMemo.Close;
        end;
    end;
end;


end.
