unit DBxEdit;
{------------------------------------------------------------
Version 1.0
(c) Jens Vehlhaber
DBxEdit is freeware for Delphi 3 and Delphi 4.
DBxEdit is a data-aware control for edit and display a database field.
DBxEdit:
 - Simple 3D style
 - Color on Focus
 - Set first input char upper
 - Limiting numeric input key's
 - Database navigation with PgUp or PgDwn
 - Enter and Up, Down Keys for change Field
 - if end of field skip to next field
working with Borland BDE and
             Luxent Apollo 4.0x

DBxEdit:
 - Einfaches 3D Layout : Die Daten stehen in Vordergrund und nicht
                         die Controls!!!
 - Hintergrundfarbe bei Anwahl
 - Schreibt bei Eingabe ersten Buchstaben im Feld gro
 - Eingabe auf Zahlen beschrnken
 - Datenbanknavigation mit Bild-Auf und -Ab Tasten
 - Enter und Auf-, Ab-Cursortasten fr Eingabefeldwechsel
 - Sprung zum nchsten Datenbankfeld bei erreichen des Feldendes
getestet mit Borland BDE und
             Luxent Apollo 4.0x
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, db;

type
  TDBxEdit = class(TDBEdit)
  private
    { Private declarations }
    fColorOnFocus        : TColor;
    fFontColorOnFocus    : TColor;
    fFontColorOnNotFocus : TColor;
    fOldColor            : TColor;
    FCursorEndField      : Boolean;
    FInputNum            : Boolean;
    FUpper               : Boolean;
    FNextFieldOnEnd      : Boolean;
    fOnEnter             : TNotifyEvent;
    fOnExit              : TNotifyEvent;
    fOnEOF               : TNotifyEvent;
    fOnPrev              : TNotifyEvent;
    procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT;
    procedure RedrawBorder(const Clip: HRGN);
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure DOEnter; override;
    procedure DOExit; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    constructor Create(AOwner : TComponent); override;
  published
    { Published declarations }
    property  ColorOnFocus : TColor read fColorOnFocus write fColorOnFocus Default clTeal;
    property  CursorEndField : Boolean  read FCursorEndField write FCursorEndField Default False;
    property  CursorNextField : Boolean  read FNextFieldOnEnd write FNextFieldOnEnd Default False;
    property  FontColorOnFocus : TColor read fFontColorOnFocus write fFontColorOnFocus Default clWhite;
    property  FirstCharUpper : Boolean read FUpper write FUpper;
    property  InputNumeric : Boolean read FInputNum write FInputNum Default False;
    { Published events }
    property  OnEnter: TNotifyEvent read FOnEnter write FOnEnter;
    property  OnExit : TNotifyEvent read FOnExit  write FOnExit;
    property  OnEndOfFile : TNotifyEvent read fOnEOF write fOnEOF;
    property  OnPrevNavigate : TNotifyEvent read fOnPrev write fOnPrev;
  end;

procedure Register;

implementation

procedure Register;
begin
  // RegisterComponents('Data Controls', [TDBxEdit]);
  RegisterComponents('Datensteuerung', [TDBxEdit]);
end;

{---------------------------------------------------------------------------}
constructor TDBxEdit.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  AutoSize             := False;
  Color                := clMenu;
  ColorOnFocus         := clTeal;
  CursorEndField       := False;
  FontColorOnFocus     := clWhite;
  FUpper               := False;
  Height               := 19;
  InputNumeric         := False;
  Font.Name            := 'Fixedsys';
end;


procedure TDBxEdit.DoEnter;
begin
  inherited;
  fOldColor            := Color;
  Color                := fColorOnFocus;
  fFontColorOnNotFocus := Font.Color;
  Font.Color           := fFontColorOnFocus;
  if fCursorEndField then
    SelStart := Length(Trim(Text));
  if Assigned(FOnEnter) then
    FOnEnter(Self);
end;


procedure TDBxEdit.DoExit;
begin
  inherited;
  Color      := fOldColor;
  Font.Color := fFontColorOnNotFocus;
  if Assigned(FOnExit) then
    FOnExit(Self);
end;


procedure TDBxEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case Key of
    33: begin                   // PgUp
          Datasource.Dataset.Prior;
          Key := 0;
          if Assigned(fOnPrev) then
            fOnPrev(Self);
        end;
    34: begin                   // PgDown
          Datasource.Dataset.Next;
          Key := 0;
          if (Datasource.Dataset.EOF = True) then
            if Assigned(fOnEOF) then
              fOnEOF(Self);
        end;
    38: begin                   // Up
          SendMessage( GetParentForm(Self).Handle, WM_NEXTDLGCTL, VK_SHIFT, 0);
          Key := 0;
        end;
    40: begin                   // Down
          SendMessage( GetParentForm(Self).Handle, WM_NEXTDLGCTL, 0, 0);
          Key := 0;
        end;
  end;
  if (InputNumeric = True) then
    if not (Key in [0..27, 32, 48..57]) then
      begin
        Key := 0;
      end;
  if (Key > 0) then
    inherited KeyDown( Key, Shift);
end;


procedure TDBxEdit.KeyPress(var Key: Char);
var
  c : String;
begin
  if (Key = #13) then   // Enter
    begin
      SendMessage(GetParentForm(Self).Handle, WM_NEXTDLGCTL, 0, 0);
      Key := #0;
    end;

  if FUpper = True then
    if (Length(Text) = 0) or
       (SelText = Text) then
      begin
        C := AnsiUpperCase(Key);
        Key := C[1];
      end;

  if Key <> #0 then
    inherited KeyPress(Key);
end;


procedure TDBxEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if (MaxLength > 0) then
    if (SelLength = 0) then
      if (Key > 40) and (Length(Trim(Text)) = MaxLength) and (SelStart = MaxLength) then
        begin
          MessageBeep( 0 );
          if FNextFieldOnEnd = True then
            SendMessage(GetParentForm(Self).Handle, WM_NEXTDLGCTL, 0, 0);
        end;
  inherited KeyUp( Key, Shift);
end;


procedure TDBxEdit.WMNCPaint(var Message: TMessage);
begin
  inherited;
  if Ctl3D = True then
    RedrawBorder(Message.WParam);
end;


procedure TDBxEdit.RedrawBorder(const Clip: HRGN);
var
  DC           : HDC;
  R            : TRect;
  NewClipRgn   : HRGN;
  BtnFaceBrush : HBRUSH;
begin
  DC := GetWindowDC(Handle);
  try
    if Clip <> 0 then
      begin
        GetWindowRect (Handle, R);
        if SelectClipRgn(DC, Clip) = ERROR then
          begin
            NewClipRgn := CreateRectRgnIndirect(R);
            SelectClipRgn (DC, NewClipRgn);
            DeleteObject (NewClipRgn);
          end;
        OffsetClipRgn (DC, -R.Left, -R.Top);
      end;
    GetWindowRect (Handle, R);
    OffsetRect (R, -R.Left, -R.Top);
    BtnFaceBrush := CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
    DrawEdge (DC, R, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
    FrameRect (DC, R, BtnFaceBrush);
    DeleteObject (BtnFaceBrush);
  finally
    ReleaseDC (Handle, DC);
  end;
end;

end.
