unit DBxCombo;
{------------------------------------------------------------
Version 1.0
(c) Jens Vehlhaber
DBxComboBox is freeware for Delphi 3 and 4
DBxComboBox is a data-aware control for finding and display
items from DropDown list with database field entry substring.
If not found then display or add database field to itemlist.
DBxComboBox:
 - Display Dropdown-Listitem with a substring or numeric value
   from database record
 - Simple 3D style
 - Color on Focus
 - Database navigation with PgUp or PgDwn
 - Enter and Up, Down Keys for change Field
working with Borland BDE and
             Luxent Apollo 4.0x

DBxComboBox:
 - Anzeige eins Dropdown-Listenwertes mittels einer Zeichenkette oder
   eines numerischen Datenbankeintrages
 - Einfaches 3D Layout : Die Daten stehen in Vordergrund und nicht
                         die Controls!!!
 - Hintergrundfarbe bei Anwahl
 - Datenbanknavigation mit Bild-Auf und -Ab Tasten
 - Enter und Auf-, Ab-Cursortasten fr Eingabefeldwechsel
getestet mit Borland BDE und
             Luxent Apollo 4.0x
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, db;

type
  TDBxComboBox = class(TComboBox)
  private
    { Private-Deklarationen }
    fDataLink     : TFieldDataLink;
    fOnEOF        : TNotifyEvent;
    fOnPrev       : TNotifyEvent;
    fItemsAdd     : Boolean;
    fActive       : Boolean;
    fReadOnly     : Boolean;
    procedure WMNCPaint (var Message: TMessage); message WM_PAINT;
    procedure RedrawBorder(const Clip: HRGN);
    procedure SeekEntry;
  protected
    { Protected-Deklarationen }
    procedure DoEnter; override;
    procedure DoExit; override;
    function GetDataSource: TDataSource;
    procedure SetDataSource(Value: TDataSource);
    function GetDataField: string;
    procedure SetDataField(const Field: string); virtual;
    procedure RecordChange(Sender: TObject); virtual;
    procedure Change; override;
  public
    { Public-Deklarationen }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
  published
    { Published-Deklarationen }
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property DataField: string read GetDataField write SetDataField;
    property ItemsAdd: Boolean read fItemsAdd write fItemsAdd Default False;
    property ReadOnly: Boolean read fReadOnly write fReadOnly Default False;
    property OnEndOfFile : TNotifyEvent read fOnEOF write fOnEOF;
    property OnPrevNavigate : TNotifyEvent read fOnPrev write fOnPrev;
  end;

procedure Register;

implementation

procedure Register;
begin
  // RegisterComponents('Data Controls', [TDBxComboBox]);
  RegisterComponents('Datensteuerung', [TDBxComboBox]);
end;

{---------------------------------------------------------------------------}
constructor TDBxComboBox.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  fDataLink := TFieldDataLink.Create;
  fDataLink.Control := Self;
  fDataLink.OnDataChange := RecordChange;
  Color     := clMenu;
  Font.Name := 'Fixedsys';
  fItemsAdd := False;
end;


destructor TDBxComboBox.Destroy;
begin
  fDataLink.OnDataChange := nil;
  fDataLink.Free;
  inherited Destroy;
end;


function TDBxComboBox.GetDataSource: TDataSource;
begin
  Result := fDataLink.DataSource;
end;


procedure TDBxComboBox.SetDataSource(Value: TDataSource);
begin
  fDataLink.DataSource := Value;
end;


function TDBxComboBox.GetDataField: string;
begin
  Result := fDataLink.FieldName;
end;


procedure TDBxComboBox.SetDataField(const Field: string);
begin
  fDataLink.FieldName := Field;
end;


procedure TDBxComboBox.DoEnter;
begin
  inherited;
  fActive := True;
end;


procedure TDBxComboBox.DoExit;
begin
  inherited;
  fActive := False;
end;


procedure TDBxComboBox.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case Key of
    33: begin                   // PgUp
          Datasource.Dataset.Prior;
          Key := 0;
          fActive := False;
          RecordChange(Self);
          fActive := True;
          if Assigned(fOnPrev) then
          fOnPrev(Self);
        end;
    34: begin                   // PgDown
          Datasource.Dataset.Next;
          Key := 0;
          fActive := False;
          RecordChange(Self);
          fActive := True;
          if (Datasource.Dataset.EOF = True) then
            if Assigned(fOnEOF) then
              fOnEOF(Self);
        end;
    38: begin                   // Up
          SendMessage( GetParentForm(Self).Handle, WM_NEXTDLGCTL, VK_SHIFT, 0);
          Key := 0;
        end;
    40: begin                   // Down
          SendMessage( GetParentForm(Self).Handle, WM_NEXTDLGCTL, 0, 0);
          Key := 0;
        end;
  end;
  if (Key <> 0) then
    inherited KeyDown( Key, Shift);
end;


procedure TDBxComboBox.KeyPress(var Key: Char);
var
  FEditTemp : TCustomForm; 
begin
  if (Key = #13) then   // Enter
    begin
      FEditTemp := GetParentForm(Self);
      SendMessage(FEditTemp.Handle, WM_NEXTDLGCTL, 0, 0);
      Key := #0;
    end;
  if Key <> #0 then
    inherited KeyPress(Key);
end;


procedure TDBxComboBox.SeekEntry;
var
  Index: Integer;
  S : String;
begin
  if fActive = False then
    begin
      case fDataLink.Field.DataType of
        ftString:
          begin
            S := fDataLink.Field.AsString + #0;
            Index := SendMessage( handle, CB_FindString, $0, LongInt(@S[1]));
            if Index <> -1 then
              ItemIndex := Index
            else
              begin
                text := fDataLink.Field.AsString;
                if fItemsAdd = True then
                  items.Add( fDataLink.Field.AsString );
              end;
          end;
        ftFloat,ftInteger:
          begin
            if (items.count >= fDataLink.Field.AsInteger -1) then
              ItemIndex := fDataLink.Field.AsInteger -1
            else
              Text := IntToStr(fDataLink.Field.AsInteger);
          end;
      end;
    end;
end;


procedure TDBxComboBox.RecordChange(Sender: TObject);
begin
  if Assigned(fDataLink.Field)= True then
    SeekEntry
  else
    Text := '';
end;


procedure TDBxComboBox.Change;
begin
  inherited Change;
  if fDataLink.Edit = True and
    fReadOnly = False then
    begin
      case fDataLink.Field.DataType of
        ftString: fDataLink.Field.AsString := Text;
        ftFloat,ftInteger:
          begin
            if items.IndexOf( Text ) = -1 then
              fDataLink.Field.AsInteger := StrToIntDef( Text, 0 )
            else
              fDataLink.Field.AsInteger := items.IndexOf( Text ) + 1;
          end;
      end;
    end;
end;


procedure TDBxComboBox.WMNCPaint (var Message: TMessage);
begin
  inherited;
  if Ctl3D = True then
    RedrawBorder(Message.WParam);
end;


procedure TDBxComboBox.RedrawBorder(const Clip: HRGN);
var
  DC           : HDC;
  R            : TRect;
  NewClipRgn   : HRGN;
  BtnFaceBrush : HBRUSH;
begin
  DC := GetWindowDC(Handle);
  try
    if Clip <> 0 then
      begin
        GetWindowRect (Handle, R);
        if SelectClipRgn(DC, Clip) = ERROR then
          begin
            NewClipRgn := CreateRectRgnIndirect(R);
            SelectClipRgn (DC, NewClipRgn);
            DeleteObject (NewClipRgn);
          end;
        OffsetClipRgn (DC, -R.Left, -R.Top);
      end;
    GetWindowRect (Handle, R);
    OffsetRect (R, -R.Left, -R.Top);
    BtnFaceBrush := CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
    DrawEdge (DC, R, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
    FrameRect (DC, R, BtnFaceBrush);
    DeleteObject (BtnFaceBrush);
  finally
    ReleaseDC (Handle, DC);
  end;
end;

end.
