unit DBxCheckBox;
{------------------------------------------------------------
Version 1.0
(c) Jens Vehlhaber
DBxCheckBox is freeware for Delphi 3 and 4
 - Color on Focus
 - Database navigation with PgUp or PgDwn
 - Enter for change Field
working with Borland BDE and
             Luxent Apollo 4.0x

}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls;

type
  TDBxCheckBox = class(TDBCheckBox)
  private
    { Private-Deklarationen }
    fOnEOF        : TNotifyEvent;
    fOnPrev       : TNotifyEvent;
    procedure WMSetFocus(var Message: TMessage); message WM_SetFOCUS;
    procedure RedrawBorder;
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    constructor Create(AOwner : TComponent); override;
  published
    { Published-Deklarationen }

    { Published events }
    property OnEndOfFile : TNotifyEvent read fOnEOF write fOnEOF;
    property OnPrevNavigate : TNotifyEvent read fOnPrev write fOnPrev;

  end;

procedure Register;

implementation

procedure Register;
begin
  // RegisterComponents('Data Controls', [TDBxCheckBox]);
  RegisterComponents('Datensteuerung', [TDBxCheckBox]);
end;

constructor TDBxCheckBox.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
end;

procedure TDBxCheckBox.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case Key of
    33: begin                   // PgUp
          Datasource.Dataset.Prior;
          Key := 0;
          if Assigned(fOnPrev) then
            fOnPrev(Self);
        end;
    34: begin                   // PgDown
          Datasource.Dataset.Next;
          Key := 0;
          if (Datasource.Dataset.EOF = True) then
            if Assigned(fOnEOF) then
              fOnEOF(Self);
        end;
  end;
  if (Key > 0) then
    inherited KeyDown( Key, Shift);
end;

procedure TDBxCheckBox.KeyPress(var Key: Char);
begin
  if (Key = #13) then   // Enter
    begin
      SendMessage(GetParentForm(Self).Handle, WM_NEXTDLGCTL, 0, 0);
      Key := #0;
    end
  else
    inherited KeyPress(Key);
end;


procedure TDBxCheckBox.WMSetFocus(var Message: TMessage);
begin
  inherited;
  RedrawBorder;
end;


procedure TDBxCheckBox.RedrawBorder;
var
  DC           : HDC;
  R            : TRect;
  FCanvas      : TCanvas;
begin
  FCanvas:=TCanvas.Create;
  DC := GetWindowDC(Handle);
  try
    GetWindowRect (Handle, R);
    OffsetRect (R, -R.Left , -R.Top );
    FCanvas.handle:=DC;
    FCanvas.Brush.Color := clTeal;
    FCanvas.FloodFill( R.Left+2, Round(R.Bottom/2), clWhite, fsSurface );
    FCanvas.Brush.Color := clHighlightText;
    FCanvas.FloodFill( R.Left+4, Round(R.Bottom/2), clBlack, fsSurface );
  finally
    ReleaseDC (Handle, DC);
  end;
  FCanvas.Free;
end;


end.
