unit DBPicker;

{

  TDBPicker : Version 1.01
  Date      : 1/6/1998
  Author    : Theodoros Bebekis
  E-mail    : bebekis@mail.otenet.gr

  Description:
   1. Opens a DB file by an Index (if Index does not exist then TDBPicker creates it)
   2. Moves the cursor to a record defined by FindKey
   3. Returns the value(s) from any field(s) defined by DataFieldNames (see procedure GetDBPickerResult)

  Note:
    Freeware.
    Make it anything you want (ie sell it) , but don't blame me for any damage you can get using it.
    Kisses
}

interface


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables;

type


  TDBPicker = class(TComponent)
  private  //=======================================================================================
    FTable: TTable;
    FDatabaseName,
    FTableName:string;

    procedure SetDataBaseName(Value:string);
    procedure SetTableName(Value:string);
    procedure CheckIndexName(xIndexFieldName,xIndexName:string);

  public   //=======================================================================================
    constructor Create(AOwner: TComponent);override;
    destructor Destroy; override;


    procedure  GetDBPickerResult(IndexFieldName,
                                IndexName:string;
                                IndexFieldValue:variant; 
                                DataFieldNames: array of string;   
                                ListOfValues:TStrings);
  published
    property DataBaseName:string read FDataBaseName write SetDataBaseName;
    property TableName:string    read FTableName    write SetTableName;

  end;




procedure Register;





implementation


{===============================================================================

                         TDBPicker Routines

===============================================================================}



{-------------------------Create-------------------------------------}
constructor TDBPicker .Create(AOwner:TComponent);
begin
  inherited Create(AOwner);    
  FTable:=TTable.Create(Self);
end;    { Create }

{------------------------------Destroy-------------------------------------}
destructor TDBPicker .Destroy;
begin
  FTable.Free;
  inherited Destroy;
end;  { Destroy }




{-------------------------CheckIndexName---------------------------------
  if Index does not exist then create it
------------------------------------------------------------------}
procedure TDBPicker.CheckIndexName(xIndexFieldName,xIndexName:string);
var
  bFound:boolean;
begin

  with FTable do
  begin
    IndexDefs.Update ;
    Close;
    Exclusive:=True;
    Open ;
    bFound:=IndexDefs.IndexOf(xIndexName) <> -1;
    if not bFound then AddIndex(xIndexName, xIndexFieldName, []);
    Close;
  end;

end;  { CheckIndexName }




{------------------------GetDBPickerResult------------------------------------------
    Parameters:
      IndexFieldName,                    The name of the indexed field
      IndexName:string;                  The index.If doesn't exist TDBPicker will create it
      IndexFieldValue:variant;           The value of the indexed field
      DataFieldNames: array of string;   A list of fields to get the values
      ListOfValues:TStrings              A TStrings values holder
-----------------------------------------------------------------------------------}
procedure  TDBPicker.GetDBPickerResult(IndexFieldName,IndexName:string;IndexFieldValue:variant;
                                       DataFieldNames: array of string; ListOfValues:TStrings);
var
 i:integer;
begin

  FTable.Close;
  CheckIndexName(IndexFieldName,IndexName);  //  if Index does not exist then create it
  FTable.IndexName:=IndexName;

  with FTable do
  begin
    Open;
    if not FindKey([IndexFieldValue])
    then ShowMessage('IndexFieldValue Not Found')
    else
      begin
        for i:=Low(DataFieldNames) to High(DataFieldNames) do
        ListOfValues.Add(FieldByName(DataFieldNames[i]).AsString);
      end;
    Close;
  end;

end;    { GetDBPickerResult }



{===============================================================================
////////////////////////////////////////////////////////////////////////////////
///                                                                          ///
///                                                                          ///
                            ACCESS METHODS
///                                                                          ///
///                                                                          ///
////////////////////////////////////////////////////////////////////////////////
===============================================================================}


{-------------------SetDataBaseName--------------------------------------------

------------------------------------------------------------------------------}
procedure TDBPicker.SetDataBaseName(Value:string);
begin
  if Value <> FDataBaseName
  then
    begin
      FDataBaseName:=Value;
      FTable.Close;
      FTable.DataBaseName:=Value;
    end;
end;  { SetDataBaseName }

{-------------------SetTableName-----------------------------------------------

------------------------------------------------------------------------------}
procedure TDBPicker.SetTableName(Value:string);
begin
  if Value <> FTableName
  then
    begin
      FTableName:=Value;
      FTable.Close;
      FTable.TableName:=Value;
    end;
end;  { SetTableName }


{---------------------------Register-----------------------------------------
------------------------------------------------------------------------------}
procedure Register;
begin
   RegisterComponents('MyDBTools', [TDBPicker]);
end;

end.
