unit Utilcolr;

interface

{$IFDEF WIN32}
uses Windows, Graphics;
{$ELSE}
uses WinTypes, Graphics;
{$ENDIF}

const
  NumPaletteEntries = 32;

var
  PaletteEntries: array[0..NumPaletteEntries - 1] of TPaletteEntry;


function GetColor(Couleur:Integer): TColor;

implementation

{$IFDEF WIN32}
uses SysUtils, Consts, StdCtrls;
{$ELSE}
uses SysUtils, WinProcs, Consts, StdCtrls;
{$ENDIF}

function GetColor(Couleur:Integer): TColor;
var
  PalIndex: Integer;
begin
  GetPaletteEntries(GetStockObject(DEFAULT_PALETTE), 0, NumPaletteEntries,
                    PaletteEntries);
  if Couleur < 8 then
    PalIndex:= Couleur
  else
    PalIndex:= Couleur + 4;
  with PaletteEntries[PalIndex] do
    Result := TColor(RGB(peRed, peGreen, peBlue));
end;

function GetColorEx(Couleur:Integer): TColor;
begin
  GetPaletteEntries(GetStockObject(DEFAULT_PALETTE), 0, NumPaletteEntries,
                    PaletteEntries);
  with PaletteEntries[Couleur] do
    Result := TColor(RGB(peRed, peGreen, peBlue));
end;

end.
 