unit FProgress;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TProgressForm = class(TForm)
    ProgressBar: TProgressBar;
    StatusLabel: TLabel;
    CancelButton: TButton;
  private // --------------------------------------------- Private declarations

  protected // ----------------------------------------- Protected declarations
    procedure SetMinValue      (Value : Integer);
    procedure SetMaxValue      (Value : Integer);
    procedure SetStatusMessage (Value : String);
    procedure SetPosition      (Value : Integer);
    procedure SetCancel        (Value : boolean);

  public // ----------------------------------------------- Public declarations
    procedure ProgressBy (Value : Integer);

    property StatusMessage : string           write SetStatusMessage;
    property MinValue      : Integer          write SetMinValue;
    property MaxValue      : Integer          write SetMaxValue;
    property Position      : Integer          write SetPosition;
    property CanCancel     : boolean          write SetCancel;
  end;

implementation

{$R *.DFM}

const
  NOBUTTONHEIGHT : smallint = 112;
  WITHBUTTONHEIGHT : smallint = 147;

//=============================================================================
// PROTECTED METHODS
//=============================================================================

//-----------------------------------------------------------------------------
// Procedure : SetCancel
//
// Purpose   : Show/Hide Cancel button.
//-----------------------------------------------------------------------------
procedure TProgressForm.SetCancel;
begin
  CancelButton.Visible := Value;
  if Value then
    Self.Height := WITHBUTTONHEIGHT
  else
    Self.Height := NOBUTTONHEIGHT;
end;

//=============================================================================
// PUBLIC METHODS
//=============================================================================

procedure TProgressForm.ProgressBy;
begin
  ProgressBar.StepBy (Value);
end;

//=============================================================================
// PROPERTY ACCESS METHODS
//=============================================================================

procedure TProgressForm.SetMinValue;
begin
  ProgressBar.Min := Value;
end;

procedure TProgressForm.SetMaxValue;
begin
  ProgressBar.Max := Value;
end;

procedure TProgressForm.SetPosition (Value : Integer);
begin
  ProgressBar.Position := Value;
end;

procedure TProgressForm.SetStatusMessage (Value : String);
begin
  StatusLabel.Caption := Value;
  StatusLabel.Refresh;
end;

//=============================================================================
// CREATE/DESTROY METHODS
//=============================================================================

//=============================================================================
// EVENT HANDLERS
//=============================================================================

end.
