{
Written By: DrBob
Modified By: Edward Flick (Directrix1@yahoo.com)
}

unit ListDataset;

interface

uses
  DB, Classes, SysUtils, Windows, Forms;

type
  TListDataSet = class (TDataSet)
  protected
    // record data and status
    FIsTableOpen: Boolean;
    FList: TList;
    FRecordSize: Integer; // actual data + housekeeping
    FCurrent: Integer;
    // dataset virtual methods
    function AllocRecordBuffer: PChar; override;
    procedure FreeRecordBuffer(var Buffer: PChar); override;
    procedure InternalInitRecord(Buffer: PChar); override;
    procedure GetBookmarkData(Buffer: PChar; Data: Pointer); override;
    function GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
    function GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
    function GetRecordSize: Word; override;
    procedure InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
    procedure InternalClose; override;
    procedure InternalDelete; override;
    procedure InternalFirst; override;
    procedure InternalGotoBookmark(Bookmark: Pointer); override;
    procedure InternalHandleException; override;
    procedure InternalLast; override;
    procedure InternalOpen; override;
    procedure InternalPost; override;
    procedure InternalInsert; override;
    procedure InternalSetToRecord(Buffer: PChar); override;
    function IsCursorOpen: Boolean; override;
    procedure SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;
    procedure SetBookmarkData(Buffer: PChar; Data: Pointer); override;
    function GetRecordCount: Integer; override;
    procedure SetRecNo(Value: Integer); override;
    function GetRecNo: Integer; override;
    // for specific subclasses
    procedure ReadListData; virtual; abstract;
  public
    constructor Create (Owner: TComponent); override;
    destructor Destroy; override;

  published
    // redeclared data set properties
    property Active;
    property BeforeOpen;
    property AfterOpen;
    property BeforeClose;
    property AfterClose;
    property BeforeInsert;
    property AfterInsert;
    property BeforeEdit;
    property AfterEdit;
    property BeforePost;
    property AfterPost;
    property BeforeCancel;
    property AfterCancel;
    property BeforeDelete;
    property AfterDelete;
    property BeforeScroll;
    property AfterScroll;
    property OnCalcFields;
    property OnDeleteError;
    property OnEditError;
    property OnFilterRecord;
    property OnNewRecord;
    property OnPostError;
  end;

type
  PRecInfo = ^TRecInfo;
  TRecInfo = record
    Index: Integer;
    Bookmark: Longint;
    BookmarkFlag: TBookmarkFlag;
  end;

implementation

function TListDataSet.AllocRecordBuffer: PChar;
begin
  Result := StrAlloc(fRecordSize);
end;

procedure TListDataSet.InternalInitRecord(Buffer: PChar);
begin
  FillChar(Buffer^, FRecordSize, 0);
end;

procedure TListDataSet.FreeRecordBuffer (var Buffer: PChar);
begin
  StrDispose(Buffer);
end;

procedure TListDataSet.GetBookmarkData(Buffer: PChar; Data: Pointer);
begin
  PInteger(Data)^ := PRecInfo(Buffer).Bookmark;
end;

function TListDataSet.GetBookmarkFlag(Buffer: PChar): TBookmarkFlag;
begin
  Result := PRecInfo(Buffer).BookmarkFlag;
end;

function TListDataSet.GetRecNo: Integer;
begin
  Result := FCurrent + 1;
end;

function TListDataSet.GetRecord(Buffer: PChar; GetMode: TGetMode;
  DoCheck: Boolean): TGetResult;
begin
  Result := grOK; // default
  case GetMode of
    gmNext: // move on
      if fCurrent < fList.Count - 1 then
        Inc (fCurrent)
      else
        Result := grEOF; // end of file
    gmPrior: // move back
      if fCurrent > 0 then
        Dec (fCurrent)
      else
        Result := grBOF; // begin of file
    gmCurrent: // check if empty
      if fCurrent >= fList.Count then
        Result := grEOF;
  end;

  if Result = grOK then // read the data
    with PRecInfo(Buffer)^ do
    begin
      Index := fCurrent;
      BookmarkFlag := bfCurrent;
      Bookmark := fCurrent;
    end;
end;

function TListDataSet.GetRecordCount: Integer;
begin
  Result := FList.Count;
end;

function TListDataSet.GetRecordSize: Word;
begin
  Result := 4; // actual data without house-keeping
end;

procedure TListDataSet.InternalAddRecord(Buffer: Pointer;
  Append: Boolean);
begin
  // todo: support adding items
end;

procedure TListDataSet.InternalClose;
begin
  // disconnet and destroy field objects
  BindFields (False);
  if DefaultFields then
    DestroyFields;
  // closed
  FIsTableOpen := False;
end;

procedure TListDataSet.InternalDelete;
begin
  // todo: support deleting
end;

procedure TListDataSet.InternalFirst;
begin
  FCurrent := -1;
end;

procedure TListDataSet.InternalGotoBookmark(Bookmark: Pointer);
begin
  if (Bookmark <> nil) then
    FCurrent := Integer (Bookmark);
end;

procedure TListDataSet.InternalHandleException;
begin
  Application.HandleException(Self);
end;

procedure TListDataSet.InternalInsert;
begin
  // todo: support deleting
end;

procedure TListDataSet.InternalLast;
begin
  FCurrent := FList.Count;
end;

procedure TListDataSet.InternalOpen;
begin
  // initialize field definitions and create fields
  InternalInitFieldDefs;
  if DefaultFields then
    CreateFields;
  BindFields (True);

  // read directory data
  ReadListData;

  // initialize
  FRecordSize := sizeof (TRecInfo);
  FCurrent := -1;
  BookmarkSize := sizeOf (Integer);
  FIsTableOpen := True;
end;

procedure TListDataSet.InternalPost;
begin

end;

procedure TListDataSet.InternalSetToRecord(Buffer: PChar);
begin
  FCurrent := PRecInfo(Buffer).Index;
end;

function TListDataSet.IsCursorOpen: Boolean;
begin
  Result := FIsTableOpen;
end;

procedure TListDataSet.SetBookmarkData(Buffer: PChar; Data: Pointer);
begin
  PRecInfo(Buffer).Bookmark := PInteger(Data)^;
end;

procedure TListDataSet.SetBookmarkFlag(Buffer: PChar;
  Value: TBookmarkFlag);
begin
  PRecInfo(Buffer).BookmarkFlag := Value;
end;

procedure TListDataSet.SetRecNo(Value: Integer);
begin
  if (Value < 0) or (Value > FList.Count) then
    raise Exception.Create ('SetRecNo: out of range');
  FCurrent := Value - 1;
end;

constructor TListDataSet.Create(Owner: TComponent);
begin
  inherited;
  FList := TList.Create;
end;

destructor TListDataSet.Destroy;
var
  j: integer;
begin
  inherited;
  if flist.count>0 then
    for j:=0 to FList.count -1 do
      TObject(FList[j]).free;
  FList.Free;
end;

end.
