{
This file Copyright 2000 (c) CDF, Inc.
Written By: Edward Flick (Directrix1@yahoo.com)
Use at your own risk!
}

unit DataMover;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, db, ExpressionEval;

//A Class to move data from one dataset into another, like BatchMove but works
//with any dataset and is only an appending class, also can be used to update a
//table from itself when Source and Destination point to the same object.
type
  TDataMover = class(TExpressionEval)
  protected
    { Protected declarations }
    FDestination: TDataset;
    FSrcExpr: TStrings;
    FDestFields: TStrings;
    FLastRecno: Integer;
    FIgnoreUnknownFieldFunction: Boolean;
    procedure setSrcExpr(ti: TStrings);
    procedure setDestFields(ti: TStrings);
    //Custom Functions
    function CFRecNo(ins: array of String): String;
    function CSrcRecno(ins: array of String): String;
    function CSrcReccount(ins: array of String): String;
    function CDstRecno(ins: array of String): String;
    function CDstReccount(ins: array of String): String;
  public
    { Public declarations }
    procedure transfer; virtual;
    constructor create(Owner: TComponent); override;
    destructor destroy; override;
    property LastRecno: Integer read FLastRecno;
  published
    { Published declarations }
    property Destination: TDataset read FDestination write FDestination;
    property SrcExpressions: TStrings read FSrcExpr write setSrcExpr;
    property DestFields: TStrings read FDestFields write setDestFields;
    property IgnoreUnkownFieldFunction: boolean read FIgnoreUnknownFieldFunction write FIgnoreUnknownFieldFunction;  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Data Access', [TDataMover]);
end;

//Transfer data from Source to Destination, Datasets must already be active
//and Destination should be modifiable
procedure TDataMover.Transfer;
var
  j: integer;
  tempCE: PCompiledExpr;
  dfs: array of TField;
  ses: array of PCompiledExpr;
begin
dfs:=nil;
ses:=nil;
if FSrcExpr.count<>FDestFields.count then   //Verify one-to-one mapping
  raise Exception.create('There must be a one-to-one mapping between SourceExpressions and DestinationFields');
for j:=0 to FSrcExpr.Count - 1 do
  if FSrcExpr[j]<>'' then
    if FDestination.FindField(FDestFields[j])<>nil then
      begin
      try
        tempCE:=compile(FSrcExpr[j]);
        setLength(dfs,Length(dfs)+1);
        setLength(ses,Length(ses)+1);
        dfs[High(dfs)]:=FDestination.FieldByName(FDestFields[j]);
        ses[High(ses)]:=tempCE;
      except
        on EUnknownFieldFunction do if not FIgnoreUnknownFieldFunction then raise;
        end;
      end;
FSource.First;
if FLastRecno<>0 then
  begin
  FLastRecno:=StrToInt(InputBox('Starting Point', 'Start on record #:', IntToStr(FLastRecno)));
  FSource.MoveBy(FLastRecno-1);
  Dec(FLastRecno);
  end;
while not source.eof do                   //Iterate through all records in Source
  begin
  inc(FLastRecno);
  try
    if FSource<>FDestination then         //check if this is an update or import
      FDestination.Append                 //and append the compiled expressions listed above
    else
      FDestination.Edit;                  //or just update from the compiled expressions listed above
    for j:=0 to High(dfs) do
      try
        dfs[j].asString:=evaluateCompiled(ses[j]);
      except
        on e: Exception do
          raise Exception.Create('Error assigning to field '''+dfs[j].FieldName+'''.'+#13#10+'Error Message:'+#13#10+e.Message);
        end;
    FDestination.Post;
  except
    try
      FDestination.Cancel;
    except
      end;
    raise;
    end;
  FSource.Next;                           //Move on
  end;
FLastRecno:=0;
end;

constructor TDataMover.create(Owner: TComponent);
begin
inherited create(owner);
FSrcExpr:=TStringList.Create();
FDestFields:=TStringList.Create();
FLastRecNo:=0;
RegisterFunction('CUR.RECNO',CFRecno);
registerFunction('SRC.RECNO',CSrcRecno);
registerFunction('SRC.RECCOUNT',CSrcReccount);
registerFunction('DST.RECNO',CDstRecno);
registerFunction('DST.RECCOUNT',CDstReccount);
registerFunction('RECCOUNT',CDstReccount);
end;

destructor TDataMover.destroy;
begin
FSrcExpr.free;
FDestFields.free;
inherited destroy;
end;

procedure TDataMover.setSrcExpr(ti: TStrings);
begin
FSrcExpr.Assign(ti);
end;

procedure TDataMover.setDestFields(ti: TStrings);
begin
FDestFields.Assign(ti);
end;

//Custom Functions
function TDataMover.CFRecNo(ins: array of String): String;
begin
  result:=IntToStr(FLastRecno);
end;

//Custom Table Functions
function TDataMover.CSrcRecno(ins: array of String): String;
begin
  result:=inttostr(FSource.RecNo);
end;

function TDataMover.CSrcReccount(ins: array of String): String;
begin
  result:=inttostr(FSource.RecordCount);
end;

function TDataMover.CDstRecno(ins: array of String): String;
begin
  result:=inttostr(FDestination.RecNo);
end;

function TDataMover.CDstReccount(ins: array of String): String;
begin
  result:=inttostr(FDestination.RecordCount);
end;

end.
