unit wzWordMerge;
// wrapper for WOrdmail Merge Wizard
// and TmsWordMerge.
// The Wizard only has one property- TDatasource that supplies the data.
// simple!


interface
uses     wzMergeForm, msWordMerge,
         Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
         DB, DBTables, comObj;

type
  TwzWordMerge = class(TComponent)

  private
    { Private declarations }
    fCaption : String;
    fDataSource: TDataSource;
    fDataFile: String;

  protected
    { Protected declarations }

  public
    { Public declarations }
    Function Execute: Boolean;
    Constructor Create(Aowner:TComponent); Override;

  published
    { Published declarations }
    Property Caption : String Read fCaption Write fCaption;
    Property DataSource: TDataSource Read fDataSource Write fDataSource;
    Property OutputFile : String Read fdatafile    Write fdatafile;


  end;

 //procedure Register;

implementation


Function TwzWordMerge.Execute: Boolean;
Var t : TfrmMergeWizard ;

Begin
     t := nil;
     result := false;
     try
        t := TfrmMergeWizard.create(application);

        // set output file to user preference
        if length(fdataFile) > 0 then
          t.msWordMerge1.OutPutFile := fdataFile
        else
          t.msWordMerge1.OutPutFile := t.msWordMerge1.WordDocumentPath + '\MergeData.txt';
         // set datasource
          t.msWordMerge1.DataSource := fDataSource;
        // set dialog caption
        if length(fcaption) > 0 then
         t.Caption := fcaption;

        t.showModal;
        result := (t.ModalResult = mrOK);

     finally
        t.free
     end;


end;
Constructor TwzWordMerge.Create(Aowner:TComponent);

begin
     inherited Create(Aowner);


end;

end.
