unit wzMergeForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, msWordMerge, Buttons, DB;


type
  TfrmMergeWizard = class(TForm)
    Label1: TLabel;
    fMergeChoice: TRadioGroup;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    msWordMerge1: TmsWordMerge;
    chkCloseWord: TCheckBox;
    chkPromptSave: TCheckBox;

    procedure btnOKClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure fMergeChoiceClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure chkCloseWordClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure chkPromptSaveClick(Sender: TObject);

  private
    { Private declarations }


  public
    { Public declarations }


  end;

var
  frmMergeWizard: TfrmMergeWizard;

implementation

uses ffsettings;

{$R *.DFM}

procedure TfrmMergeWizard.btnOKClick(Sender: TObject);
var ok : Boolean;



begin
   ok := false;
   try

    // set the appropriate document paths and files
     Case fMergeChoice.ItemIndex of
     0,1,2 : begin
             ok := msWordMerge1.SelectWordDocumentFile ;

              case fMergeChoice.ItemIndex of
              0 : msWordMerge1.MergeOption := fmsNoMerge ;
              1 : msWordMerge1.MergeOption := fmsPreview ;
              2 : msWordMerge1.MergeOption := fmsPrint ;
             end;
             end;
     3     :begin
             ok := msWordMerge1.selectWordTemplateFile ;
             if ok then
             msWordMerge1.MergeOption := fmsNew  ;
             end;
     4     : begin
             if  msWordMerge1.selectMergeDataFile  then
                 begin
                   msWordMerge1.MergeOption := fmsNoMerge ;
                   msWordMerge1.WordMergeDocument := '';
                   msWordMerge1.execute;
                 end;
              abort;
             end;
     end;
    // don't proceed if user aborted
   if not(oK) then abort;
    with mswordMerge1 do begin
      execute;
    end;

   finally

   end;

end;

procedure TfrmMergeWizard.btnCancelClick(Sender: TObject);
begin
     // click to close
end;

procedure TfrmMergeWizard.fMergeChoiceClick(Sender: TObject);
begin
     // make your choice

      msWordMerge1.OutPutFile :=
           msWordMerge1.WordDocumentPath + '\MergeData.txt';




end;

procedure TfrmMergeWizard.FormCreate(Sender: TObject);
begin
      msWordMerge1.OutPutFile :=
           msWordMerge1.WordDocumentPath + '\MergeData.txt';

     chkCloseWord.Checked :=
      (GetStrSetting ('msWordMerge','Wizard','CloseWord','False') = 'True') ;

     msWordMerge1.CloseWord := chkCloseWord.Checked;

      chkPromptSave.Checked :=
      (GetStrSetting ('msWordMerge','Wizard','PromptSave','False') = 'True') ;

     msWordMerge1.PromptSave  := chkPromptSave.Checked;

end;

procedure TfrmMergeWizard.chkCloseWordClick(Sender: TObject);
var flg : String;
begin
 if chkCloseWord.Checked then
          flg := 'True'
     else
          flg := 'False';

    SaveStrSetting( 'msWordMerge','Wizard','CloseWord', flg);
    chkPromptSave.Enabled := chkCloseWord.Checked;
    msWordMerge1.CloseWord := chkCloseWord.Checked;
    msWordMerge1.PromptSave := chkPromptSave.Checked ;

end;

procedure TfrmMergeWizard.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin


{     if chkCloseWord.checked then
        begin
        // close Word
          msWordMerge1.CloseWordObject ;
        end;
 }
end;

procedure TfrmMergeWizard.chkPromptSaveClick(Sender: TObject);
var flg : String;
begin

 if chkPromptSave.Checked then
          flg := 'True'
     else
          flg := 'False';

    SaveStrSetting( 'msWordMerge','Wizard','PromptSave', flg);

    msWordMerge1.PromptSave := chkPromptSave.Checked ;


end;

end.
