{*****************************************************************************
 *
 *  Unit1.pas - Component Grid Demo
 *
 *  Copyright (c) 2000 Diego Amicabile
 *
 *  Author:     Diego Amicabile
 *  E-mail:     diegoami@yahoo.it
 *  Homepage:   http://www.geocities.com/diegoami
 *
 *  This component is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation;
 *
 *  This component is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this component; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 *****************************************************************************}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, DAComponentGrid;

type
  TForm1 = class(TForm)
    DAComponentGrid1: TDAComponentGrid;
    Splitter1: TSplitter;
    Panel1: TPanel;
    ComponentGrou: TRadioGroup;
    ButtonRadioButton: TRadioButton;
    ShapeRadioButton: TRadioButton;
    XEdit: TEdit;
    YEdit: TEdit;
    XLabel: TLabel;
    YLabel: TLabel;
    ComboBox: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    XRatioEdit: TEdit;
    YRatioEdit: TEdit;
    CoordLabel: TLabel;

    procedure FormShow(Sender: TObject);
    procedure ShapeRadioButtonClick(Sender: TObject);
    procedure ButtonRadioButtonClick(Sender: TObject);
    procedure ComboBoxChange(Sender: TObject);
    procedure EditChange(Sender: TObject);
    procedure DAComponentGrid1PaintingControl(Sender: TObject; X,
      Y: Integer; Control: TControl);
    procedure DAComponentGrid1CreatingControl(Sender: TObject; X,
      Y: Integer; var Control: TControl);
  private
    procedure ShowCoords(Sender : TObject);
    procedure SetShape(Sh : TShapeType);
    procedure ShapeMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ButtonClick(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.ShowCoords(Sender : TObject);
var X, Y : Integer;
begin
  DAComponentGrid1.GetCoordsForControl(Sender As TControl,X,Y);
  CoordLabel.Caption := '('+IntToStr(X)+','+IntToStr(Y)+')'
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Randomize;
  DAComponentGrid1.ChildClassType := TButton;
end;

procedure TForm1.ShapeRadioButtonClick(Sender: TObject);
begin
  ComboBox.Visible := True;
  DAComponentGrid1.ChildClassType := TShape;
  SetShape(TShapeType(Combobox.ItemIndex));
end;

procedure TForm1.ButtonRadioButtonClick(Sender: TObject);
begin
  DAComponentGrid1.ChildClassType := TButton;
  ComboBox.Visible := False;
end;

procedure TForm1.SetShape(Sh : TShapeType);
var i,j : integer;
begin
  with DaComponentGrid1 do
    for i := 1 to XCompNumber do
      for j := 1 to YCompNumber do
        (ComponentAt[i,j] As TShape).Shape := Sh;
end;

procedure TForm1.ComboBoxChange(Sender: TObject);
begin
  SetShape(TShapeType(Combobox.ItemIndex));
end;

procedure TForm1.EditChange(Sender: TObject);
var 
    TXT : String;
begin
  TXT := (Sender as TEdit).Text;
  if Length(TXT) > 0 then
  try
    with DAComponentGrid1 do
      if Sender = YEdit then
        YCompNumber := StrToInt(TXT)
      else if Sender = XEdit then
        XCompNumber := StrToInt(TXT)
      else if Sender = XRAtioEdit then
        XRatio := StrToInt(TXT)/100
      else if Sender = YRAtioEdit then
        YRatio := StrToInt(TXT)/100;

  except on EConvertError do end;

end;

function RandomString : String;
begin
  result := '';
  while (Random(8) <> 4)  and (Length(Result) < 15) do
    result := result + Chr(Ord('A')+Random(Ord('Z')-Ord('A')))
end;


procedure TForm1.DAComponentGrid1PaintingControl(Sender: TObject; X,
  Y: Integer; Control: TControl);
begin
  if COntrol is TShape then
    (Control As TShape).Brush.Color := Random($02FFFFFF)
  else if COntrol is TButton then
    (Control As TButton).Caption := RandomString;
end;

procedure TForm1.ShapeMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  (Sender As TShape).Brush.Color :=Random($02FFFFFF);
  ShowCoords(Sender);
end;

procedure TForm1.DAComponentGrid1CreatingControl(Sender: TObject; X,
  Y: Integer; var Control: TControl);
begin
 if Control is TShape then
   (Control As TShape).OnMouseDown := ShapeMouseDown
 else if Control is TButton then
   (Control As TButton).OnClick := ButtonClick
end;

procedure TForm1.ButtonClick(Sender: TObject);
begin
 if Sender is TButton then
   (Sender As TButton).Caption := RandomString;
 ShowCoords(Sender);
end;

end.
