unit cvtodate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TConvertToDate = class(TComponent)
  private
    { Private declarations }
    y1:word;
    m1:word;
    d1:word;
    Function DaysInMonth(y,m:word):word;
    Function PreviousDays(y,m:word):word;
    Function Ymd_To_Date:tdatetime;
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    property Year : Word read y1 write y1;
    property Month : Word read m1 write m1;
    property DayOfMonth : Word read d1 write d1;
    property Date:TDateTime read ymd_to_date;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Freeware', [TConvertToDate]);
end;

function TConvertToDate.DaysInMonth(y,m:word):word;
var tmp:word;
Begin
     tmp:=0;
     case m of
     1,3,5,7,8,10,12: tmp:=31;
     4,6,9,11: tmp:=30;
     2: Begin
           if (y mod 4)>1 then tmp:=28 else tmp:=29;
        End;
     end;
result:=tmp;
End;

Function TConvertToDate.PreviousDays(y,m:word):word;
var cik,tmp:word;
Begin
   tmp:=0;
   for cik:=1 to m-1 do
   Begin
       tmp:=tmp+DaysInMonth(y,cik);
   End;
   result:=tmp;
End;

function TConvertToDate.ymd_to_date:tdatetime;
var a:tdatetime;
Begin
if (m1>=1) and (m1<=12) and (d1>=1) and (d1<=PreviousDays(y1,m1)) and (y1>=1900) then
begin
     a:=(y1-1900)*365+trunc((y1-1899)*0.25);
     a:=a+PreviousDays(y1,m1);
     a:=a+d1;
     result:=a;
end
else result:=0;

End;


end.
