unit CRCdlg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, ComCtrls, StdCtrls,
  Buttons, CRCfind, ExtCtrls, ExptIntf, CRCcomp ;

type
  TCRCcompDlg = class(TForm)
    lblLabel: TLabel;
    lblFile: TLabel;
    staInfo: TStatusBar;
    Panel1: TPanel;
    cmdUpdate: TBitBtn;
    cmdClose: TBitBtn;
    cmdStop: TBitBtn;
    cmdBrowse: TSpeedButton;
    dlgOpen: TOpenDialog;
    procedure cmdUpdateClick(Sender: TObject);
    procedure cmdStopClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure cmdBrowseClick(Sender: TObject);
  private
    { Private declarations }
    FComponent:TComponent;
    FFileName :string;
    FWorking  :boolean;
    FCRCFinder :TCRCFinder;
    procedure CMCRC(var M:TMessage);message CM_CRC;
  public
    { Public declarations }
    constructor CreateWithInfo(AComponent:TComponent);
  end;

implementation
{$R *.DFM}
//--------------------------------------------------
//--------------------------------------------------
constructor TCRCcompDlg.CreateWithInfo(AComponent:TComponent);
var
  S:string;
begin
  inherited Create(nil);
  FComponent:=AComponent;
  Caption:=AComponent.Owner.Name+'.'+AComponent.Name+'-'+Caption;
  S:=ToolServices.GetProjectName;
  FFileName:=ChangeFileExt(S,'.exe');
  lblFile.Caption:=FFileName;
  lblFile.Hint:=FFileName;
  FWorking:=False;
end; { constructor TCRCcompDlg.CreateWithInfo }
//--------------------------------------------------
procedure TCRCcompDlg.CMCRC(var M:TMessage);
var
  S:string;
begin
  case M.LParam of
    crcMarkNotFound:S:='Error: the CRCmark not found. CRC not written.';
    crcTwiceFound  :S:='Error: the CRCmark found twice. CRC not written.';
    crcNoFileAccess:S:='Error: can not write to the file.';
    crcProcessAbort:S:='Operation aborted. CRC not written';
    crcUnknownError:S:='Unknown error. CRC not written.';
    else S:='Done!   CRC='+IntToStr(M.LParam);
  end;
  staInfo.SimpleText:=S;
  cmdUpdate.BringToFront;
  FWorking:=False;
end; { procedure TCRCcompDlg.CMProgress }
//--------------------------------------------------
procedure TCRCcompDlg.cmdUpdateClick(Sender: TObject);
var
  i:Integer;
  CRCdata:TCRCdata;
begin
  for i:=1 to High(CRCdata.Mark)do
    CRCdata.Mark[i]:=(FComponent as TrasCRC).CRCmark[i];
  FCRCFinder:=TCRCFinder.CreateAndOperate(FFileName,CRCdata,Handle,crcWrite);
  FWorking:=True;
  staInfo.SimpleText:='Working ...';
  cmdStop.BringToFront;
end; { procedure TCRCcompDlg.cmdUpdateClick }
//--------------------------------------------------
procedure TCRCcompDlg.cmdStopClick(Sender: TObject);
begin
  FCRCFinder.Terminate;
end; { procedure TCRCcompDlg.cmdStopClick }
//--------------------------------------------------
procedure TCRCcompDlg.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  try
    FCRCFinder.Terminate;
  except
    //do nothing
  end;
  Sleep(10);
  CanClose:=True;
end; { procedure TCRCcompDlg.FormCloseQuery }
//--------------------------------------------------
procedure TCRCcompDlg.cmdBrowseClick(Sender: TObject);
begin
  if dlgOpen.Execute then
  begin
    FFileName:=dlgOpen.FileName;
    lblFile.Caption:=FFileName;
    lblFile.Hint:=FFileName;
  end;
end; { procedure TCRCcompDlg.cmdBrowseClick }
//--------------------------------------------------
end.
