unit CRCcomp;

interface
uses
  Windows, Messages, SysUtils,  Classes, Graphics,
  Controls, Forms, Dialogs, ExtCtrls, CRCfind;
//--------------------------------------------------
//--------------------------------------------------
type
  TrasCRC = class(TCustomControl)
  private
    { Private declarations }
    FColor     : TColor;
    FAutoCheck : Boolean;
    FOnCRCdone : TNotifyEvent;
    FCRCresult : Integer;
    FCRCFinder : TCRCFinder;
  protected
    { Protected declarations }
    function  GetCRCmark:Shortstring;
    procedure Loaded;override;
  public
    { Public declarations }
    procedure CheckCRC;
    constructor Create(AOWner:TComponent);override;
    destructor Destroy;override;
    procedure Paint;override;
    procedure DoneCRCcheck(var M:TMessage);message CM_CRC;
    property CRCcolor:TColor read FColor write FColor default clMaroon;
    property CRCmark:Shortstring read GetCRCmark ;
    property CRCcode:Integer read FCRCresult;
  published
    { Published declarations }
    property AutoCheck :Boolean read FAutoCheck write FAutoCheck default True;
    property OnCRCcheck : TNotifyEvent read FOnCRCdone write FOnCRCdone;
    property Visible;
  end;

const
  // use a part of GUID:['{46FC13F1-7CA0-11D3-B33C-000000000000}']
  // for the mark or any other unique value of 14 bytes
  CRCdata:TCRCdata=(mark:'{46FC13F1-7CA0';code:0);

implementation
uses CRCedit;
//--------------------------------------------------
//--------------------------------------------------
constructor TrasCRC.Create(AOWner:TComponent);
begin
  inherited Create(AOwner);
  Width:=64;Height:=24;
  FAutoCheck:=True;
  FColor:=clMaroon;
  if (csDesigning in ComponentState) then
    ShowMessage('Please do not forget to update CRC.');
end; { constructor TrasCRCcomp.Create }
//--------------------------------------------------
procedure TrasCRC.Loaded;
begin
  inherited Loaded;
  if not (csDesigning in ComponentState) then
    if FAutoCheck then CheckCRC;
end; { procedure TrasCRCcomp.Loaded }
//--------------------------------------------------
procedure TrasCRC.Paint;
var
  LRect:TRect;
  S:string;
begin
  LRect:=ClientRect;
  With Canvas do
  try
    Lock;
    Font.Color:=clYellow;
    Brush.Color:=FColor;
    FillRect(ClientRect);
    if csDesigning in ComponentState then
      DrawText(Handle,PChar('CRC'),-1,LRect,DT_SINGLELINE or DT_CENTER or DT_VCENTER)
    else begin
      S:=IntToStr(FCRCresult);
      DrawText(Handle,PChar(S),-1,LRect,DT_SINGLELINE or DT_CENTER or DT_VCENTER);
    end;
  finally
    Unlock;
  end;
  Frame3D(Canvas,LRect,clWhite,clBlack,1);
end; { procedure TrasCRCcomp.Paint }
//--------------------------------------------------
procedure TrasCRC.DoneCRCcheck;
begin
  if (M.Msg=CM_CRC)and(M.WParam=36)then
  begin
    FCRCResult:=M.LParam;
    if FCRCResult>=0 then
      FColor:=clGreen
    else
      FColor:=clMaroon;
    Paint();
    If Assigned(FOnCRCdone)then
      FOnCRCdone(Self);
  end;
end; { procedure TrasCRCcomp.CMCRC }
//--------------------------------------------------
function  TrasCRC.GetCRCmark:Shortstring;
begin
  Result:=CRCdata.Mark;
end; { function  TrasCRCcomp.GetCRCmark }
//--------------------------------------------------
procedure TrasCRC.CheckCRC;
begin
  FCRCFinder:=TCRCFinder.CreateAndOperate(Application.ExeName,CRCdata,Handle,crcRead)
end; { procedure TrasCRCcomp.CheckCRC }
//--------------------------------------------------
destructor TrasCRC.Destroy;
begin
  if not (csDesigning in ComponentState) then
    if FCRCFinder<>nil then FCRCFinder.Terminate;
  Sleep(10);
  inherited Destroy;
end; { destructor Destroy }
//--------------------------------------------------
end.
 