unit cpDrawGrid;
{
	16-01-1998
  Freeware component for Delphi 3 by Christian Poisson.
  Send any comments to christian.poisson@hol.fr.

	TDrawGrid with 4 new events:
  	OnMouseEnter (over the grid)
    OnMouseLeave (the grid)
    OnMouseEnter (over a cell)
    OnMouseLeave (a cell)
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids;

type
  TMouseCellEvent = procedure (Sender:TObject; Col,Row:integer) of object;
  TcpDrawGrid = class(TDrawGrid)
  private
    { Dclarations prives }
    Fcol,Frow:integer;
		procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
  protected
    { Dclarations protges }
  	fonmouseleavecell:TMouseCellEvent;
		fonmouseentercell:TMouseCellEvent;
  	fonmouseleave:TMouseCellEvent;
		fonmouseenter:TMouseCellEvent;
  public
    { Dclarations publiques }
    procedure CMMouseEnter(var message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var message: TMessage); message CM_MOUSELEAVE;
  published
    { Dclarations publies }
    property OnMouseEnterCell:TMouseCellEvent read fonmouseentercell write fonmouseentercell;
    property OnMouseLeaveCell:TMouseCellEvent read fonmouseleavecell write fonmouseleavecell;
    property OnMouseEnter:TMouseCellEvent read fonmouseenter write fonmouseenter;
    property OnMouseLeave:TMouseCellEvent read fonmouseleave write fonmouseleave;
  end;

procedure Register;

implementation

procedure TcpDrawGrid.CMMouseEnter(var message: TMessage);
begin
	Fcol:=-1;
  Frow:=-1;
end;

procedure TcpDrawGrid.CMMouseLeave(var message: TMessage);
begin
 	if Fcol<>-1 then
  	begin
			if assigned(fonmouseleavecell) then
 				fonmouseleavecell(self,Fcol,Frow);
			if assigned(fonmouseleave) then
 				fonmouseleave(self,Fcol,Frow);
    end;
end;

procedure TcpDrawGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
var
	newcol,newrow:integer;
begin
	MouseToCell(x,y,newcol,newrow);
  if ((newcol<>Fcol) or (newrow<>Frow))
  		and (newcol>=0) and (newcol<colcount)
      and (newrow>=0) and (newrow<rowcount) then
  	begin
    	if Fcol<>-1 then
  			begin
        	if assigned(fonmouseleavecell) then
    				fonmouseleavecell(self,Fcol,Frow);
        end
      else
 				if assigned(fonmouseenter) then
    				fonmouseenter(self,Fcol,Frow);
    	Fcol:=newcol;
      Frow:=newrow;
  		if assigned(fonmouseentercell) then
    		fonmouseentercell(self,Fcol,Frow);
    end;
  inherited;
end;

procedure Register;
begin
  RegisterComponents('Standard', [TcpDrawGrid]);
end;

end.
