unit cpCoord;
{
	v 1.0 : 30-11-1997
  Freeware component for Delphi 3 (D2 ?) by Christian Poisson.
  Send any comments to christian.poisson@hol.fr.

  Color : only in the corners.
  ColorCoord : backcolor if ThumbStyle is csCoordinates.
  ColorFlatButton : Color of the buttons only if the Flat property is True (otherwise buttons' color is the default one).
  ColorZone : in the coordinates zone.
  CoordFormat : the text (using the Font property) that appears if ThumbStyle is csCoordinates.
  						- [x] means XCoordinate
              - [y] means YCoordinate
  Xmax, Xmin, XStep, Ymax, Ymin, YStep :
  	(Xmin,Ymin) correspond to the left-top corner of te coordinates zone and
    (Xmax,Ymax) to the bottom-right corner.
    XStep is the difference between 2 consecutives Xcoordinates.
    if Xmax<Xmin then XStep<0.

  3 new events : OnCoordChange, OnXCoordChange, OnYCoordChange.
}

interface

{$R cpCoord.RES}
{$R cpCoord.DCR}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  ExtCtrls, Buttons;

const
  CM_CHANGECOORDX = WM_USER + 2000;
  CM_CHANGECOORDY = WM_USER + 2001;
  CM_CHANGECOORD = WM_USER + 2002;
type
  TcpSpeedButton = class(TSpeedButton)  // based on TTimeSpeedButton
  private
    FRepeatTimer: TTimer;
    FInitRepeatPause,FRepeatPause: integer;
    procedure TimerExpired(Sender: TObject);
  protected
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

  TCoordEvent = procedure (Sender:TObject; x,y:integer) of object;
  TCroixstyle=(csCross, csCircle, csDiamond, csSquare, csCoordinates);
  TcpCoord = class(TCustompanel)
  private
    { Dclarations prives }
    FCouleur,FCouleurcoord,Fcouleurflat :Tcolor;
    Fxmin,Fxmax,Fymin,Fymax:integer;
    Fcoordx:integer;
    Fcoordy:integer;
    Flargeurcase,Fhauteurcase:integer;
    Fcroixstyle:Tcroixstyle;
    FCroix:Tbitmap;
    FSeparateur:string;
    Fxstep,Fystep:integer;
    FLeftButton,FRightbutton,FUpbutton,FDownbutton:Tcpspeedbutton;
    function CreateButton(nom : PChar): TcpSpeedButton;
   	procedure WMsize(var Message: TWMsize); message WM_SIZE;
    procedure SetCouleur (Value: TColor);
    procedure SetCouleurcoord (Value: TColor);
    procedure SetCouleurflat (Value: TColor);
    procedure Setcoordx (Value: integer);
    procedure Setcoordy (Value: integer);
    procedure Setxmin (value: integer);
    procedure Setymin (value: integer);
    procedure Setxmax (value: integer);
    procedure Setymax (value: integer);
    procedure Setxstep(value:integer);
    procedure Setystep(value:integer);
    procedure Setseparateur (value:string);
    procedure Setcroixstyle (value:Tcroixstyle);
    procedure Setflat (value: boolean);
    function Getflat : boolean;
    procedure Setinitialpause(value:integer);
		function Getinitialpause: integer;
    procedure Setrepeatpause(value:integer);
		function Getrepeatpause: integer;
		procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
		procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
		procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure calculwidth;
    procedure calculheight;
		procedure calculbutton;
    procedure couleurcroix;
		procedure nouvellescoordonnes(x,y:integer);
    procedure BtnClick(Sender: TObject);
  protected
    { Dclarations protges }
    f_on_coord_change:TCoordEvent;
    f_on_coordx_change:TCoordEvent;
    f_on_coordy_change:TCoordEvent;
    procedure Paint; override;
 		procedure CMChangeCoordx(var Message: TMessage); message CM_CHANGECOORDX;
 		procedure CMChangeCoordy(var Message: TMessage); message CM_CHANGECOORDY;
  public
    { Dclarations publiques }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Dclarations publies }
    property InitialPause: integer read Getinitialpause write Setinitialpause;
    property RepeatPause: integer read Getrepeatpause write SetRepeatpause;
    property Flat: boolean read Getflat write Setflat default false;
    property ColorZone: Tcolor read FCouleur write SetCouleur default clwhite;
    property ColorCoord: Tcolor read FCouleurcoord write SetCouleurcoord default clInfoBk;
    property ColorFlatButton : Tcolor read FCouleurflat write SetCouleurflat default clSilver;
		property ThumbStyle: Tcroixstyle read Fcroixstyle write Setcroixstyle default csCross;
    Property Xmin: integer read Fxmin write Setxmin default 1;
    Property Xmax: integer read Fxmax write Setxmax default 100;
    Property Ymin: integer read Fymin write Setymin default 1;
    Property Ymax: integer read Fymax write Setymax default 100;
    Property XStep: integer read Fxstep write Setxstep default 1;
    Property YStep: integer read Fystep write Setystep default 1;
    property XCoordinate: integer read Fcoordx write Setcoordx default 50;
    property YCoordinate: integer read Fcoordy write Setcoordy default 50;
    property CoordFormat: string read FSeparateur write Setseparateur;
    property OnCoordChange:TCoordEvent read f_on_coord_change write f_on_coord_change;
    property OnXCoordChange:TCoordEvent read f_on_coordx_change write f_on_coordx_change;
    property OnYCoordChange:TCoordEvent read f_on_coordy_change write f_on_coordy_change;
    property Color;
    property Showhint;
    property ParentShowhint;
    property BorderStyle;
    property Ctl3D;
    property FullRepaint;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ParentColor;
    property ParentCtl3D;
    property PopUpMenu;
    property TabOrder;
    property TabStop;
    property Tag;
    property Visible;
    property Font;
    property ParentFont;
    property OnResize;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
    property OnKeyDown;
    property OnKeyUp;
    property OnKeyPress;
  end;

procedure Register;

implementation

constructor TcpSpeedButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FInitrepeatPause:=400;
  FRepeatpause:=100;
end;

destructor TcpSpeedButton.Destroy;
begin
  FRepeatTimer.Free;
  inherited Destroy;
end;

procedure TcpSpeedButton.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  inherited MouseDown (Button, Shift, X, Y);
  if FRepeatTimer = nil then
    FRepeatTimer := TTimer.Create(Self);
  FRepeatTimer.OnTimer:=TimerExpired;
  FRepeatTimer.Interval:=FInitRepeatPause;
  FRepeatTimer.Enabled:=True;
end;

procedure TcpSpeedButton.MouseUp(Button: TMouseButton; Shift: TShiftState;
                                  X, Y: Integer);
begin
  inherited MouseUp (Button, Shift, X, Y);
  if FRepeatTimer <> nil then
    FRepeatTimer.Enabled:=False;
end;

procedure TcpSpeedButton.TimerExpired(Sender: TObject);
begin
  FRepeatTimer.Interval:=FRepeatPause;
  if (FState = bsDown) and MouseCapture then
    try
      Click;
    except
      FRepeatTimer.Enabled := False;
      raise;
    end;
end;

constructor TcpCoord.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  width:=200;
	height:=200;
	Fxmin:=1;
	Fxmax:=100;
	Fymin:=1;
	Fymax:=100;
	Fcoordx:=50;
	Fcoordy:=50;
  Fxstep:=1;
  Fystep:=1;
  FCouleur := clteal;
	Fcouleurflat:=$00C0C8D0;
  FSeparateur:='[x][y]';
	Flargeurcase:=1;
	Fhauteurcase:=1;
	Fcroixstyle:=csCoordinates;
  FCouleurcoord:=clInfoBk;
  FCroix:=Tbitmap.Create;
  controlstyle:=controlstyle-[csAcceptsControls];
  FLeftbutton:=CreateButton('GAUCHE');
  FRightbutton:=CreateButton('DROITE');
  FUpbutton:=CreateButton('HAUT');
  FDownbutton:=CreateButton('BAS');
end;

destructor TcpCoord.Destroy;
begin
	FCroix.free;
  inherited Destroy;
end;

function TcpCoord.CreateButton(nom : PChar): TcpSpeedButton;
begin
  Result:=TcpSpeedButton.Create(Self);
  Result.OnClick:=BtnClick;
  Result.Visible:=True;
  Result.Enabled:=True;
  Result.Parent:=Self;
  Result.Glyph.Handle:=Loadbitmap(HInstance,nom);
  Result.Flat:=true;
end;

procedure TcpCoord.WMsize(var Message: TWMsize);
begin
	calculwidth;
	calculheight;
  inherited;
end;

procedure TcpCoord.calculwidth;
begin
	Flargeurcase:=round((clientWidth-30)/(((Fxmax-Fxmin) div Fxstep)+1));
  If Flargeurcase<=0 then Flargeurcase:=1;
	clientwidth:=Flargeurcase*(((Fxmax-Fxmin) div Fxstep)+1)+30;
	calculbutton;
end;

procedure TcpCoord.calculheight;
begin
	Fhauteurcase:=round((clientheight-30)/(((Fymax-Fymin) div Fystep)+1));
 	if Fhauteurcase<=0 then Fhauteurcase:=1;
	clientheight:=Fhauteurcase*(((Fymax-Fymin) div Fystep)+1)+30;
	calculbutton;
end;

procedure TcpCoord.calculbutton;
begin
  FLeftButton.SetBounds(0,15,15,clientheight-30);
  FRightButton.SetBounds(clientwidth-15,15,15,clientheight-30);
  FUpButton.SetBounds(15,0,clientwidth-30,15);
  FDownButton.SetBounds(15,clientheight-15,clientwidth-30,15);
end;

procedure TcpCoord.CMChangeCoordx(var Message: TMessage);
begin
  if assigned(f_on_coordx_change) then
    f_on_coordx_change(self,message.wparam,message.lparam);
  if assigned(f_on_coord_change) then
    f_on_coord_change(self,message.wparam,message.lparam);
end;

procedure TcpCoord.CMChangeCoordy(var Message: TMessage);
begin
  if assigned(f_on_coordy_change) then
    f_on_coordy_change(self,message.wparam,message.lparam);
  if assigned(f_on_coord_change) then
    f_on_coord_change(self,message.wparam,message.lparam);
end;

procedure TcpCoord.Setflat(value: boolean);
begin
	if value <> FLeftbutton.Flat then
  	begin
    	FLeftbutton.Flat:=value;
    	FRightbutton.Flat:=value;
    	FUpbutton.Flat:=value;
    	FDownbutton.Flat:=value;
    end;
end;

function TcpCoord.Getflat: boolean;
begin
	result:=FLeftbutton.Flat;
end;

procedure TcpCoord.Setinitialpause(value:integer);
begin
	if (value<>FLeftbutton.FInitRepeatPause) and (value>0) then
  	begin
    	FLeftbutton.FInitRepeatPause:=value;
    	FRightbutton.FInitRepeatPause:=value;
    	FUpbutton.FInitRepeatPause:=value;
    	FDownbutton.FInitRepeatPause:=value;
    end;
end;

function TcpCoord.Getinitialpause: integer;
begin
	result:=FLeftbutton.FInitRepeatPause;
end;

procedure TcpCoord.Setrepeatpause(value:integer);
begin
	if (value<>FLeftbutton.FRepeatPause) and (value>0) then
  	begin
    	FLeftbutton.FRepeatPause:=value;
    	FRightbutton.FRepeatPause:=value;
    	FUpbutton.FRepeatPause:=value;
    	FDownbutton.FRepeatPause:=value;
    end;
end;

function TcpCoord.Getrepeatpause: integer;
begin
	result:=FLeftbutton.FRepeatPause;
end;

procedure TcpCoord.SetCouleur(Value: TColor);
begin
  if Value <> FCouleur then
  begin
    FCouleur := Value;
		couleurcroix;
		refresh;
	end;
end;

procedure TcpCoord.SetCouleurcoord(Value: TColor);
begin
  if Value <> FCouleurcoord then
  begin
    FCouleurcoord:=Value;
		refresh;
	end;
end;

procedure TcpCoord.SetCouleurflat (Value: TColor);
begin
  if Value <> FCouleurflat then
  begin
    FCouleurflat:=Value;
		refresh;
	end;
end;

procedure TcpCoord.SetSeparateur(Value: string);
begin
  if Value <> FSeparateur then
  begin
    FSeparateur := Value;
		refresh;
	end;
end;

procedure TcpCoord.couleurcroix;
var
	bm:Tbitmap;
begin
  case Fcroixstyle of
	  csCross: FCroix.Handle:=Loadbitmap(HInstance,'CROIX');
   	csCircle: FCroix.Handle:=Loadbitmap(HInstance,'CERCLE');
    csDiamond: FCroix.Handle:=Loadbitmap(HInstance,'LOSANGE');
    csSquare: FCroix.Handle:=Loadbitmap(HInstance,'CARRE');
  end;
 	bm:=Tbitmap.Create;
  try
 	  FCroix.canvas.Brush.color:=Fcouleur;
 		bm.Assign(FCroix);
 		FCroix.canvas.BrushCopy(rect(0,0,11,11),bm,rect(0,0,11,11),clteal);
 	finally
		bm.free;
  end;
end;

procedure TcpCoord.Setxstep(Value: integer);
begin
  if (Value <> Fxstep) and (value<>0) then
  begin
    Fxstep:=Value;
    if Fxmin<>Fxmax then Fxstep:=abs(Fxstep)*(Fxmax-Fxmin) div abs(Fxmax-Fxmin);
    if (Fcoordx-Fxmin) mod Fxstep <> 0 then
    	Fcoordx:=Fxmin+((Fcoordx-Fxmin) div Fxstep)*Fxstep;
    if (Fxmax-Fxmin) mod Fxstep <> 0 then
    	Fxmax:=Fxmin+((Fxmax-Fxmin) div Fxstep)*Fxstep;
	  if csdesigning in componentstate then calculwidth;
    refresh;
  end;
end;

procedure TcpCoord.Setystep(Value: integer);
begin
  if (Value <> Fystep) and (value<>0) then
  begin
    Fystep:=Value;
    if Fymin<>Fymax then Fystep:=abs(Fystep)*(Fymax-Fymin) div abs(Fymax-Fymin);
    if (Fcoordy-Fymin) mod Fystep <> 0 then
    	Fcoordy:=Fymin+((Fcoordy-Fymin) div Fystep)*Fystep;
    if (Fymax-Fymin) mod Fystep <> 0 then
    	Fymax:=Fymin+((Fymax-Fymin) div Fystep)*Fystep;
	  if csdesigning in componentstate then calculheight;
  end;
end;

procedure TcpCoord.Setxmin(Value: integer);
begin
  if (Value <> Fxmin) then
  begin
    Fxmin := Value;
    if Fxmin<>Fxmax then Fxstep:=abs(Fxstep)*(Fxmax-Fxmin) div abs(Fxmax-Fxmin);
    if (Fxmax-Fxmin) mod Fxstep <> 0 then
    	Fxmax:=Fxmin+((Fxmax-Fxmin) div Fxstep)*Fxstep;
    if (Fcoordx-Fxmin) mod Fxstep <> 0 then
    	Fcoordx:=Fxmin+((Fcoordx-Fxmin) div Fxstep)*Fxstep;
		if not(Fcoordx in [Fxmin..Fxmax]) then Fcoordx:=Fxmin;
	  if csdesigning in componentstate then calculwidth;
    refresh;
  end;
end;

procedure TcpCoord.Setxmax(Value: integer);
begin
  if (Value <> Fxmax) then
  begin
    Fxmax := Value;
    if Fxmin<>Fxmax then Fxstep:=abs(Fxstep)*(Fxmax-Fxmin) div abs(Fxmax-Fxmin);
    if (Fxmax-Fxmin) mod Fxstep <> 0 then
    	Fxmax:=Fxmin+((Fxmax-Fxmin) div Fxstep)*Fxstep;
    if (Fcoordx-Fxmin) mod Fxstep <> 0 then
    	Fcoordx:=Fxmin+((Fcoordx-Fxmin) div Fxstep)*Fxstep;
		if not(Fcoordx in [Fxmin..Fxmax]) then Fcoordx:=Fxmin;
	  if csdesigning in componentstate then calculwidth;
    refresh;
  end;
end;

procedure TcpCoord.Setymin(Value: integer);
begin
  if (Value <> Fymin) then
  begin
    Fymin := Value;
    if Fymin<>Fymax then Fystep:=abs(Fystep)*(Fymax-Fymin) div abs(Fymax-Fymin);
    if (Fymax-Fymin) mod Fystep <> 0 then
    	Fymax:=Fymin+((Fymax-Fymin) div Fystep)*Fystep;
    if (Fcoordy-Fymin) mod Fystep <> 0 then
    	Fcoordy:=Fymin+((Fcoordy-Fymin) div Fystep)*Fystep;
		if not(Fcoordy in [Fymin..Fymax]) then Fcoordy:=Fymin;
	  if csdesigning in componentstate then calculheight;
    refresh;
  end;
end;

procedure TcpCoord.Setymax(Value: integer);
begin
  if (Value <> Fymax) then
  begin
    Fymax := Value;
    if Fymin<>Fymax then Fystep:=abs(Fystep)*(Fymax-Fymin) div abs(Fymax-Fymin);
    if (Fymax-Fymin) mod Fystep <> 0 then
    	Fymax:=Fymin+((Fymax-Fymin) div Fystep)*Fystep;
    if (Fcoordy-Fymin) mod Fystep <> 0 then
    	Fcoordy:=Fymin+((Fcoordy-Fymin) div Fystep)*Fystep;
		if not(Fcoordy in [Fymin..Fymax]) then Fcoordy:=Fymin;
	  if csdesigning in componentstate then calculheight;
    refresh;
  end;
end;

procedure TcpCoord.Setcoordx (Value: integer);
begin
	if (Value <> Fcoordx) and ((Value in [Fxmin..Fxmax]) or (value in [Fxmax..Fxmin])) then
  	begin
	  	Fcoordx:=value;
      postmessage(self.Handle,CM_CHANGECOORDX,Fcoordx,Fcoordy);
      refresh;
    end;
end;

procedure TcpCoord.Setcoordy (Value: integer);
begin
	if (Value <> Fcoordy) and ((Value in [Fymin..Fymax]) or (value in [Fymax..Fymin])) then
  	begin
	  	Fcoordy:=value;
      postmessage(self.Handle,CM_CHANGECOORDY,Fcoordx,Fcoordy);
      refresh;
    end;
end;

procedure TcpCoord.Setcroixstyle (value:Tcroixstyle);
begin
	if value<>Fcroixstyle then
  	begin
	  	Fcroixstyle:=value;
      couleurcroix;
      refresh;
    end;
end;

procedure TcpCoord.Paint;
var
	i,x,y:integer;
  tw,th:integer;
  t:string;
begin
	Canvas.Brush.Color:=Fcouleur;
	Canvas.fillrect(rect(15,15,clientwidth-15,clientheight-15));
  x:=(Fcoordx-Fxmin)*Flargeurcase div Fxstep +Flargeurcase div 2+15;
  y:=(Fcoordy-Fymin)*Fhauteurcase div Fystep +Fhauteurcase div 2+15;
  if Fcroixstyle=csCoordinates then
  	begin
    	t:=FSeparateur;
    	i:=pos('[x]',lowercase(t));
			if i>0 then
  			begin
		      delete(t,i,3);
    		  insert(inttostr(Fcoordx),t,i);
				end;
    	i:=pos('[y]',lowercase(t));
			if i>0 then
  			begin
		      delete(t,i,3);
    		  insert(inttostr(Fcoordy),t,i);
				end;
      tw:=canvas.TextWidth(t);
      th:=canvas.TextHeight(t);
      x:=x-tw div 2;
      y:=y-th div 2;
      if x+tw>clientwidth-15 then x:=clientwidth-tw-15;
      if y+th>clientheight-15 then y:=clientheight-th-15;
      if x<15 then x:=15;
      if y<15 then y:=15;
      canvas.Font.Assign(font);
    	canvas.Brush.Color:=FCouleurcoord;
      canvas.TextOut(x,y,t);
    end
  else
	  canvas.CopyRect(rect(x-5,y-5,x+6,y+6),FCroix.canvas,rect(0,0,10,10));
	Canvas.Brush.Color:=color;
  Canvas.fillrect(rect(0,0,15,15));
  Canvas.fillrect(rect(clientwidth-15,0,clientwidth,15));
  Canvas.fillrect(rect(0,clientheight-15,15,clientheight));
  Canvas.fillrect(rect(clientwidth-15,clientheight-15,clientwidth,clientheight));
  if FLeftbutton.Flat then
  	begin
			Canvas.Brush.Color:=Fcouleurflat;
		  Canvas.fillrect(FLeftbutton.BoundsRect);
 		  Canvas.fillrect(FRightbutton.BoundsRect);
		  Canvas.fillrect(FUpbutton.BoundsRect);
		  Canvas.fillrect(FDownbutton.BoundsRect);
    end;
end;

procedure TcpCoord.KeyDown(var Key: Word; Shift: TShiftState);
begin
  case key of
  	vk_left,VK_NUMPAD4: nouvellescoordonnes(Fcoordx-Fxstep,Fcoordy);
  	vk_right,VK_NUMPAD6: nouvellescoordonnes(Fcoordx+Fxstep,Fcoordy);
  	vk_up,VK_NUMPAD8,VK_PRIOR: nouvellescoordonnes(Fcoordx,Fcoordy-Fystep);
  	vk_down,VK_NUMPAD2,VK_NEXT: nouvellescoordonnes(Fcoordx,Fcoordy+Fystep);
    VK_HOME: nouvellescoordonnes(Fxmin,Fymin);
    VK_END: nouvellescoordonnes(Fxmax,Fymax);
    VK_NUMPAD1: nouvellescoordonnes(Fcoordx-Fxstep,Fcoordy+Fystep);
    VK_NUMPAD3: nouvellescoordonnes(Fcoordx+Fxstep,Fcoordy+Fystep);
    VK_NUMPAD7: nouvellescoordonnes(Fcoordx-Fxstep,Fcoordy-Fystep);
    VK_NUMPAD9: nouvellescoordonnes(Fcoordx+Fxstep,Fcoordy-Fystep);
  end;
	inherited;
end;

procedure TcpCoord.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if (shift=[ssleft]) then
 		nouvellescoordonnes(((x-15) div Flargeurcase)*Fxstep+Fxmin,((y-15) div Fhauteurcase)*Fystep+Fymin);
  inherited;
end;

procedure TcpCoord.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
	if (shift=[ssleft]) then
 		nouvellescoordonnes(((x-15) div Flargeurcase)*Fxstep+Fxmin,((y-15) div Fhauteurcase)*Fystep+Fymin);
  inherited;
end;

procedure TcpCoord.nouvellescoordonnes(x,y:integer);
begin
	if Fxstep>0 then
		begin
    	if x<Fxmin then
		 		x:=Fxmin
			else if x>Fxmax then
  			x:=Fxmax
    end
  else
  	begin
    	if x<Fxmax then
		 		x:=Fxmax
			else if x>Fxmin then
  			x:=Fxmin
    end;
  if Fystep>0 then
  	begin
			if y<Fymin then
  			y:=Fymin
			else if y>Fymax then
  			y:=Fymax
    end
  else
  	begin
			if y<Fymax then
  			y:=Fymax
			else if y>Fymin then
  			y:=Fymin
    end;
  if (Fcoordx<>x) or (Fcoordy<>y) then
   	begin
  		if Fcoordx<>x then
		   	begin
    	  	Fcoordx:=x;
      	  postmessage(self.Handle,CM_CHANGECOORDX,Fcoordx,Fcoordy);
		    end;
    	if Fcoordy<>y then
      	begin
			    Fcoordy:=y;
    	    postmessage(self.Handle,CM_CHANGECOORDY,Fcoordx,Fcoordy);
       	end;
      refresh;
    end;
end;

procedure TcpCoord.BtnClick(Sender: TObject);
begin
	if sender=FLeftbutton then
    nouvellescoordonnes(Fcoordx-Fxstep,Fcoordy)
  else if sender=FRightbutton then
  	nouvellescoordonnes(Fcoordx+Fxstep,Fcoordy)
  else if sender=FUpbutton then
  	nouvellescoordonnes(Fcoordx,Fcoordy-Fystep)
  else if sender=FDownbutton then
  	nouvellescoordonnes(Fcoordx,Fcoordy+Fystep);
end;

procedure Register;
begin
  RegisterComponents('Exemples', [TcpCoord]);
end;

end.
