unit CoolForm;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtCtrls ,dsgnintf;
	
type
	TCoolForm = class;

	TRegionType = class(TPersistent)
		public
			Fregion:hrgn;
			owner:TCoolForm;
	end;

	TCoolForm = class(TImage)
		private
			Fregion:TRegionType;
			// the dummy is necessary (or maybe not) as a public property for the writing of the
			// mask into a stream (btter leyve it as it is, never touch a running system)
			Dummy:TRegionType;
			FIsDragging:boolean;
			Foldx,Foldy:integer;
			FDraggable:boolean;
			procedure PictureChanged(Sender:TObject);
			procedure ReadMask(Reader: TStream);
			procedure WriteMask(Writer: TStream);
			procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);override;
			procedure MouseMove(Shift: TShiftState; X, Y: Integer);override;
			procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);override;
			procedure DefineProperties(Filer: TFiler);override;
		protected
			procedure SetParent(Value:TWinControl); override;
			procedure SetRegion(Value:TRegionType);
			procedure SetTop(Value:integer); virtual;
			procedure SetLeft(Value:integer); virtual;
			function GetRegion:TRegionType;
		public
			constructor Create(Aowner:TComponent); override;
			destructor	Destroy; override;
			property Mask2:TRegionType read Dummy write Dummy;
		published
			property Mask:TRegionType read GetRegion write SetRegion;
			property Draggable:boolean read FDraggable write FDraggable default true;
			property top write settop;
			property left write setleft;
	end;

procedure Register;

implementation
uses
	MaskEditor;

procedure Register;
begin
	RegisterComponents('Cool!', [TCoolForm]);
	RegisterPropertyEditor( TypeInfo( TRegionType ), TCoolForm, 'Mask', TCoolMaskEditor );
end;


// The next two procedures are there to ensure hat the component always sits in the top left edge of the window
procedure TCoolForm.SetTop(Value:integer);
begin
	inherited top:=0;
end;

procedure TCoolForm.SetLeft(Value:integer);
begin
	inherited left:=0;
end;


destructor TCoolForm.destroy;
begin
	if fregion.fregion<>0 then deleteobject(fregion.fregion);
	Dummy.Free;
	FRegion.free;
	inherited;
end;

constructor TCoolForm.create(Aowner:TComponent);
begin
	inherited;
	// make it occupy all of the form
	Align:=alClient;
	Fregion:=TRegionType.Create;
	Dummy:=TRegionType.Create;
	Fregion.Fregion:=0;
	Fregion.owner:=self;
	Picture.OnChange:=PictureChanged;
	// if draggable is false, it will be overwritten later by delphi`s runtime component loader
	Draggable:=true;
end;

procedure TCoolForm.PictureChanged(Sender:TObject);
begin
	if (parent<>nil) and (picture.bitmap<>nil) then
	begin
		// resize the form to fit the bitmap
		width:=picture.bitmap.Width;
		height:=picture.bitmap.height;
		parent.clientwidth:=picture.bitmap.Width;
		parent.clientheight:=picture.bitmap.height;
	end;
	if Fregion.FRegion<>0 then
	begin
		// if somehow there`s a region already, delete it
		deleteObject(FRegion.FRegion);
		FRegion.Fregion:=0;
	end;
end;

function TCoolForm.GetRegion:TRegionType;
begin
	result:=FRegion;
end;



procedure TCoolForm.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	// if dragging is on, start the dragging process
	inherited;
	if FDraggable then FIsDragging:=true;
	FOldx:=x;
	FOldy:=y;
end;


procedure TCoolForm.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
	// if dragging is on, move the form
	if FIsDragging then
	begin
		TWincontrol(Parent).left:=TWincontrol(Parent).left+x-FOldx;
		TWincontrol(Parent).Top:=TWincontrol(Parent).Top+y-FOldy;
	end;
end;


procedure TCoolForm.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	// end the dragging process
	FIsDragging:=false;
end;


// This is used by delphi`s component streaming system
// it is called whenever delphi reads the componnt from the .dfm
procedure TCoolForm.ReadMask(Reader: TStream);
var
	size:integer;
	rgndata						: pRGNData;
begin
	// read the size of the region data to come
	reader.read(size,4);
	if size<>0 then
	begin
		// if we have region data, allocate memory for it
		getmem(rgndata,size);
		// read the data
		reader.read(rgndata^,size);
		// create the region
		FRegion.FRegion:=ExtCreateRegion(nil,size,rgndata^);
		// if runtime, set the region for the window... Tadaaa
		if not (csDesigning in ComponentState) and (FRegion.FRegion<>0) then
		begin
			SetWindowRgn(parent.handle,FRegion.Fregion,true);
		end;
		// dispose of the memory
		freemem(rgndata,size);
	end else fregion.fregion:=0;
end;


// This is pretty much the same stuff as above. Only it`s written this time
procedure TCoolForm.WriteMask(Writer: TStream);
var
	size:integer;
	rgndata						: pRGNData;
begin
	if (fregion.fregion<>0) then
	begin
		// get the region data`s size
		size:=getregiondata(FRegion.FRegion,0,nil);
		getmem(rgndata,size);
		// get the data itself
		getregiondata(FRegion.FRegion,size,rgndata);
		// write it
		writer.write(size,sizeof(size));
		writer.write(rgndata^,size);
		freemem(rgndata,size);
	end else
	begin
		// if there`s no region yet (from the mask editor), then write a size of zero
		size:=0;
		writer.write(size,sizeof(size));
	end;
end;


// This tells Delphi to read the public property `Mask 2` from the stream,
// That`s what we need the dummy for.
procedure TCoolForm.DefineProperties(Filer: TFiler);
begin
	inherited DefineProperties(Filer);
	// tell Delphi which methods to call when reading the property data from the stream
	Filer.DefineBinaryProperty('Mask2',ReadMask,WriteMask,true);
end;



procedure TCoolForm.SetRegion(Value:TRegionType);
begin
	if Value <> nil then
	begin
		FRegion:=Value;
		// The owner is for the property editor to find the component
		FRegion.owner:=self;
	end;
end;


procedure TCoolForm.SetParent(Value:TWinControl);
begin
	inherited;
	if Value<>nil then
		if not (Value is TWinControl) then
		begin
			raise Exception.Create('Drop the CoolForm on a FORM!');
		end else
		with TWincontrol(Value) do
		begin
			 		if Value is TForm then TForm(Value).borderstyle:=bsNone;
		end;
	top:=0;
	left:=0;
end;

end.
