unit Fbuilder;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, DB, Common;

type

  TFBuild = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    EditFieldName: TEdit;
    Label1: TLabel;
    Panel4: TPanel;
    EditFieldSize: TEdit;
    Label2: TLabel;
    Panel5: TPanel;
    ListBox1: TListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    IdxCheckBox: TCheckBox;  { Index true/false }
    procedure FormActivate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FBuild: TFBuild;

implementation

{$R *.DFM}

procedure TFBuild.FormActivate(Sender: TObject);
begin
   { clear the tranfert record }
   with FieldRec do
   begin
      name := '';
      tipo := ftUnknown;
      size := 10;
      idx := FALSE;
   end;
   { clear all the controls }
   EditFieldName.Text := '';
   EditFieldSize.Text := '';
   IdxCheckBox.State := cbUnChecked;
   ListBox1.Invalidate;
end;

procedure TFBuild.BitBtn1Click(Sender: TObject);
var
   N, err : integer;
begin

   if EditFieldName.Modified then FieldRec.Name := EditFieldName.Text;

   if ListBox1.itemIndex <> -1 then
   begin
      if ListBox1.Selected[0] then
      begin
        FieldRec.Tipo := ftBoolean;
        FieldRec.Size := 0;
      end;
      if ListBox1.Selected[1] then
      begin
        FieldRec.Tipo := ftCurrency;
        FieldRec.Size := 0;
      end;
      if ListBox1.Selected[2] then
      begin
         FieldRec.Tipo := ftDate;
         FieldRec.Size := 0;
      end;
      if ListBox1.Selected[3] then
      begin
        FieldRec.Tipo := ftFloat;
        FieldRec.Size := 0;
      end;
      if ListBox1.Selected[4] then
      begin
        FieldRec.Tipo := ftString;

        Val(EditFieldSize.Text, N ,err);
        if ((err<>0)or(N<1)) then
        begin
           ShowMessage('La lunghezza della stringa deve essere > 0');
           ShowMessage('The string length must be > 0');
           FieldRec.Size := -1;
        end
        else FieldRec.Size := N;
      end;
   end;

   if IdxCheckBox.State = cbChecked then FieldRec.Idx := TRUE
   else FieldRec.Idx := FALSE;

end;


end.
