unit Campi;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, FBuilder, DB,Common;

type
  TFieldEditor = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Bevel1: TBevel;
    BitBtn1: TBitBtn;
    Bevel2: TBevel;
    AddButton: TButton;
    RemoveButton: TButton;
    ClearAllButton: TButton;
    Label1: TLabel;
    ListBox1: TListBox;
    procedure AddButtonClick(Sender: TObject);
    procedure ClearAllButtonClick(Sender: TObject);
    procedure RemoveButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FieldEditor: TFieldEditor;

implementation

{$R *.DFM}

procedure TFieldEditor.AddButtonClick(Sender: TObject);
begin
   FieldRec := TFieldRec.Create;
   FBuild := TFBuild.Create(self);
   if FBuild.ShowModal = idOk then
   begin
      messageBeep(0);
      if FieldRec.Name = '' then
      begin
         ShowMessage('Field name missing');
         FieldRec.Free;
         EXIT;
      end;
      if FieldRec.Size < 0 then
      begin
         ShowMessage('Bad field length');
         FieldRec.Free;
         EXIT;
      end;
      if FieldRec.Tipo = ftUnknown then
      begin
         ShowMessage('Data type missing');
         FieldRec.Free;
         EXIT;
      end;

      { if Ok inserts FieldRec (COMMON.PAS) into Lista }
      { and add the name in the listBox                }

      ListBox1.Items.Add(FieldRec.Name);
      Lista.Add(FieldRec);

   end;

end;

procedure TFieldEditor.ClearAllButtonClick(Sender: TObject);
var C : integer;
begin
    if MessageDlg('I''m going to erase all.' + chr(13) +
                  'Are you sure ?',
                   mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    begin
       { clear Lista }
       for C := 0 to (Lista.Count - 1) do
       begin
          FieldRec := Lista.Items[C];
          FieldRec.Free;
       end;
       Lista.Clear;
       { clear the listBox }
       ListBox1.Items.Clear;
    end;
end;

procedure TFieldEditor.RemoveButtonClick(Sender: TObject);
var
  SS : string;
  C  : integer;
  Pt : TFieldRec;
begin
   if ListBox1.Itemindex = -1 then
   ShowMessage('No field selected')
   else
   begin
      { get the field name }
      SS := ListBox1.Items.Strings[ListBox1.Itemindex];
      if MessageDlg('Do you want erase ' + SS + ' ?',
                   mtConfirmation, [mbYes, mbNo], 0) = mrYes then
      begin
         { ListBox }
          ListBox1.Items.Delete(ListBox1.Items.IndexOf(SS));
         { cerca ed elimina l'elemento dalla lista dei campi 'Lista' }
          Pt := NIL;
          { search in Lista }
          for C := 0 to (Lista.Count - 1) do
          begin
             if SS = TFieldRec(Lista.Items[C]).name
             then Pt := Lista.Items[C];
          end;
          if Pt <> NIL then
          begin
             Lista.Remove(Pt);
             Pt.Free;
             Lista.Pack;        
          end;
      end;
   end;
end;

end.
