unit demoform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, StartProcessBitBtn, ExtDlgs;

type
  TForm1 = class(TForm)
    StartProcessBitBtn1: TStartProcessBitBtn;
    Label1: TLabel;
    StartProcessBitBtn2: TStartProcessBitBtn;
    Label2: TLabel;
    Memo1: TMemo;
    Edit1: TEdit;
    OpenPictureDialog1: TOpenPictureDialog;
    Edit2: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Edit3: TEdit;
    Edit4: TEdit;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label3: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    procedure StartProcessBitBtn2CancelFail(Owner: TComponent);
    procedure StartProcessBitBtn2StartFail(Owner: TComponent;
      Error: Integer);
    procedure StartProcessBitBtn2ProcessReturn(Owner: TComponent;
      Normal: Boolean);
    procedure StartProcessBitBtn2Click(Sender: TObject);
    procedure Memo1Exit(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure Edit2Exit(Sender: TObject);
    procedure Edit3Exit(Sender: TObject);
    procedure Edit4Exit(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure StartProcessBitBtn2CancelClick(Owner: TComponent);
    procedure Label6Click(Sender: TObject);
    procedure Label4Click(Sender: TObject);
    procedure Label8Click(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure Label7Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.StartProcessBitBtn2ProcessReturn(Owner: TComponent;
  Normal: Boolean);
var
  cl,wd:string;
begin
  Screen.Cursor:=crDefault;
  cl:='Command Line = '+TStartProcessBitBtn(Owner).CommandLine+#13+#10;
  wd:='Working Dir. = '+TStartProcessBitBtn(Owner).WorkingDir+#13+#10;
  if Normal
  then MessageDlg(cl+wd+'Returned normally.',mtInformation,[mbOK],0)
  else MessageDlg(cl+wd+'was canceled',mtInformation,[mbOK],0)
end;

procedure TForm1.StartProcessBitBtn2CancelFail(Owner: TComponent);
begin
  MessageDlg('Cancel failed!',mtError,[mbOK],0);
end;

procedure TForm1.StartProcessBitBtn2StartFail(Owner: TComponent;
  Error: Integer);
begin
  Screen.Cursor:=crDefault;
  MessageDlg('Start failed'+#13+#10+'( error = '+IntToStr(Error)+' )',mtError,[mbOK],0);
end;

procedure TForm1.StartProcessBitBtn2Click(Sender: TObject);
begin
  Screen.Cursor:=crAppStart
end;

procedure TForm1.Memo1Exit(Sender: TObject);
begin
  StartProcessBitBtn2.CancelWarning:=Memo1.Text
end;

procedure TForm1.Edit1Exit(Sender: TObject);
begin
  StartProcessBitBtn2.Caption:=Edit1.Text
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var
  pix:TPicture;
begin
  pix:=TPicture.Create;
  if not OpenPictureDialog1.Execute then exit;
  pix.LoadFromFile(OpenPictureDialog1.FileName);
  StartProcessBitBtn2.Glyph.Assign(pix.Bitmap);
  BitBtn1.Glyph.Assign(pix.Bitmap)
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
var
  pix:TPicture;
begin
  pix:=TPicture.Create;
  if not OpenPictureDialog1.Execute then exit;
  pix.LoadFromFile(OpenPictureDialog1.FileName);
  StartProcessBitBtn2.CancelGlyph.Assign(pix.Bitmap);
  BitBtn2.Glyph.Assign(pix.Bitmap)
end;

procedure TForm1.Edit2Exit(Sender: TObject);
begin
  StartProcessBitBtn2.CancelCaption:=Edit2.Text
end;

procedure TForm1.Edit3Exit(Sender: TObject);
begin
  StartProcessBitBtn2.CommandLine:=Edit3.Text
end;

procedure TForm1.Edit4Exit(Sender: TObject);
begin
  StartProcessBitBtn2.WorkingDir:=Edit4.Text
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  StartProcessBitBtn2.DisplayCancelWarning:=CheckBox1.Checked
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  StartProcessBitBtn2.WaitForReturn:=CheckBox2.Checked
end;

procedure TForm1.StartProcessBitBtn2CancelClick(Owner: TComponent);
begin
  MessageDlg('Cancel Clicked',mtInformation,[mbOK],0);
end;

procedure TForm1.Label6Click(Sender: TObject);
begin
  MessageDlg('Screen.Cursor:=crAppStart',mtInformation,[mbOK],0);
end;

procedure TForm1.Label4Click(Sender: TObject);
begin
  MessageDlg('  Screen.Cursor:=crDefault;'+#13+#10+'  MessageDlg('+#39+'Start failed'+#39+'+#13+#10+'+#13+#10+'                       '+#39+'( error = '+#39+'+IntToStr(Error)+'+#39+' )'+#39+','+#13+#10+'                       mtError,[mbOK],0);',mtInformation,[mbOK],0);
end;

procedure TForm1.Label8Click(Sender: TObject);
begin
  MessageDlg('MessageDlg('+#39+'Cancel Clicked'+#39+',mtInformation,[],0);',mtInformation,[mbOK],0);
end;

procedure TForm1.Label5Click(Sender: TObject);
begin
  MessageDlg('MessageDlg('+#39+'Cancel failed!'+#39+',mtError,[mbOK],0);',mtInformation,[mbOK],0);
end;

procedure TForm1.Label7Click(Sender: TObject);
begin
  MessageDlg('  Screen.Cursor:=crDefault;'+#13+#10+'  cl:='+#39+'Command Line = '+#39+'+TStartProcessBitBtn(Owner).CommandLine+#13+#10;'+#13+#10+'  wd:='+#39+'Working Dir. = '+#39+'+TStartProcessBitBtn(Owner).WorkingDir+#13+#10;'+#13+#10+'  if Normal'+#13+#10+'  then MessageDlg(cl+wd+'+#39+'Returned normally.'+#39+',mtInformation,[mbOK],0)'+#13+#10+'  else MessageDlg(cl+wd+'+#39+'Was canceled'+#39+',mtInformation,[mbOK],0)',mtInformation,[mbOK],0);
end;

end.
