{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{       Composite Components Pack (CCPack)              }
{                                                       }
{       Copyright (c) 1997,98 Sergey Orlik              }
{                                                       }
{       Written by:                                     }
{         Sergey Orlik                                  }
{         Borland Russia, Moscow                        }
{         Internet:  sorlik@borland.ru                  }
{                                                       }
{*******************************************************}

unit BoxExpt;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus,
  ComCtrls, ExtCtrls, StdCtrls,
  DsgnIntf, ExptIntf, ToolIntf, EditIntf, VirtIntf, TypInfo, Boxes;

type
  { TBoxExpert }

  TBoxExpert = class(TIExpert)
  public
    function GetName: string; override;
    function GetComment: string; override;
    function GetGlyph: HICON; override;
    function GetStyle: TExpertStyle; override;
    function GetState: TExpertState; override;
    function GetIDString: string; override;
    function GetAuthor: string; override;
    function GetPage: string; override;
    procedure Execute; override;
  end;

  TNewBoxDlg = class(TForm)
    Bevel1: TBevel;
    BtnCancel: TButton;
    BtnCreate: TButton;
    Label1: TLabel;
    Label2: TLabel;
    EdClass: TEdit;
    EdPage: TComboBox;
    Label3: TLabel;
    EdAncestor: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure ClassChange(Sender: TObject);
  end;

var
  NewBoxDlg: TNewBoxDlg;

procedure Register;

implementation

{$R *.DFM}
{$R *.RES}

const
  CRLF = #13#10;
  CRLF2 = #13#10#13#10;
  DefaultModuleFlags = [cmShowSource, cmShowForm, cmMarkModified, cmUnNamed];

  { kind of box}
  bkBox = 0;
  bkControlGroupBox = 1;
  bkModuleBox = 2;
  bkToolBarBox = 3;

  BoxKind : array[0..3] of string
          = ('Box','ControlGroupBox','ModuleBox','ToolBarBox');

  { initial size parameters for boxes }
  isBoxWidth : integer = 300;
  isBoxHeight : integer = 200;
  isToolBarBoxHeight : integer = 40;

resourcestring
  sBoxExpertAuthor = 'Sergey Orlik';
  sBoxExpertName   = 'Composite Component';
  sBoxExpertDesc   = 'Creates a new composite component';

{ TBoxModuleCreator }

type
  TBoxModuleCreator = class(TIModuleCreator)
  private
    FClass   : string;
    FPage    : string;
    FBoxKind : integer;
  public
    function Existing: Boolean; override;
    function GetFileName: string; override;
    function GetFileSystem: string; override;
    function GetFormName: string; override;
    function GetAncestorName: string; override;
    function NewModuleSource(UnitIdent, FormIdent,
      AncestorIdent: string): string; override;
    procedure FormCreated(Form: TIFormInterface); override;
  end;

function TBoxModuleCreator.Existing:boolean;
begin
    Result:=False
end;

function TBoxModuleCreator.GetFileName:string;
begin
  Result:='';
end;

function TBoxModuleCreator.GetFileSystem:string;
begin
  Result:='';
end;

function TBoxModuleCreator.GetFormName:string;
var
  s : string;
begin
  s:=FClass;
  if s<>EmptyStr then
    System.Delete(s,1,1);
  Result:=s;
end;

function TBoxModuleCreator.GetAncestorName:string;
begin
  Result:=BoxKind[FBoxKind];
end;

function TBoxModuleCreator.NewModuleSource(UnitIdent,FormIdent,AncestorIdent:string):string;
var
  s : string;
begin
    Result:='unit '+UnitIdent+';'+CRLF2+
      'interface'+CRLF2+
      'uses'+CRLF+
      '  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,'+CRLF+
      '  Boxes';
    if FBoxKind <> bkModuleBox then
      Result:=Result+', ExtCtrls, StdCtrls, ComCtrls';

      Result:=Result+';'+CRLF2+
      'type'+CRLF;

  if FClass<>EmptyStr then
    Result:=Result+'  '+FClass
  else
    Result:=Result+'  T'+FormIdent;

    Result:=Result+' = class(T'+BoxKind[FBoxKind]+')'+CRLF+
      '  private'+CRLF+
      '    { Private declarations }'+CRLF+
      '  protected'+CRLF+
      '    { Protected declarations }'+CRLF+
      '  public'+CRLF+
      '    { Public declarations }'+CRLF+
      '  published'+CRLF+
      '    { Published declarations }'+CRLF;

  if FBoxKind in [bkBox,bkControlGroupBox] then
    Result:=Result+
      '    property Align;'+CRLF;

    Result:=Result+
      '  end;'+CRLF2;

  if FPage<>EmptyStr then Result:=Result+
      'procedure Register;'+CRLF2;

    Result:=Result+
      'implementation'+CRLF2+
      '{$R *.DFM}'+CRLF2;

  if FPage<>EmptyStr then
  begin
    Result:=Result+
      'procedure Register;'+CRLF+
      'begin'+CRLF+
      '  RegisterComponents('''+FPage+''',[';

    if FClass<>EmptyStr then
      Result:=Result+FClass
    else
      Result:=Result+'T'+FormIdent;

      Result:=Result+']);'+CRLF+
      'end;'+CRLF2;
  end;

    Result:=Result+
      'end.'+CRLF;
end;

procedure TBoxModuleCreator.FormCreated(Form:TIFormInterface);
var
  Comp: TIComponentInterface;
begin
  Comp:=Form.GetFormComponent;
  if FBoxKind=bkToolBarBox then
    Comp.SetPropByName('Height',isToolBarBoxHeight)
  else
    Comp.SetPropByName('Height',isBoxHeight);
  Comp.SetPropByName('Width',isBoxWidth);
  Comp.Free;
  Form.Free;
end;

{ HandleException }

procedure HandleException;
begin
  ToolServices.RaiseException(ReleaseException);
end;

{ BoxExpert }

procedure BoxExpert(ToolServices: TIToolServices);
var
  IModuleCreator : TBoxModuleCreator;
  IModule : TIModuleInterface;
begin
  NewBoxDlg:=TNewBoxDlg.Create(Application);
  if NewBoxDlg.ShowModal=mrCancel then
  begin
    NewBoxDlg.Free;
    Exit;
  end;
  IModuleCreator:=TBoxModuleCreator.Create;
  IModuleCreator.FBoxKind:=NewBoxDlg.EdAncestor.ItemIndex;
  IModuleCreator.FClass:=NewBoxDlg.EdClass.Text;
  if IModuleCreator.FClass[1]<>'T' then
    IModuleCreator.FClass:='T'+IModuleCreator.FClass;
  IModuleCreator.FPage:=NewBoxDlg.EdPage.Text;
  try
    IModule:=ToolServices.ModuleCreate(IModuleCreator,DefaultModuleFlags);
    IModule.Free;
  finally
    IModuleCreator.Free;
    NewBoxDlg.Free;
  end;
end;

{ TBoxExpert }

function TBoxExpert.GetName: string;
begin
  try
    Result := sBoxExpertName;
  except
    HandleException;
  end;
end;

function TBoxExpert.GetComment: string;
begin
  try
    Result := sBoxExpertDesc;
  except
    HandleException;
  end;
end;

function TBoxExpert.GetGlyph: HICON;
begin
  try
    Result := LoadIcon(HInstance, 'NEWBOX');
  except
    HandleException;
  end;
end;

function TBoxExpert.GetStyle: TExpertStyle;
begin
  try
    Result := esForm;
  except
    HandleException;
  end;
end;

function TBoxExpert.GetState: TExpertState;
begin
  try
    Result := [esEnabled];
  except
    HandleException;
  end;
end;

function TBoxExpert.GetIDString: string;
begin
  try
    Result := 'Borland.'+sBoxExpertName;
  except
    HandleException;
  end;
end;

function TBoxExpert.GetAuthor: string;
begin
  try
    Result := sBoxExpertAuthor;
  except
    HandleException;
  end;
end;

function TBoxExpert.GetPage: string;
begin
  try
    Result := 'New';
  except
    HandleException;
  end;
end;

procedure TBoxExpert.Execute;
begin
  try
    BoxExpert(ToolServices);
  except
    HandleException;
  end;
end;

procedure TNewBoxDlg.FormCreate(Sender: TObject);
var
  IDEMainForm : TForm;
  IDEPalTabs  : TTabControl;
  i : integer;
begin
  IDEMainForm:=TForm(Application.MainForm);
  IDEPalTabs:=TTabControl(IDEMainForm.FindComponent('TabControl'));
    for i:=0 to IDEPalTabs.Tabs.Count-1 do
      EdPage.Items.Add(IDEPalTabs.Tabs[i]);
  for i:=0 to High(BoxKind) do
    EdAncestor.Items.Add(BoxKind[i]);
  EdAncestor.ItemIndex:=0;
  EdPage.ItemIndex:=EdPage.Items.IndexOf('Samples');
end;

procedure TNewBoxDlg.ClassChange(Sender: TObject);
begin
  if (EdClass.Text=EmptyStr) or not IsValidIdent(EdClass.Text) then
    BtnCreate.Enabled:=False
  else
    BtnCreate.Enabled:=True;
end;

{ Register }

procedure Register;
begin
  RegisterLibraryExpert(TBoxExpert.Create);
end;

end.
