{*******************************************************}
{                                                       }
{       Delphi Visual Component Library                 }
{       Composite Components Pack (CCPack)              }
{                                                       }
{       Copyright (c) 1997,98 Sergey Orlik              }
{                                                       }
{       Written by:                                     }
{         Sergey Orlik                                  }
{         Borland Russia, Moscow                        }
{         Internet:  sorlik@borland.ru                  }
{                                                       }
{*******************************************************}

unit BoxDsgn;

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus,
  ComCtrls, DsgnIntf, Boxes;

type
  TBoxCustomModule = class(TCustomModule)
  public
    procedure ValidateComponent(Component:TComponent); override;
  end;

  TModuleBoxCustomModule = class(TCustomModule)
  public
    procedure ValidateComponent(Component:TComponent); override;
  end;

  TToolBarBoxCustomModule = class(TBoxCustomModule)
  public
    procedure ExecuteVerb(Index:integer); override;
    function getVerb(Index:integer):string; override;
    function getVerbCount:integer; override;
  end;

procedure Register;

implementation

resourcestring
  sErrorCreateComponent = 'Component can not be added to a box';
  SNewBtn = 'New &Button';
  SNewSpr = 'New Se&parator';
  SNewDiv = 'New &Divider';
  SNewBtnName = 'TBoxToolButton';

const
  ToolBarBoxVerbs: array[0..2] of string = (SNewBtn, SNewSpr, SNewDiv);

{ TBoxCustomModule }

procedure TBoxCustomModule.ValidateComponent(Component:TComponent);
begin
  if Component is TMainMenu then
    raise Exception.Create(sErrorCreateComponent)
end;

{ TModuleBoxCustomModule }

procedure TModuleBoxCustomModule.ValidateComponent(Component:TComponent);
begin
  if (Component is TControl) or (Component is TMainMenu) then
    raise Exception.Create(sErrorCreateComponent)
end;

{ TToolBarBoxCustomModule }

procedure TToolBarBoxCustomModule.ExecuteVerb(Index:integer);
var
  ToolBar: TToolBar;
  Btn: TToolButton;
  Designer: TFormDesigner;
begin
  if Root is TToolButton then
    ToolBar := TToolBar(TToolButton(Root).Parent) else
    ToolBar := TToolBar(Root);
  if ToolBar <> nil then
  begin
    Designer := TFormDesigner(TCustomForm(TWinControl(Root).Parent).Designer);
    begin
      Btn := TToolButton.Create(Root);
      try
        Btn.Name := Designer.UniqueName(sNewBtnName);
        Btn.Parent := ToolBar;
        case Index of
          0 : Btn.Style:=tbsButton;
          1 : begin
                Btn.Style:=tbsSeparator;
                Btn.Width:=8;
              end;
          2 : begin
                Btn.Style:=tbsDivider;
                Btn.Width:=16;
              end;
        end;
      except
        Btn.Free;
        raise;
      end;
      Designer.SelectComponent(Btn);
      Designer.Modified;
    end;
  end;
end;

function TToolBarBoxCustomModule.getVerb(Index:integer):string;
begin
  Result := ToolBarBoxVerbs[Index];
end;

function TToolBarBoxCustomModule.getVerbCount:integer;
begin
  Result := High(ToolBarBoxVerbs) + 1;
end;

{ Register }

procedure Register;
begin
  RegisterCustomModule(TBox, TBoxCustomModule);
  RegisterCustomModule(TControlGroupBox, TBoxCustomModule);
  RegisterCustomModule(TModuleBox, TModuleBoxCustomModule);
  RegisterCustomModule(TToolBarBox, TToolBarBoxCustomModule);
end;

end.
