unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComboBoxX, ExtCtrls, Buttons;

type
  TDirInplaceEdit = class (TCBXInplaceEdit)
  private
    FPanel: TPanel;
    FButton: TSpeedButton;
    procedure SetEditRect;
  protected
    procedure WMSize ( var m: TWMSize ); message WM_SIZE;
    procedure WMChar ( var m: TWMChar ); message WM_CHAR;
    procedure ButtonClick ( Sender: TObject );
  public
    constructor Create ( AOwner: TComponent ); override;
    destructor Destroy; override;
  end;


  TForm1 = class(TForm)
    ComboBoxX1: TComboBoxX;
    ComboBoxX2: TComboBoxX;
    ComboBoxX3: TComboBoxX;
    ComboBoxX4: TComboBoxX;
    ComboBoxX5: TComboBoxX;
    ComboBoxX6: TComboBoxX;
    ComboBoxX7: TComboBoxX;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Button1: TButton;
    procedure ComboBoxX5DrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ComboBoxX6MeasureItem(Control: TWinControl; Index: Integer;
      var Height: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBoxX5EditItem(Sender: TObject; var Text: String;
      var TextObject: TObject; var InplaceEditor: TCBXInplaceEdit;
      var Enabled: Boolean);
    procedure ComboBoxX7EditItem(Sender: TObject; var Text: String;
      var TextObject: TObject; var InplaceEditor: TCBXInplaceEdit;
      var Enabled: Boolean);
    procedure ComboBoxX7NewItem(Sender: TObject; var Text: String;
      var TextObject: TObject; var Enabled: Boolean);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    FDirEdit: TDirInplaceEdit;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

constructor TDirInplaceEdit.Create ( AOwner: TComponent );
begin
inherited Create ( AOwner );

FPanel := TPanel.Create ( Self );
FPanel.Parent := Self;

FButton := TSpeedButton.Create ( Self );
with FButton do begin
     Layout := blGlyphBottom;
     Caption := '...';
     Font.Name := 'Arial';
     Font.Style := [fsBold];
     Font.Color := clBtnText;
     Layout := blGlyphBottom;
     Parent := FPanel;
     Flat := TRUE;
     OnClick := ButtonClick;
     end;

Color := $00FFFFDD;
end;


destructor TDirInplaceEdit.Destroy;
begin
FButton.Free;
FPanel.Free;
inherited;
end;

procedure TDirInplaceEdit.SetEditRect;
var
    aRect: TRect;
begin
aRect := ClientRect;
Dec ( aRect.Right, Height+2 );
SendMessage(Handle, EM_SETRECTNP, 0, LongInt(@aRect));
SendMessage(Handle, EM_GETRECT, 0, LongInt(@aRect));
end;

procedure TDirInplaceEdit.WMSize ( var m: TWMSize );
begin
inherited;
FPanel.SetBounds ( Width - Height-1, 0, Height+1, Height );
FButton.SetBounds ( 0, 0 , FPanel.Width, FPanel.Height );
SetEditRect;
end;

procedure TDirInplaceEdit.WMChar ( var m: TWMChar );
begin
inherited;
SetEditRect;
end;

procedure TDirInplaceEdit.ButtonClick ( Sender: TObject );
var
    aDialog: TOpenDialog;
begin
aDialog := TOpenDialog.Create ( Self );
try
    CBXWMActivateEnable ( FALSE );
    if ( aDialog.Execute ) then begin
        Text := aDialog.FileName;
        PerformAction ( ieaAccept );
        end;
finally
    CBXWMActivateEnable ( TRUE );
    aDialog.Free;
    end;
end;

// -----------------------------------------------------------------------------



procedure TForm1.ComboBoxX5DrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var
    aText: string;
begin
with TComboBoxX(Control).Canvas do begin
    if ( odComboBoxEdit in State ) then
        Font.Color := clRed
    else
        Font.Color := clBlack;

    if ( odSelected in State ) then
        Brush.Color := clRed
    else
    if ( Index and 1 = 1 ) then
        Brush.Color := clLime
    else
        Brush.Color := clYellow;

    FillRect ( Rect );

    if ( Index > -1 ) then begin
        aText := TComboBoxX(Control).Items[Index];
        TextRect ( Rect, Rect.Left + 1, Rect.Top + 1, aText );
        end;

    if ( odFocused in State ) then begin
        Brush.Style := bsClear;
        Pen.Color := clRed;
        Rectangle ( Rect );
        Brush.Style := bsSolid;
        end;
    end;
end;


procedure TForm1.ComboBoxX6MeasureItem(Control: TWinControl;
  Index: Integer; var Height: Integer);
var
    aValue: integer;
begin
if ( Index > -1 ) then begin
    aValue := StrToInt ( TComboBoxX(Control).Items[Index] );
    if ( aValue and 1 = 0 ) then
        Height := TComboBoxX(Control).ItemHeight * 2;
    end;
end;

procedure TForm1.ComboBoxX5EditItem(Sender: TObject; var Text: String;
  var TextObject: TObject; var InplaceEditor: TCBXInplaceEdit;
  var Enabled: Boolean);
begin
if ( TComboBoxX(Sender).ItemIndex and 1 = 1 ) then
    InplaceEditor.Color := clAqua
else
    InplaceEditor.Color := clFuchsia;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
FDirEdit := TDirInplaceEdit.Create ( Self );
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
FDirEdit.Free;
end;


procedure TForm1.ComboBoxX7EditItem(Sender: TObject; var Text: String;
  var TextObject: TObject; var InplaceEditor: TCBXInplaceEdit;
  var Enabled: Boolean);
begin
InplaceEditor := FDirEdit;
end;

procedure TForm1.ComboBoxX7NewItem(Sender: TObject; var Text: String;
  var TextObject: TObject; var Enabled: Boolean);
begin
Text := 'C:\My Documents\Unit1.pas';
end;

procedure TForm1.Button1Click(Sender: TObject);
var
    aValue: Boolean;
begin
aValue := not ComboBoxX1.Enabled;
ComboBoxX1.Enabled := aValue;
ComboBoxX2.Enabled := aValue;
ComboBoxX3.Enabled := aValue;
ComboBoxX4.Enabled := aValue;
ComboBoxX5.Enabled := aValue;
ComboBoxX6.Enabled := aValue;
ComboBoxX7.Enabled := aValue;
end;


end.
