//*****************************************************************************
//
//    System          : BtrUtils
//    Category        : Btrive Data type defenition
//    Source          : Btrieve API programmers guide
//
//    Copyright (c), Leonov Alexander
//
//    File version $Revision:1.4$ at $Date:28.01.2004 19:32:31$
//
//    Author : Leonov Alexander
//    web    : http://dev.zibn.net/     mirror at:  http://home.ural.ru/~tigra/
//    e-mail : dev@zibn.net
//
//*****************************************************************************

unit lBtrType;

interface

Uses lBtrCnst;

Type
  TDataLen = LongInt;

Type
  TPosBlock = array [0..127] of byte;

Type
  TKeyBuff = array [0..254] of byte;

Type
  PBtrClientID = ^TBtrClientID;
  TBtrClientID = packed record
  case byte of
    0: (
      PlainData : array [0..15] of byte
    );
    1: (
      networkAndNode : array [0..11] of byte;
      applicationID  : array [0..1] of char;
      threadID : word;
    );
    2: (
      copy_of_networkAndNode : array [0..11] of byte;
      FullAppID : longint;
    );
  end;

Type
  TKeyDescription = packed record
    KeyPosition : word;
    KeyLength   : word;
    KeyFlags    : word;
    UniqueKeys  : longint;
    ExtendedKey : byte;
    NullValue   : byte;
    Reserved    : word;
    KeyNumber   : byte;
    ACSNumber   : byte;
  end;

  TKeyDescriptionKeyInfo = packed record
    KeyPosition : word;
    KeyLength   : word;
    KeyFlags    : word;
  end;

  TKeyDescriptionIndexInfo = packed record
    UniqueKeys  : longint;
    ExtendedKey : byte;
    NullValue   : byte;
    Reserved    : word;
    KeyNumber   : byte;
    ACSNumber   : byte;
  end;

Type
  TBtrieveStandardFileStat = packed record
    RecordLen : word;
    PageSize  : word;
    NumOfIdx  : word;
    NumOfRec : longint;
    FileFlag : word;
    Reserved : word;
    UnusedPages : word;
    Keys : array [0 .. MaxKeyCount-1] of TKeyDescription;
  end;

Type
  TBtrieveAlternateFileStat = packed record
    RecordLen : word;
    PageSize  : word;
    NumOfIdx  : byte;
    FileVer   : byte;
    NumOfRec : longint;
    FileFlag : word;
    UnusedDupPointer : byte;
    Reserved : byte;
    UnusedPages : word;
    Keys : array [0 .. MaxKeyCount-1] of TKeyDescription;
  end;

Type
  TBtrieveFileSpec = packed record
    RecordLen : word;
    PageSize  : word;
    NumOfIdx  : word;
    NumOfRec : longint;
    FileFlag : word;
    Reserved : word;
    UnusedPages : word;
  end;

Type
  BDateType =  packed record
    Day : byte;
    Month : byte;
    Year : word;
  end;

  BTimeType = packed record
    Sec100   : Byte;
    Sec      : Byte;
    Min      : Byte;
    Hour     : Byte;
  end;

  TVersionDescriptor = packed record
    Version   : word;
    Revision  : word;
    PeerType  : byte;
  end;

  TFullVersion = array [1..3] of TVersionDescriptor;

  TLongVarDesc = packed record
    Length : cardinal;
    Offset : cardinal;
  end;

  TLVarBinDesc = TLongVarDesc;
  TLVarCharDesc = TLongVarDesc;

implementation
end.
