//*****************************************************************************
//
//    System          : BtrUtils
//    Category        : Data/Time convert routines
//    Source          : none
//
//    Copyright (c), Leonov Alexander
//
//    File version $Revision:1.3$ at $Date:28.01.2004 19:32:31$
//
//    Author : Leonov Alexander
//    web    : http://dev.zibn.net/     mirror at:  http://home.ural.ru/~tigra/
//    e-mail : dev@zibn.net
//
//*****************************************************************************

unit lBtrProc;

interface

Uses SysUtils, lBtrType;

function BDateToStr (ADate : BDateType) : string;
function BTimeToStr (ATime : BTimeType) : string;
function CompareBDate (ADate1, ADate2 : BDateType) : integer;
function CompareBTime (ATime1, ATime2 : BTimeType) : integer;
function BDateNow : BDateType;
function BTimeNow : BTimeType;
procedure BDateTimeNow (var ABDate : BDateType; var ABTime : BTimeType);
function EncodeBDate (ADate : TDateTime) : BDateType;
function EncodeBTime (ATime : TDateTime) : BTimeType;
function DecodeBDate (ADate : BDateType) : TDateTime;
function DecodeBTime (ATime : BTimeType) : TDateTime;
function StrToBDate (AStr : string) : BDateType;
function StrToBTime (AStr : string) : BTimeType;

implementation

function BDateToStr;
begin
  try
    Result := DateToStr ( EncodeDate (ADate.Year, ADate.Month, ADate.Day));
  except
    Result := IntToStr (ADate.Day) + DateSeparator +
              IntToStr (ADate.Month) + DateSeparator +
              IntToStr (ADate.Year);
  end
end;

function BTimeToStr;
begin
  try
    Result := TimeToStr (EncodeTime (ATime.Hour, ATime.Min, ATime.Sec, ATime.Sec100*10));
  except
    Result := IntToStr (ATime.Hour) + TimeSeparator +
              IntToStr (ATime.Min) + TimeSeparator +
              IntToStr (ATime.Sec) + TimeSeparator +
              IntToStr (ATime.Sec100*10);
  end;
end;

function CompareBDate;
begin
  Result := ADate1.Year-ADate2.Year;
  if Result <> 0 then
  begin
    if Result > 0
      then Result := 1
      else Result := -1;
    Exit;
  end;
  Result := ADate1.Month-ADate2.Month;
  if Result <> 0 then
  begin
    if Result > 0
      then Result := 1
      else Result := -1;
    Exit;
  end;
  Result := ADate1.Day-ADate2.Day;
  if Result <> 0 then
  begin
    if Result > 0
      then Result := 1
      else Result := -1;
  end;
end;

function CompareBTime;
begin
  Result := ATime1.Hour-ATime2.Hour;
  if Result <> 0 then
  begin
    if Result > 0
      then Result := 1
      else Result := -1;
    Exit;
  end;
  Result := ATime1.Min-ATime2.Min;
  if Result <> 0 then
  begin
    if Result > 0
      then Result := 1
      else Result := -1;
    Exit;
  end;
  Result := ATime1.Sec-ATime2.Sec;
  if Result <> 0 then
  begin
    if Result > 0
      then Result := 1
      else Result := -1;
    Exit;  
  end;
  Result := ATime1.Sec100-ATime2.Sec100;
  if Result <> 0 then
  begin
    if Result > 0
      then Result := 1
      else Result := -1;
  end;
end;

function BDateNow;
begin
  Result := EncodeBDate (Date);
end;

function BTimeNow;
begin
  Result := EncodeBTime (Time);
end;

procedure BDateTimeNow;
var
  dt : TDateTime;
begin
  dt := Now;
  ABDate := EncodeBDate (dt);
  ABTime := EncodeBTime (dt);
end;

function EncodeBDate;
var
  w1, w2, w3 : word;
begin
  DecodeDate (ADate, w1, w2, w3);
  Result.Year := w1;
  Result.Month := w2;
  Result.Day := w3;
end;

function EncodeBTime;
var
  w1, w2, w3, w4 : word;
begin
  DecodeTime (ATime, w1, w2, w3, w4);
  Result.Hour := w1;
  Result.Min := w2;
  Result.Sec := w3;
  Result.Sec100 := w4 div 10;
end;

function DecodeBDate (ADate : BDateType) : TDateTime;
begin
  try
    Result := EncodeDate (ADate.Year, ADate.Month, ADate.Day);
  except
    Result := 0;
  end;
end;

function DecodeBTime (ATime : BTimeType) : TDateTime;
begin
  try
    Result := EncodeTime (ATime.Hour, ATime.Min, ATime.Sec, ATime.Sec100 * 10);
  except
    Result := 0;
  end;
end;

function StrToBDate (AStr : string) : BDateType;
begin
  Result := EncodeBDate (StrToDate (AStr));
end;

function StrToBTime (AStr : string) : BTimeType;
begin
  Result := EncodeBTime (StrToTime (AStr));
end;

end.

