//*****************************************************************************
//
//    System          : BtrUtils
//    Category        : Exception for BtrUtils library
//    Source          : none
//
//    Copyright (c), Leonov Alexander
//
//    File version $Revision:1.3$ at $Date:28.01.2004 19:32:30$
//
//    Author : Leonov Alexander
//    web    : http://dev.zibn.net/     mirror at:  http://home.ural.ru/~tigra/
//    e-mail : dev@zibn.net
//
//*****************************************************************************

unit lBtrErr;

interface

Uses SysUtils;

Type
  EBtrieveException = class (Exception)
    private
      FErrorCode : integer;
    public
      constructor Create (AFileName : string; AErrorCode : integer);

      property ErrorCode : integer read FErrorCode;
  end;


implementation

Uses lBtrCnst, lBtrVar;

Const
  BtrConstToMsg : array [BTR_SUCCESS..BTR_DEVELOPERS_KIT] of string =(
      'BTR_SUCCESS',                     // BTR_SUCCESS                  = 00;      //  Sucessful operation
      'BTR_INVALID_OPERATION',           // BTR_INVALID_OPERATION        = 01;      //  Invalid operation
      'BTR_IOERROR',                     // BTR_IOERROR                  = 02;      //  Input/Output Error
      'BTR_FILE_NOT_OPEN',               // BTR_FILE_NOT_OPEN            = 03;      //  File not open
      'BTR_KEYNOTFOUND',                 // BTR_KEYNOTFOUND              = 04;      //  Key value not found
      'BTR_DUPLICATEKEY',                // BTR_DUPLICATEKEY             = 05;      //  Duplicate key value
      'BTR_BADKEYNO',                    // BTR_BADKEYNO                 = 06;      //  Invalid key number
      'BTR_DIFFERENT_KEY',               // BTR_DIFFERENT_KEY            = 07;      //  Different key number
      'BTR_INVALID_POSITION',            // BTR_INVALID_POSITION         = 08;      //  Invalid positioning
      'BTR_ENDOFFILE',                   // BTR_ENDOFFILE                = 09;      //  End of file
      'BTR_MOD_KEY_ERR',                 // BTR_MOD_KEY_ERR              = 10;      //  Modifiable key value error
      'BTR_INVALID_FILE_NAME',           // BTR_INVALID_FILE_NAME        = 11;      //  Invalid file name
      'BTR_FILE_NOT_FOUND',              // BTR_FILE_NOT_FOUND           = 12;      //  File not found
      'BTR_EXTENDED_FILE_ERROR',         // BTR_EXTENDED_FILE_ERROR      = 13;      //  Extended file error
      'BTR_PRE_IMAGE_OPEN_ERROR',        // BTR_PRE_IMAGE_OPEN_ERROR     = 14;      //  Pre-image open error
      'BTR_PRE_IMAGE_IO_ERROR',          // BTR_PRE_IMAGE_IO_ERROR       = 15;      //  Pre-image I/O error
      'BTR_EXPANSION_ERROR',             // BTR_EXPANSION_ERROR          = 16;      //  Expansion error
      'BTR_CLOSE_ERROR',                 // BTR_CLOSE_ERROR              = 17;      //  Close error
      'BTR_DISK_FULL',                   // BTR_DISK_FULL                = 18;      //  Disk full
      'BTR_UNRECOVERABLE_ERROR',         // BTR_UNRECOVERABLE_ERROR      = 19;      //  Unrecoverable error
      'BTR_RECORD_MGR_INACTIVE',         // BTR_RECORD_MGR_INACTIVE      = 20;      //  Record manager inactive
      'BTR_KEY_BUF_SHORT',               // BTR_KEY_BUF_SHORT            = 21;      //  Key buffer too short
      'BTR_WRONGBUFFERSIZE',             // BTR_WRONGBUFFERSIZE          = 22;      //  Data buffer length
      'BTR_POSITION_BLOCK_LENGTH',       // BTR_POSITION_BLOCK_LENGTH    = 23;      //  Position block length
      'BTR_PAGE_SIZE_ERROR',             // BTR_PAGE_SIZE_ERROR          = 24;      //  Page size error
      'BTR_CREATE_IO_ERROR',             // BTR_CREATE_IO_ERROR          = 25;      //  Create I/O error
      'BTR_NUMBER_OF_KEYS',              // BTR_NUMBER_OF_KEYS           = 26;      //  Number of keys
      'BTR_INVALID_KEY_POSITION',        // BTR_INVALID_KEY_POSITION     = 27;      //  Invalid key position
      'BTR_INVALID_RECORD_LENGTH',       // BTR_INVALID_RECORD_LENGTH    = 28;      //  Invalid record length
      'BTR_INVALID_KEY_LENGTH',          // BTR_INVALID_KEY_LENGTH       = 29;      //  Invalid key length
      'BTR_NOT_A_BTRIEVE_FILE',          // BTR_NOT_A_BTRIEVE_FILE       = 30;      //  Not a Btrieve file
      'BTR_FILE_ALREADY_EXTENDED',       // BTR_FILE_ALREADY_EXTENDED    = 31;      //  File already extended
      'BTR_EXTEND_IO_ERROR',             // BTR_EXTEND_IO_ERROR          = 32;      //  Extend I/O error
      '',
      'BTR_INVALID_EXTENSION_NAME',      // BTR_INVALID_EXTENSION_NAME   = 34;      //  Invalid extension name
      'BTR_DIRECTORY_ERROR',             // BTR_DIRECTORY_ERROR          = 35;      //  Directory error
      'BTR_TRANSACTION_ERROR',           // BTR_TRANSACTION_ERROR        = 36;      //  Transaction error
      'BTR_TRANSACTION_IS_ACTIVE',       // BTR_TRANSACTION_IS_ACTIVE    = 37;      //  Transaction is active
      'BTR_TRANSACTION_CTL_IO_ERR',      // BTR_TRANSACTION_CTL_IO_ERR   = 38;      //  Trans. control file I/O error
      'BTR_END_ABORT_TRANS_ERROR',       // BTR_END_ABORT_TRANS_ERROR    = 39;      //  End/Abort transaction error
      'BTR_TRANSACTION_MAX_FILES',       // BTR_TRANSACTION_MAX_FILES    = 40;      //  Transaction max files
      'BTR_OPERATION_NOT_ALLOWED',       // BTR_OPERATION_NOT_ALLOWED    = 41;      //  Operation not allowed
      'BTR_INCOMPL_ACCEL_ACCESS',        // BTR_INCOMPL_ACCEL_ACCESS     = 42;      //  Incomplete accelerated access
      'BTR_INVALID_RECORD_ADDRESS',      // BTR_INVALID_RECORD_ADDRESS   = 43;      //  Invalid record address
      'BTR_NULL_KEY_PATH',               // BTR_NULL_KEY_PATH            = 44;      //  Null key path
      'BTR_INCONSISTENT_KEY_FLAGS',      // BTR_INCONSISTENT_KEY_FLAGS   = 45;      //  Inconsistent key flags
      'BTR_ACCESS_DENIED',               // BTR_ACCESS_DENIED            = 46;      //  Access to file denied
      'BTR_MAX_OPEN_FILES',              // BTR_MAX_OPEN_FILES           = 47;      //  Maximum open files
      'BTR_INVALID_ALT_SEQ_DEF',         // BTR_INVALID_ALT_SEQ_DEF      = 48;      //  Bad alt. sequence definition
      'BTR_KEY_TYPE_ERROR',              // BTR_KEY_TYPE_ERROR           = 49;      //  Key type error
      'BTR_OWNER_ALREADY_SET',           // BTR_OWNER_ALREADY_SET        = 50;      //  Owner already set
      'BTR_INVALID_OWNER',               // BTR_INVALID_OWNER            = 51;      //  Invalid owner
      'BTR_WRITING_CACHE',               // BTR_WRITING_CACHE            = 52;      //  Error writing cache
      'BTR_INVALID_INTERFACE',           // BTR_INVALID_INTERFACE        = 53;      //  Invalid interface
      'BTR_VARIABLE_PAGE_ERROR',         // BTR_VARIABLE_PAGE_ERROR      = 54;      //  Variable page error
      'BTR_AUTOINCREMENT_ERROR',         // BTR_AUTOINCREMENT_ERROR      = 55;      //  Autoincrement error
      'BTR_INCOMPLETE_INDEX',            // BTR_INCOMPLETE_INDEX         = 56;      //  Incomplete index
      'BTR_EXPANDED_MEMORY_ERROR',       // BTR_EXPANDED_MEMORY_ERROR    = 57;      //  Expanded memory error
      'BTR_COMPRESS_BUF_TOO_SHORT',      // BTR_COMPRESS_BUF_TOO_SHORT   = 58;      //  Compression buffer too short
      'BTR_FILE_ALREADY_EXISTS',         // BTR_FILE_ALREADY_EXISTS      = 59;      //  File already exists
      'BTR_REJECT_COUNT_REACHED',        // BTR_REJECT_COUNT_REACHED     = 60;      //  Reject Count Reached
      'BTR_WORKSPACE_TOO_SMALL',         // BTR_WORKSPACE_TOO_SMALL      = 61;      //  WorkSpace too small
      'BTR_INCORRECT_DESCRIPTOR',        // BTR_INCORRECT_DESCRIPTOR     = 62;      //  Incorrect Descriptor
      'BTR_DATABUFF_ERR_EXT_INSERT',     // BTR_DATABUFF_ERR_EXT_INSERT  = 63;      //  Database Error on Extended Insert
      'BTR_FILTER_LIMIT_REACHED',        // BTR_FILTER_LIMIT_REACHED     = 64;      //  Filter limit reached
      'BTR_INCORRECT_FIELD_OFFSET',      // BTR_INCORRECT_FIELD_OFFSET   = 65;      //  Field offset is incorrect
      'BTR_MAXIMUM_NO_DATABASES',        // BTR_MAXIMUM_NO_DATABASES     = 66;      //  Maximun # of databases reached
      'BTR_CANNOT_OPEN_SQL_DICT',        // BTR_CANNOT_OPEN_SQL_DICT     = 67;      //  Cannot Open SQL Dictionaries
      'BTR_CANNOT_PERFORM_RI_DELETE',    // BTR_CANNOT_PERFORM_RI_DELETE = 68;      //  Can't complete RI Delete op
      'BTR_DELETE_ON_DAMAGED_FILE',      // BTR_DELETE_ON_DAMAGED_FILE   = 69;      //  Delete specified on damaged file
      '',
      'BTR_RI_DEFINITION_VIOLATION',     // BTR_RI_DEFINITION_VIOLATION  = 71;      //  RI Definition Violation
      'BTR_CANT_OPEN_RI_REFD_FILE',      // BTR_CANT_OPEN_RI_REFD_FILE   = 72;      //  Can't open RI referenced file
      'BTR_RI_REF_OUT_OF_SYNC',          // BTR_RI_REF_OUT_OF_SYNC       = 73;      //  RI reference out of sync
      'BTR_BTRIEVE_ABORTED_TRANS',       // BTR_BTRIEVE_ABORTED_TRANS    = 74;      //  Btrieve aborted Transaction
      '',
      'BTR_RI_FILE_CONFLICT',            // BTR_RI_FILE_CONFLICT         = 76;      //  RI File Conflict
      'BTR_APP_WAIT_ERROR',              // BTR_APP_WAIT_ERROR           = 77;      //  Application Wait Error
      'BTR_DEADLOCK',                    // BTR_DEADLOCK                 = 78;      //  Deadlock condition detected
      'BTR_PROGRAMMING_ERROR',           // BTR_PROGRAMMING_ERROR        = 79;      //  Programming Error
      'BTR_CONFLICT',                    // BTR_CONFLICT                 = 80;      //  Conflict
      'BTR_LOCK_ERROR',                  // BTR_LOCK_ERROR               = 81;      //  Lock error
      'BTR_LOST_POSITION',               // BTR_LOST_POSITION            = 82;      //  Lost position
      'BTR_READ_OUTSIDE_TRANS',          // BTR_READ_OUTSIDE_TRANS       = 83;      //  Read outside transaction
      'BTR_RECORD_IN_USE',               // BTR_RECORD_IN_USE            = 84;      //  Record in use
      'BTR_FILE_IN_USE',                 // BTR_FILE_IN_USE              = 85;      //  File in use
      'BTR_FILE_TABLE_FULL',             // BTR_FILE_TABLE_FULL          = 86;      //  File table full
      'BTR_HANDLE_TABLE_FULL',           // BTR_HANDLE_TABLE_FULL        = 87;      //  Handle table full
      'BTR_INCOMPATIBLE_OPEN_MODE',      // BTR_INCOMPATIBLE_OPEN_MODE   = 88;      //  Incompatible open mode
      '',
      '',
      'BTR_SERVER_ERROR',                // BTR_SERVER_ERROR             = 91;      //  Error on Server
      'BTR_TRANSACTION_TABLE_FULL',      // BTR_TRANSACTION_TABLE_FULL   = 92;      //  Transaction Table Full
      'BTR_INCOMPATIBLE_LOCK_TYPE',      // BTR_INCOMPATIBLE_LOCK_TYPE   = 93;      //  Incompatible lock type
      'BTR_PERMISSION_ERROR',            // BTR_PERMISSION_ERROR         = 94;      //  Permission error
      'BTR_SESSION_NOT_VALID',           // BTR_SESSION_NOT_VALID        = 95;      //  Session no longer valid
      'BTR_NETWARE_ERROR',               // BTR_NETWARE_ERROR            = 96;      //  Netware Btrieve error
      'BTR_DATA_BUFFER_TOO_SMALL',       // BTR_DATA_BUFFER_TOO_SMALL    = 97;      //  Btrieve Data buffer too small
      'BTR_INTERNAL_TRANS_ERROR',        // BTR_INTERNAL_TRANS_ERROR     = 98;      //  Internal Transaction Error
      'BTR_CANT_ACCESS_NET_RUNTIME',     // BTR_CANT_ACCESS_NET_RUNTIME  = 99;      //  Can't access Netware Runtime
      'BTR_NO_CACHE_BUFFERS',            // BTR_NO_CACHE_BUFFERS         = 100;     //  No Cache buffers
      'BTR_NO_SYSTEM_MEMORY',            // BTR_NO_SYSTEM_MEMORY         = 101;     //  No System memory available
      'BTR_NO_STACK_SPACE',              // BTR_NO_STACK_SPACE           = 102;     //  No Stack space
      'BTR_CHUNK_OFFSET_TOO_BIG',        // BTR_CHUNK_OFFSET_TOO_BIG     = 103;     //  Chunk Offset too big.
      'BTR_BAD_LOCALE',                  // BTR_BAD_LOCALE               = 104;     //  Locale not recognized
      'BTR_CANT_CREATE_WITH_VATS',       // BTR_CANT_CREATE_WITH_VATS    = 105;     //  File can't be created with VATs.
      'BTR_CHUNK_CANT_GET_NEXT',         // BTR_CHUNK_CANT_GET_NEXT      = 106;     //  Chunk can't perform get next
      'BTR_CHUNK_ON_PRE6_FILE',          // BTR_CHUNK_ON_PRE6_FILE       = 107;     //  Can't do chunk op on 5.XX file.
      '',
      'BTR_TRANSACTION_TO_COMPLEX',      // BTR_TRANSACTION_TO_COMPLEX   = 109;     //  Transaction too complex.
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      '',
      'BTR_NO_SYSTEM_LOCKS',             // BTR_NO_SYSTEM_LOCKS          = 130;     //  No system locks available.
      '',
      '',
      'BTR_DEVELOPERS_KIT');             // BTR_DEVELOPERS_KIT           = 133;     //  Developer's runtime used.

constructor EBtrieveException.Create;
var
  Msg : string;
  RealFileName : string;
begin
  if AErrorCode in [BTR_SUCCESS..BTR_DEVELOPERS_KIT] then
    Msg := BtrConstToMsg [AErrorCode] + '. '
  else Msg := '';

  if InExceptionUseFullPath then
    RealFileName := AFileName
  else RealFileName := ExtractFileName (AFileName);

  inherited CreateFmt ('%sBtrieve status : %d. Database : %s.', [Msg, AErrorCode, RealFileName]);

  FErrorCode := AErrorCode;
end;

end.

