//*****************************************************************************
//
//    System          : BtrUtils
//    Category        : Btrive constant declaration
//    Source          : Btrieve API programmers guide
//
//    Copyright (c), Leonov Alexander
//
//    File version $Revision:1.3$ at $Date:28.01.2004 19:32:30$
//
//    Author : Leonov Alexander
//    web    : http://dev.zibn.net/     mirror at:  http://home.ural.ru/~tigra/
//    e-mail : dev@zibn.net
//
//*****************************************************************************

unit lBtrCnst;

interface

const
// Btrieve Function calls 
  BTR_OPEN                      = 00;
  BTR_CLOSE                     = 01;
  BTR_INSERT                    = 02;
  BTR_UPDATE                    = 03;
  BTR_DELETE                    = 04;
  BTR_GET_EQUAL                 = 05;
  BTR_GET_NEXT                  = 06;
  BTR_GET_PREVIOUS              = 07;
  BTR_GET_GREATER               = 08;
  BTR_GET_GREATER_OR_EQUAL      = 09;
  BTR_GET_LESS_THAN             = 10;
  BTR_GET_LESS_THAN_OR_EQUAL    = 11;
  BTR_GET_FIRST                 = 12;
  BTR_GET_LAST                  = 13;
  BTR_CREATE                    = 14;
  BTR_STAT                      = 15;
  BTR_EXTEND                    = 16;
  BTR_SET_DIRECTORY             = 17;
  BTR_GET_DIRECTORY             = 18;
  BTR_BEGIN_TRANSACTION         = 19;
  BTR_END_TRANSACTION           = 20;
  BTR_ABORT_TRANSACTION         = 21;
  BTR_GET_POSITION              = 22;
  BTR_GET_DIRECT                = 23;
  BTR_STEP_NEXT                 = 24;
  BTR_STOP                      = 25;
  BTR_VERSION                   = 26;
  BTR_UNLOCK                    = 27;
  BTR_RESET                     = 28;
  BTR_SET_OWNER                 = 29;
  BTR_CLEAR_OWNER               = 30;
  BTR_ADD_INDEX                 = 31;
  BTR_DROP_INDEX                = 32;
  BTR_STEP_FIRST                = 33;
  BTR_STEP_LAST                 = 34;
  BTR_STEP_PREVIOUS             = 35;
  BTR_GET_NEXT_EXTENDED         = 36;
  BTR_GET_PREVIOUS_EXTENDED     = 37;
  BTR_STEP_NEXT_EXTENDED        = 38;
  BTR_STEP_PREVIOUS_EXTENDED    = 39;
  BTR_INSERT_EXTENDED           = 40;
  BTR_MISC_DATA                 = 41;
  BTR_CONTINUOUS_OPERATION      = 42;
  BTR_GET_BYPERCENTAGE          = 44;
  BTR_FIND_PERCENTAGE           = 45;
  BTR_KEY_ONLY                  = 50;
  BTR_UPDATE_CHUNK              = 53;
  BTR_EXTENDED_STAT             = 65;

  BTR_LOGIN                     = 78;
  BTR_LOGOUT                    = 78;


// Error code

  BTR_SUCCESS                  = 00;      //  Sucessful operation
  BTR_INVALID_OPERATION        = 01;      //  Invalid operation
  BTR_IOERROR                  = 02;      //  Input/Output Error
  BTR_FILE_NOT_OPEN            = 03;      //  File not open
  BTR_KEYNOTFOUND              = 04;      //  Key value not found
  BTR_DUPLICATEKEY             = 05;      //  Duplicate key value              
  BTR_BADKEYNO                 = 06;      //  Invalid key number               
  BTR_DIFFERENT_KEY            = 07;      //  Different key number             
  BTR_INVALID_POSITION         = 08;      //  Invalid positioning              
  BTR_ENDOFFILE                = 09;      //  End of file                      
  BTR_MOD_KEY_ERR              = 10;      //  Modifiable key value error       
  BTR_INVALID_FILE_NAME        = 11;      //  Invalid file name                
  BTR_FILE_NOT_FOUND           = 12;      //  File not found                   
  BTR_EXTENDED_FILE_ERROR      = 13;      //  Extended file error              
  BTR_PRE_IMAGE_OPEN_ERROR     = 14;      //  Pre-image open error             
  BTR_PRE_IMAGE_IO_ERROR       = 15;      //  Pre-image I/O error              
  BTR_EXPANSION_ERROR          = 16;      //  Expansion error                  
  BTR_CLOSE_ERROR              = 17;      //  Close error                      
  BTR_DISK_FULL                = 18;      //  Disk full                        
  BTR_UNRECOVERABLE_ERROR      = 19;      //  Unrecoverable error              
  BTR_RECORD_MGR_INACTIVE      = 20;      //  Record manager inactive          
  BTR_KEY_BUF_SHORT            = 21;      //  Key buffer too short             
  BTR_WRONGBUFFERSIZE          = 22;      //  Data buffer length               
  BTR_POSITION_BLOCK_LENGTH    = 23;      //  Position block length            
  BTR_PAGE_SIZE_ERROR          = 24;      //  Page size error                  
  BTR_CREATE_IO_ERROR          = 25;      //  Create I/O error                 
  BTR_NUMBER_OF_KEYS           = 26;      //  Number of keys                   
  BTR_INVALID_KEY_POSITION     = 27;      //  Invalid key position             
  BTR_INVALID_RECORD_LENGTH    = 28;      //  Invalid record length            
  BTR_INVALID_KEY_LENGTH       = 29;      //  Invalid key length               
  BTR_NOT_A_BTRIEVE_FILE       = 30;      //  Not a Btrieve file               
  BTR_FILE_ALREADY_EXTENDED    = 31;      //  File already extended            
  BTR_EXTEND_IO_ERROR          = 32;      //  Extend I/O error                 
  BTR_INVALID_EXTENSION_NAME   = 34;      //  Invalid extension name
  BTR_DIRECTORY_ERROR          = 35;      //  Directory error                  
  BTR_TRANSACTION_ERROR        = 36;      //  Transaction error                
  BTR_TRANSACTION_IS_ACTIVE    = 37;      //  Transaction is active            
  BTR_TRANSACTION_CTL_IO_ERR   = 38;      //  Trans. control file I/O error    
  BTR_END_ABORT_TRANS_ERROR    = 39;      //  End/Abort transaction error      
  BTR_TRANSACTION_MAX_FILES    = 40;      //  Transaction max files            
  BTR_OPERATION_NOT_ALLOWED    = 41;      //  Operation not allowed            
  BTR_INCOMPL_ACCEL_ACCESS     = 42;      //  Incomplete accelerated access    
  BTR_INVALID_RECORD_ADDRESS   = 43;      //  Invalid record address           
  BTR_NULL_KEY_PATH            = 44;      //  Null key path                    
  BTR_INCONSISTENT_KEY_FLAGS   = 45;      //  Inconsistent key flags           
  BTR_ACCESS_DENIED            = 46;      //  Access to file denied            
  BTR_MAX_OPEN_FILES           = 47;      //  Maximum open files               
  BTR_INVALID_ALT_SEQ_DEF      = 48;      //  Bad alt. sequence definition     
  BTR_KEY_TYPE_ERROR           = 49;      //  Key type error                   
  BTR_OWNER_ALREADY_SET        = 50;      //  Owner already set                
  BTR_INVALID_OWNER            = 51;      //  Invalid owner                    
  BTR_WRITING_CACHE            = 52;      //  Error writing cache              
  BTR_INVALID_INTERFACE        = 53;      //  Invalid interface                
  BTR_VARIABLE_PAGE_ERROR      = 54;      //  Variable page error              
  BTR_AUTOINCREMENT_ERROR      = 55;      //  Autoincrement error              
  BTR_INCOMPLETE_INDEX         = 56;      //  Incomplete index                 
  BTR_EXPANDED_MEMORY_ERROR    = 57;      //  Expanded memory error            
  BTR_COMPRESS_BUF_TOO_SHORT   = 58;      //  Compression buffer too short     
  BTR_FILE_ALREADY_EXISTS      = 59;      //  File already exists              

  BTR_REJECT_COUNT_REACHED     = 60;      //  Reject Count Reached             
  BTR_WORKSPACE_TOO_SMALL      = 61;      //  WorkSpace too small              
  BTR_INCORRECT_DESCRIPTOR     = 62;      //  Incorrect Descriptor
  BTR_DATABUFF_ERR_EXT_INSERT  = 63;      //  Database Error on Extended Insert
  BTR_FILTER_LIMIT_REACHED     = 64;      //  Filter limit reached             
  BTR_INCORRECT_FIELD_OFFSET   = 65;      //  Field offset is incorrect        
  BTR_MAXIMUM_NO_DATABASES     = 66;      //  Maximun # of databases reached   
  BTR_CANNOT_OPEN_SQL_DICT     = 67;      //  Cannot Open SQL Dictionaries     
  BTR_CANNOT_PERFORM_RI_DELETE = 68;      //  Can't complete RI Delete op      
  BTR_DELETE_ON_DAMAGED_FILE   = 69;      //  Delete specified on damaged file 
  BTR_RI_DEFINITION_VIOLATION  = 71;      //  RI Definition Violation          
  BTR_CANT_OPEN_RI_REFD_FILE   = 72;      //  Can't open RI referenced file    
  BTR_RI_REF_OUT_OF_SYNC       = 73;      //  RI reference out of sync         
  BTR_BTRIEVE_ABORTED_TRANS    = 74;      //  Btrieve aborted Transaction      
  BTR_RI_FILE_CONFLICT         = 76;      //  RI File Conflict                 
  BTR_APP_WAIT_ERROR           = 77;      //  Application Wait Error           
  BTR_DEADLOCK                 = 78;      //  Deadlock condition detected      
  BTR_PROGRAMMING_ERROR        = 79;      //  Programming Error                

  BTR_CONFLICT                 = 80;      //  Conflict                         
  BTR_LOCK_ERROR               = 81;      //  Lock error                       
  BTR_LOST_POSITION            = 82;      //  Lost position                    
  BTR_READ_OUTSIDE_TRANS       = 83;      //  Read outside transaction         
  BTR_RECORD_IN_USE            = 84;      //  Record in use
  BTR_FILE_IN_USE              = 85;      //  File in use
  BTR_FILE_TABLE_FULL          = 86;      //  File table full
  BTR_HANDLE_TABLE_FULL        = 87;      //  Handle table full
  BTR_INCOMPATIBLE_OPEN_MODE   = 88;      //  Incompatible open mode
  BTR_SERVER_ERROR             = 91;      //  Error on Server
  BTR_TRANSACTION_TABLE_FULL   = 92;      //  Transaction Table Full
  BTR_INCOMPATIBLE_LOCK_TYPE   = 93;      //  Incompatible lock type
  BTR_PERMISSION_ERROR         = 94;      //  Permission error

  BTR_SESSION_NOT_VALID        = 95;      //  Session no longer valid
  BTR_NETWARE_ERROR            = 96;      //  Netware Btrieve error
  BTR_DATA_BUFFER_TOO_SMALL    = 97;      //  Btrieve Data buffer too small
  BTR_INTERNAL_TRANS_ERROR     = 98;      //  Internal Transaction Error
  BTR_CANT_ACCESS_NET_RUNTIME  = 99;      //  Can't access Netware Runtime
  BTR_NO_CACHE_BUFFERS         = 100;     //  No Cache buffers
  BTR_NO_SYSTEM_MEMORY         = 101;     //  No System memory available
  BTR_NO_STACK_SPACE           = 102;     //  No Stack space
  BTR_CHUNK_OFFSET_TOO_BIG     = 103;     //  Chunk Offset too big.
  BTR_BAD_LOCALE               = 104;     //  Locale not recognized
  BTR_CANT_CREATE_WITH_VATS    = 105;     //  File can't be created with VATs.
  BTR_CHUNK_CANT_GET_NEXT      = 106;     //  Chunk can't perform get next
  BTR_CHUNK_ON_PRE6_FILE       = 107;     //  Can't do chunk op on 5.XX file.
  BTR_TRANSACTION_TO_COMPLEX   = 109;     //  Transaction too complex.
  BTR_NO_SYSTEM_LOCKS          = 130;     //  No system locks available.
  BTR_DEVELOPERS_KIT           = 133;     //  Developer's runtime used.

  BTR_DATABASE_LOGIN_REQUIRED  = 170;     //  Database login required (unknown user id).
  BTR_DATABASE_LOGIN_FAILED    = 171;     //  Database login failed (bad password).
  BTR_DATABASE_NAME_NOT_FOUND  = 172;     //  Database name not found.
  BTR_ALREADY_LOGGED_IN        = 173;     //  Already logged in.
  BTR_AN_EXPLICT_LOGIN_IS_REQUIRED = 174; //  An explicit login is required.
  BTR_WRONG_URI_FORMAT         = 175;     //  Wrong URI format.

  BTR_LOCK_PARAM_RANGE_ERR    = 1001;     //  Lock parameter out of range
  BTR_MEMORY_ALLOCATION_ERROR = 1002;     //  Memory allocation error
  BTR_INVALID_MEMORY_SIZE     = 1003;     //  Invalid memory size
  BTR_TEMP_DRIVE_INVALID      = 1005;     //  Pre-image/Lock drive invalid
  BTR_FILE_PARAM_RANGE_ERR    = 1007;     //  Open files parameter out of range
  BTR_INIT_PARAMETER_INVALID  = 1008;     //  Initialization parameter invalid
  BTR_TRANS_PARAMETER_INVALID = 1009;     //  Transaction filename invalid
  BTR_ACCESS_ERROR_ON_TRANS   = 1010;     //  Error accessing trans control file
  BTR_COMPRESS_BUFF_RANGE_ERR = 1011;     //  Compression buffer param invalid
  BTR_TASK_LIST_FULL          = 1013;     //  The task list is full
  BTR_STOP_WARNING            = 1014;     //  Stop Warning
  BTR_POINTER_ERROR           = 1015;     //  Pointer parameter error
  BTR_ALREADY_INITIALIZED     = 1016;     //  Btrieve already initialized
  BTR_WBTRVRES_NOT_FOUND      = 1017;     //  WBTRVRES.DLL not found.
  BTR_CALLBACK_ERROR          = 1018;     //  Op from callback attempted.
  BTR_CALLBACK_CANCELLED_OP   = 1019;     //  Callback cancelled operation.
  BTR_OS2_MEMORY_ALLOCATION   = 2001;     //  OS/2 - not enough memory.
  BTR_OS2_OPTION_INVALID      = 2002;     //  OS/2 - option invalid.
  BTR_NO_LOCAL_ACCESS         = 2003;     //  No local access with Requester.
  BTR_NO_SPX_INSTALLED        = 2004;     //  No SPX installed.
  BTR_INCORRECT_SPX           = 2005;     //  Incorrect SPX installed.
  BTR_NO_SPX_CONNECTION       = 2006;     //  No SPX Connection.
  BTR_POINTER_PARAM_ERROR     = 2007;     //  Pointer passed invalid.
  BTR_FIELD_CONVERSION_ERROR  = 2999;     //  Field could not be converted.

  BTR_UNKNOWN_SERVER          = 3103;     //  Unknown server.

  BTR_UNKNOWN_ERROR           = -1;

// Open Mode
  BTR_OPEN_NORMAL                     =  00;
  BTR_OPEN_ACCELERATED                = -01;
  BTR_OPEN_READ_ONLY                  = -02;
  BTR_OPEN_VERIFY                     = -03;
  BTR_OPEN_EXCLUSIVE                  = -04;

// undocumented open mode
  BTR_OPEN_SHARED_LOCKING             = -16;

// BIAS flag
  BTR_OPEN_SINGLE_ENGINE_FILE_SHARING = -32;
  BTR_OPEN_MULTI_ENGINE_FILE_SHARING  = -64;


// Lock type
  BTR_NO_LOCK_BIAS              = 0;
  BTR_SINGLE_WAIT_LOCK_BIAS     = 100;
  BTR_SINGLE_NOWAIT_LOCK_BIAS   = 200;
  BTR_MULTIPLE_WAIT_LOCK_BIAS   = 300;
  BTR_MULTIPLE_NOWAIT_LOCK_BIAS = 400;

// Transaction type
  BTR_EXCLUSIVE_BIAS  = 0;
  BTR_CONCURRENT_BIAS = 1000;

Const
  MaxKeyCount = 119;


Const
  VariableLength     = $01;
  BlankTruncation    = $02;
  Preallocation      = $04;
  DataCompression    = $08;
  KeyOnlyFile        = $10;
  IndexBalancedFile  = $20;
  FreeSpace10        = $40;
  FreeSpace20        = $80;
  FreeSpace30        = $C0;
  DuplicatePointers  = $100;
  KeyNumberSpecified = $400;
  VATUsedInFile      = $800;

  INCLUDE_SYSTEM_DATA     = $0200;
  NO_INCLUDE_SYSTEM_DATA  = $1200;

implementation
end.
