//_____________________________________________________________________________
//                                                                           
//    $ProjectName:L405Util$
//                                                                           
//    Copyright (c) SE "40.5"
//_____________________________________________________________________________
//                                                                           
//   $Revision:1.0$
//   $Date:22.04.2002 17:33:00$
//   $Author:Shura$
//_____________________________________________________________________________

{$APPTYPE CONSOLE}

program CopyBtr;

Uses SysUtils, Classes, lBtrieve, lBtrCnst;

var
  BtrOut : TBtrieve;
  BtrIn  : TBtrieve;
  ms : TMemoryStream;
  RecLen : integer;
  i : integer;
  k : integer;

begin
  if not (ParamCount in [2, 3]) then 
  begin
    Writeln ('Use CopyBtr.exe <BtrIn> <BtrOut> [OwnerName]');
    Halt;
  end;

  i := 0;
  k := 0;
  ms := TMemoryStream.Create;
  try
    BtrIn  := TBtrieve.Create;
    try
      BtrOut  := TBtrieve.Create;
      try
        BtrIn.Name := ParamStr (1);
        BtrOut.Name := ParamStr (2);
        BtrIn.Owner := ParamStr (3);
        BtrOut.Owner := ParamStr (3);

        BtrIn.UseChunkOperation := True;
        BtrOut.UseChunkOperation := True;
        BtrOut.OpenMode := BTR_OPEN_ACCELERATED;

        BtrIn.Open;
        BtrOut.Open;

        RecLen := BtrOut.RecSize;
        if RecLen > BtrIn.RecSize then
          RecLen := Btrin.RecSize;
        
        Write ('Process ', i, ' record(s)');
        if BtrIn.StepFirstRecord (ms) then
        repeat
          ms.Position := 0;
          FillChar (BtrOut.Data^, BtrOut.RecSize, 0);
          Move (BtrIn.Data^, BtrOut.Data^, RecLen);
          try
            BtrOut.InsertRecord (ms);
            inc (k);
          except
            on E : Exception do
               Writeln ('====== ', E.Message);
          end;
          inc (i);
          if (k mod 100) = 0 then
          begin
            Writeln;
            Write ('Process ', i, ' record(s)');
          end;
          if (k mod 5) = 0 then
            Write ('.');
          ms.Clear;
        until not BtrIn.StepNextRecord (ms);
        Writeln;
        Writeln ('Insert ', k, ' of ', i, ' record(s)');
      finally
        BtrOut.Free;
      end;
    finally
      BtrIn.Free;
    end;
  finally
    ms.Free;
  end;
end.

