{ ------------------------------------------------------------------------------
  TBoSpeedButton

  Author :     Author :   Boffi

  -----------------------------------------------------------------------------} 

unit BOButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, extCtrls, Db, DBCtrls;

type

//------------------------------------------------------------------------------
  TBoSpeedbutton = class(TSpeedbutton)
  private
    FRepeatTimer: TTimer;
    FBoRepeatClick : Boolean;
    fBoResBmpName : String;
    FBoValue: String;
    FBoValues: TStrings;
    FBoResBmpNames: TStrings;
    FBoCaptions: TStrings;
    procedure  TimerExpired(Sender: TObject);
    procedure  SetBoResBmpName( aValue : String );
    function   BoGlyphStored : boolean;
    function   GetGlyph : TBitmap;
    procedure  SetGlyph( aBitmap : TBitmap );
    procedure  SetBoValues(const Value: TStrings);
    procedure  SetBoResBmpNames(const Value: TStrings);
    procedure  SetBoCaptions(const Value: TStrings);
  protected
    procedure  SetBoValue(const Value: String); virtual;
    procedure  MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure  MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  public
    BoInitRepeatPause : integer;
    BoRepeatPause     : integer;
    procedure    Click; override;
    Constructor  Create(aOwner:TComponent); override;
    destructor   Destroy; override;
  published
    Property  BoValues : TStrings read FBoValues write SetBoValues;
    Property  BoResBmpNames : TStrings read FBoResBmpNames write SetBoResBmpNames;
    Property  BoCaptions : TStrings read fBoCaptions write SetBoCaptions;
    Property  BoRepeatClick : Boolean read fBoRepeatClick Write fBoRepeatClick default False;
    Property  BoValue : String read FBoValue write SetBoValue;
    Property  NumGlyphs default 2;
    Property  Glyph read GetGlyph write SetGlyph Stored BoGlyphStored;
    Property  BoResBmpName : String read fBoResBmpName  write SetBoResBmpName;
  end;

//------------------------------------------------------------------------------
  TBoDBSpeedbutton = class(TBoSpeedbutton)
  private
    FDatalink : TFieldDataLink;
    function    GetDatafield: string;
    function    GetDatasource: TDatasource;
    procedure   SetDatafield(const Value: string);
    procedure   SetDatasource(const Value: TDatasource);
    procedure   DataChange(Sender: TObject);
    procedure   CMExit(var Message: TCMExit); message CM_EXIT;
  protected
    procedure  SetBoValue(const Value: String); override;  
    procedure   Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
  published
    property    Datasource: TDatasource read GetDatasource write SetDatasource;
    property    Datafield: string read GetDatafield write SetDatafield;
  end;

implementation

procedure BoFillBitmapFromResource( aBitmap : TBitmap; aResourceName : String );
begin
  aBitmap.Handle := LoadBitmap(hInstance, PChar(aResourceName) );
end;

Constructor TBoSpeedbutton.Create(aOwner:TComponent);
begin
  inherited Create(aOwner);
  FBoValues := TStringlist.create;
  FBoResBmpNames := TStringlist.create;
  FBoCaptions := TStringlist.create;
  
  NumGlyphs  := 2;
  //--> Repeat timer
  fBoRepeatClick := False;
  BoInitRepeatPause := 400;
  BoRepeatPause     := 100;
end;

destructor TBoSpeedbutton.Destroy;
begin
  FBoValues.Free;
  FBoResBmpNames.Free;
  FBoCaptions.Free;
  if FRepeatTimer <> nil then
    FRepeatTimer.Free;
  inherited destroy;
end;

procedure TBoSpeedbutton.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  inherited MouseDown (Button, Shift, X, Y);
  if FBoRepeatClick then
  begin
    if FRepeatTimer = nil then
      FRepeatTimer := TTimer.Create(Self);
    FRepeatTimer.OnTimer := TimerExpired;
    FRepeatTimer.Interval := BoInitRepeatPause;
    FRepeatTimer.Enabled  := True;
  end;
end;

procedure TBoSpeedbutton.MouseUp(Button: TMouseButton; Shift: TShiftState;
                                  X, Y: Integer);
begin
  inherited MouseUp (Button, Shift, X, Y);
  if FRepeatTimer <> nil then
    FRepeatTimer.Enabled  := False;
end;

procedure TBoSpeedbutton.TimerExpired(Sender: TObject);
begin
  FRepeatTimer.Interval := BoRepeatPause;
  if (FState = bsDown) and MouseCapture then
  begin
    try
      Click;
    except
      FRepeatTimer.Enabled := False;
      raise;
    end;
  end;
end;

Function  TBoSpeedbutton.BoGlyphStored : boolean;
begin
  result := Trim(fBoResBmpName) = '';
end;

procedure TBoSpeedbutton.SetBoResBmpName( aValue : String );
begin
  fBoResBmpName := aValue;
  if trim(fBoResBmpName) <> '' then
    BoFillBitmapFromResource( inherited Glyph, fBoResBmpName );
end;

function TBoSpeedbutton.GetGlyph: TBitmap;
begin
  result := inherited Glyph;
end;

procedure TBoSpeedbutton.SetGlyph(aBitmap: TBitmap);
begin
  (inherited Glyph).assign(aBitmap);
  BoResBmpName := '';
end;

procedure TBoSpeedbutton.SetBoValue(const Value: String);
var
  Ind : integer;
begin
  Ind := FBoValues.IndexOf(Value);
  fBoValue := Value;
  if Ind <> -1 then
    begin
      //--> Resource bmp
      if Ind < FBoResBmpNames.Count then
        BoResBmpName := FBoResBmpNames[ind]
      else
        begin
          BoResBmpName := '';
          glyph.Assign(nil);
        end;
      //--> caption
      if Ind < FBoCaptions.Count then
        caption := FBoCaptions[ind]
      else
        caption := '';
    end
  else
    begin
      caption := '';
      BoResBmpName := '';
      glyph.Assign(nil);
    end;
end;

procedure TBoSpeedbutton.SetBoValues(const Value: TStrings);
begin
  FBoValues.assign( Value );
end;

procedure TBoSpeedbutton.SetBoResBmpNames(const Value: TStrings);
begin
  fBoResBmpNames.assign(value);
end;

procedure TBoSpeedbutton.Click;
var
  Ind : integer;
begin
  inherited Click;
  Ind := FBoValues.IndexOf(fBoValue);
  inc(ind);
  if ind >= FBoValues.Count then
    ind := 0;
  if ind < FBoValues.Count then
    BoValue := FBoValues[ind];
end;

procedure TBoSpeedbutton.SetBoCaptions(const Value: TStrings);
begin
  fBocaptions.assign(value);
end;

{ TBoDBSpeedbutton }

procedure TBoDBSpeedbutton.CMExit(var Message: TCMExit);
begin
  try
    FDataLink.UpdateRecord;
  except
    raise;
  end;
  inherited;
end;

constructor TBoDBSpeedbutton.Create(AOwner: TComponent);
begin
  inherited Create(aowner);
  //--> Datalink
  FDatalink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
end;

procedure TBoDBSpeedbutton.DataChange(Sender: TObject);
begin
  if Not Assigned(FDatalink.Field) then exit;
  inherited SetBoValue( FDatalink.Field.AsString );
end;

destructor TBoDBSpeedbutton.Destroy;
begin
  FDataLink.OnDataChange := Nil;
  FDataLink.Control := Nil;
  FDatalink.Free;
  FDatalink := nil;
  inherited Destroy;
end;

function TBoDBSpeedbutton.GetDatafield: string;
begin
  Result := FDatalink.FieldName;
end;

function TBoDBSpeedbutton.GetDatasource: TDatasource;
begin
  Result := FDatalink.Datasource;
end;

procedure TBoDBSpeedbutton.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;

procedure TBoDBSpeedbutton.SetBoValue(const Value: String);
begin
  if FDataLink.Edit then
  begin
    inherited SetBoValue(value);
    FDatalink.Field.AsString := inherited BoValue;
    FDataLink.Modified;
  end;
end;

procedure TBoDBSpeedbutton.SetDatafield(const Value: string);
begin
  FDatalink.FieldName := Value;
end;

procedure TBoDBSpeedbutton.SetDatasource(const Value: TDatasource);
begin
  FDatalink.Datasource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

end.

