unit bmpPanel;

{ Component: TbmpPanel

  Usage:
  TbmpPanel is a simple component I created out of a need to
  tile a textured bitmap image across a panel component.
  The result works rather nicely and is simple to use.
  By taking advantage of the transparent property of TLabel
  and the Flat property of TBitBtn I was able to get the desired
  effect.

  License:
  FREE FREE FREE...what more can I say....enjoy this component
  ..change it, modify it...whatever you wish...as long as you
  don't claim it is your own....

  Disclaimer:
  It's not my fault!  Use this component at your own risk!
  If it blows up your computer, your neighborhood or erases your
  entire life I'm not the one to blame!

  If you find this component useful, I would enjoy hearing about it!
  jjbull@swbell.net
}

interface

uses Windows, SysUtils, Messages, Classes, Controls, Graphics,
  StdCtrls, ExtCtrls, Forms, Dialogs, DsgnIntf;

const
  ComponentVersion = 'Version 1.5';

type
  TAbout = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TbmpPanel = class(TPanel)
  private
    FAbout : TAbout;
    FBitmap: TBitmap;
    procedure BitmapChanged(Sender: TObject);
    procedure SetBitmap(Value: TBitmap);
    procedure Paint; override;
    procedure WMEraseBkgnd(var m: TWMEraseBkgnd);
                           message WM_ERASEBKGND;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property About: TAbout read FAbout write FAbout;
    property Bitmap: TBitmap read FBitmap write SetBitmap;
  end;

  procedure Register;

implementation

{ TbmpPanel }
constructor TbmpPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBitmap := TBitmap.Create;
  FBitmap.OnChange := BitmapChanged;
end;

destructor TbmpPanel.Destroy;
begin
  FBitmap.Free;
  inherited Destroy;
end;

procedure TbmpPanel.BitmapChanged(Sender: TObject);
begin
  if HandleAllocated then
    RedrawWindow(Handle, nil, 0, RDW_INVALIDATE or
      RDW_ERASE or RDW_ALLCHILDREN);
end;

procedure TbmpPanel.SetBitmap(Value: TBitmap);
begin
  FBitmap.Assign(Value);
end;

procedure TbmpPanel.WMEraseBkgnd(var m : TWMEraseBkgnd);
begin
  m.Result := LRESULT(False);
end;

procedure TbmpPanel.Paint;
var
  x, y: Integer;
  bmWidth, bmHeight : Integer;
begin
  inherited paint;
  if not(FBitmap.Empty) then begin
    bmWidth := FBitmap.Width;
    bmHeight := FBitmap.Height;
    y := 0;
    while y < Height do begin
      x := 0;
      while x < Width do begin
        Canvas.Draw(x, y, FBitmap);
        x := x + bmHeight;
      end;
      y := y + bmHeight;
    end;
  end;
end;

procedure TAbout.Edit;
var
  Str : String;
begin
  Str := Format('TbmpPanel %s by J.Bull 2000',[ComponentVersion]);
  Application.MessageBox( PChar(Str),
    'About This Component', MB_OK or MB_ICONINFORMATION);
end;

function TAbout.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout.GetValue: string;
begin
  Result := '(About)';
end;

procedure Register;
begin
 RegisterComponents('jbull', [TbmpPanel]);
 RegisterPropertyEditor(TypeInfo(TAbout), TbmpPanel, 'ABOUT', TAbout);
end;

end.
 