////////////////////////////////////////////////////////////////////////////////
//   BM Hopeless Productions proudly presents competely freeware:
//---------------------------------------------------------------------------
//
//_Name: 		TBMHTMLHelp;
//_Version:		98.10.01;
//_Description:		Implementation of HTML help enclosed in single component;
//_Type:		HELP;
//_Comment:  		Easy to use and edit HTML Help system;
//_C:    		You need only 3 steps:;
//_C:    		1. Put attached dll (MBHTMLHelp.dll) on path;
//_C:                   2. Install the component;
//_C:                   3. Put the component on Your project main form setting HTMLDataBaseNameProperty;
//_C:			to path for file Help.db and HTML files with HELP;
//_C:    		That's all. Need more help - start the Help :);
//_Words:		api,help,html,ie;
//_Sources:		P; (C,P,J)
//_Inheritance:     	TComponent;
//_Author:		Mark Bisz, mbisz@friko2.onet.pl,none;
//_URL:			none; internet url to loook for new versions
//_Properties:
//_P:Service:           enable/disable service functions;
//_P:Auto:              Enables automatic setup (default)
//_P:HTMLDatabaseName:  path to HTML db file (Help.db) and html help files;
//_P:HTMLEditor:        path to HTML editor;
//_M:ShowHTMLHelp(HELPID:integer) shows help file with given id (helpcontext);
//---------------------------------------------------------------------------
unit BMHTMLHelp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

function ShowHelp(hAppHandle:THandle;HELPID: Integer; HELPPATH:PChar): Integer;
 external 'BMHTMLHelp.dll' name 'ShowHelp';

function SetService(service:boolean): boolean;
 external 'BMHTMLHelp.dll' name 'SetService';

procedure CloseTables;
 external 'BMHTMLHelp.dll' name 'CloseTables';


type
  TBMHTMLHelp = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
    FOnHelp:THelpEvent;
    FAuto:boolean;
    FService:boolean;
    FHTMLDatabaseName:string;
    procedure wService(n:boolean);
    function DoHelp(Command: Word; Data: Longint;   var CallHelp: Boolean): Boolean;
  public
    { Public declarations }
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    function ShowHTMLHelp(HELPID:integer):integer;
  published
    { Published declarations }
    property Auto:boolean read FAuto write FAuto;
    property Service:boolean read FService write wService;
    property HTMLDatabaseName:string read FHTMLDatabaseName write FHTMLDatabaseName;
  end;

procedure Register;

implementation

constructor TBMHTMLHelp.Create(AOwner:TComponent);
begin
inherited Create(AOwner);
FAuto:=true;
FService:=true;
FHTMLDatabaseName:='.';
SetService(FService);
FOnHelp:=Application.OnHelp;
if not (csDesigning in ComponentState) then
   begin
   Application.OnHelp:=DoHelp;
   end;
end;

destructor TBMHTMLHelp.Destroy;
begin
CloseTables;
Application.OnHelp:=FOnHelp;
inherited Destroy;
end;

function TBMHTMLHelp.ShowHTMLHelp(HELPID:integer):integer;
var
  i:integer;
  pc:array [0..300] of char;
begin
strpcopy(pc,HTMLDataBaseName);
i:=length(HTMLDataBaseName)-1;
if ((pc[i]='\') or (pc[i]='/')) then pc[i]:=#0;
Result:=ShowHelp(Application.Handle,HELPID,pc);
end;

function TBMHTMLHelp.DoHelp(Command: Word; Data: Longint;   var CallHelp: Boolean): Boolean;
begin
if ((Auto) and not (csDesigning in ComponentState)) then
   ShowHTMLHelp(Data);
if Assigned(FOnHelp) then FOnHelp(Command,Data,CallHelp);
end;

procedure TBMHTMLHelp.wService(n:boolean);
begin
SetService(n);
FService:=n;
end;


procedure Register;
begin
  RegisterComponents('BM', [TBMHTMLHelp]);
end;

end.
