unit example1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolEdit, RXCtrls, StdCtrls, Mask, ExtCtrls, BladeDll;

type
  TWaveHeader = record
    Marker1:        Array[0..3] of Char;
    BytesFollowing: LongInt;
    Marker2:        Array[0..3] of Char;
    Marker3:        Array[0..3] of Char;
    Fixed1:         LongInt;
    FormatTag:      Word;
    Channels:       Word;
    SampleRate:     LongInt;
    BytesPerSecond: LongInt;
    BytesPerSample: Word;
    BitsPerSample:  Word;
    Marker4:        Array[0..3] of Char;
    DataBytes:      LongInt;
   end;

  TForm1 = class(TForm)
    ProgressBar1: TProgressBar;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    GroupBox2: TGroupBox;
    RxLabel1: TRxLabel;
    FilenameEdit1: TFilenameEdit;
    RxLabel2: TRxLabel;
    DirectoryEdit1: TDirectoryEdit;
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure FilenameEdit1AfterDialog(Sender: TObject; var Name: String;
      var Action: Boolean);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
    inFile,
    outFile : TFileStream;
    OutputFileName : string;
    Config         : TBE_CONFIG;
    StopPressed    : Boolean;
  public
    { Public declarations }
    WaveHeader : TWaveHeader;
    function FormGetSampleRate : integer;
    function FormGetMode       : integer;
    function FormGetBitrate    : integer;
    procedure FormSetMode(Channels : word);
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}

function TForm1.FormGetSampleRate : integer;
begin
  result := 0;
  case RadioGroup1.ItemIndex of
    0 : result := 48000;
    1 : result := 44100;
    2 : result := 32000; 
  end;
end;

function TForm1.FormGetMode : integer;
begin
  result := 0;
  case RadioGroup2.ItemIndex of
    0 : Result := BE_MP3_MODE_STEREO;
    1 : Result := BE_MP3_MODE_DUALCHANNEL;
    2 : Result := BE_MP3_MODE_MONO;
  end;
end;

function TForm1.FormGetBitrate : integer;
begin
  result := 0;
  Case RadioGroup3.ItemIndex of
     0 : result := 32;
     1 : Result := 40;
     2 : Result := 48;
     3 : Result := 56;
     4 : Result := 64;
     5 : Result := 80;
     6 : Result := 96;
     7 : Result := 112;
     8 : Result := 128;
     9 : Result := 160;
    10 : Result := 192;
    11 : Result := 224;
    12 : Result := 256;
    13 : Result := 320;
  end;
end;

procedure TForm1.FormSetMode(Channels : word);
begin
  RadioGroup2.ItemIndex := Channels-1;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Err : BE_ERR;
  hbeStream : HBE_STREAM;
  dwSamples, dwMP3Buffer : DWORD;
  pMP3Buffer : PByte;
  pBuffer    : PShort;
  SamplesToRead,
  Mp3SamplesToWrite : DWORD;
begin
  {create filename}
  StopPressed := false;
  if DirectoryEdit1.Text[Length(DirectoryEdit1.Text)] <> '\' then
    OutputFileName := DirectoryEdit1.LongName+'\'+ChangeFileExt(ExtractFileName(FileNameEdit1.filename),'.mp3')
  else
    OutputFileName := DirectoryEdit1.LongName+ChangeFileExt(ExtractFileName(FileNameEdit1.filename),'.mp3');

  inFile := TFileStream.Create(FileNameEdit1.FileName, fmOpenRead);
  //read past waveinformation.
  inFile.Read(WaveHeader,SizeOf(Waveheader));

  OutFile := TFileStream.Create(OutputFileName, fmCreate or fmOpenWrite);

  ProgressBar1.Min := 0;
  ProgressBar1.Max := InFile.Size;
  ProgressBar1.Position := 0;

  Config.dwConfig := BE_CONFIG_MP3;
  Config.MP3.dwSampleRate := FormGetSampleRate;
  Config.MP3.byMode       := FormGetMode;
  Config.MP3.wBitrate     := FormGetBitrate;
  Config.Mp3.bPrivate     := CheckBox1.Checked;
  Config.Mp3.bCRC         := CheckBox2.Checked;
  Config.Mp3.bCopyright   := CheckBox3.Checked;
  Config.Mp3.bOriginal    := CheckBox4.Checked;

  err := beInitStream(Config, dwSamples, dwMp3Buffer, hbeStream);
  if Err <> BE_ERR_SUCCESSFUL then
  begin
    MessageDlg('Could not open Encoding stream',mtError,[MbOk],0);
    InFile.Free;
    OutFile.Free;
    Exit;
  end;
  Screen.Cursor := crHourGlass;
  GetMem(pMP3Buffer,dwMp3Buffer);
  GetMem(pBuffer,dwSamples);
  while (InFile.position < InFile.Size) and (Not StopPressed) do begin
     if ((InFile.Position + (dwSamples * 2)) < InFile.Size) then
       SamplesToRead := dwSamples * 2 //Stereo assumed
     else
       SamplesToRead := InFile.Size - InFile.Position;

     InFile.Read(pBuffer^,SamplesToRead);

     err := beEncodeChunk(hbeStream, SamplesToRead div 2 , pBuffer, pMp3Buffer, Mp3SamplesToWrite);
     if err <> BE_ERR_SUCCESSFUL then
     begin
       beCloseStream(hbeStream);
       MessageDlg('beEncodeChunck failed',mtError,[MbOk],0);
       inFile.Free;
       outFile.Free;
       FreeMem(pMP3Buffer);
       FreeMem(pBuffer);
       Screen.Cursor := crDefault;
       Exit;
     end;
     OutFile.Write(pMp3Buffer^,Mp3SamplesToWrite);
     ProgressBar1.Position := InFile.Position;
     Application.ProcessMessages;
  end;
  Err := beDeInitStream(hbeStream,pMp3Buffer,mp3SamplesToWrite);
  if Err <> BE_ERR_SUCCESSFUL then
    MessageDlg('beDeInitStream failed',mtError,[MbOk],0)
  else
    OutFile.Write(pMP3Buffer^,mp3SamplesToWrite);
  beCloseStream(hbeStream);
  FreeMem(pMP3Buffer);
  FreeMem(pBuffer);
  InFile.Free;
  OutFile.Free;
  Screen.Cursor := crDefault;
  if CheckBox5.Checked then
    DeleteFile(FileNameEdit1.FileName);
  ShowMessage('Done');  
end;

procedure TForm1.FilenameEdit1AfterDialog(Sender: TObject; var Name: String; var Action: Boolean);
begin
 If (DirectoryEdit1.Text <> '') and (Name <> '') then begin
   Button1.Enabled := True;
   Button2.Enabled := True;
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  StopPressed := True;
end;

end.
